/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.blocks;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.common.TileGeneric;
import dan200.computercraft.shared.computer.blocks.ComputerPeripheral;
import dan200.computercraft.shared.computer.blocks.ComputerProxy;
import dan200.computercraft.shared.computer.blocks.TileComputerBase;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.turtle.apis.TurtleAPI;
import dan200.computercraft.shared.turtle.blocks.BlockTurtle;
import dan200.computercraft.shared.turtle.blocks.ITurtleTile;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import dan200.computercraft.shared.turtle.inventory.ContainerTurtle;
import dan200.computercraft.shared.util.CapabilityUtil;
import dan200.computercraft.shared.util.DefaultInventory;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.InventoryUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileTurtle
extends TileComputerBase
implements ITurtleTile,
DefaultInventory {
    public static final int INVENTORY_SIZE = 16;
    public static final int INVENTORY_WIDTH = 4;
    public static final int INVENTORY_HEIGHT = 4;
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> previousInventory = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
    private final IItemHandlerModifiable itemHandler = new InvWrapper((IInventory)this);
    private LazyOptional<IItemHandlerModifiable> itemHandlerCap;
    private boolean inventoryChanged = false;
    private TurtleBrain brain = new TurtleBrain(this);
    private MoveState moveState = MoveState.NOT_MOVED;
    private LazyOptional<IPeripheral> peripheral;

    public TileTurtle(TileEntityType<? extends TileGeneric> type, ComputerFamily family) {
        super(type, family);
    }

    private boolean hasMoved() {
        return this.moveState == MoveState.MOVED;
    }

    @Override
    protected ServerComputer createComputer(int instanceID, int id) {
        ServerComputer computer = new ServerComputer(this.func_145831_w(), id, this.label, instanceID, this.getFamily(), 39, 13);
        computer.setPosition(this.func_174877_v());
        computer.addAPI(new TurtleAPI(computer.getAPIEnvironment(), this.getAccess()));
        this.brain.setupComputer(computer);
        return computer;
    }

    public ComputerProxy createProxy() {
        return this.brain.getProxy();
    }

    @Override
    public void destroy() {
        block3: {
            block2: {
                if (this.hasMoved()) break block2;
                super.destroy();
                if (this.func_145831_w().field_72995_K) break block3;
                int size = this.func_70302_i_();
                for (int i = 0; i < size; ++i) {
                    ItemStack stack = this.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    WorldUtil.dropItemStack(stack, this.func_145831_w(), this.func_174877_v());
                }
                break block3;
            }
            for (Direction dir : DirectionUtil.FACINGS) {
                RedstoneUtil.propagateRedstoneOutput(this.func_145831_w(), this.func_174877_v(), dir);
            }
        }
    }

    @Override
    protected void unload() {
        if (!this.hasMoved()) {
            super.unload();
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandlerCap = CapabilityUtil.invalidate(this.itemHandlerCap);
        this.peripheral = CapabilityUtil.invalidate(this.peripheral);
    }

    @Override
    @Nonnull
    public ActionResultType onActivate(PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack currentItem = player.func_184586_b(hand);
        if (!currentItem.func_190926_b()) {
            if (currentItem.func_77973_b() instanceof DyeItem) {
                if (!this.func_145831_w().field_72995_K) {
                    DyeColor dye = ((DyeItem)currentItem.func_77973_b()).func_195962_g();
                    if (this.brain.getDyeColour() != dye) {
                        this.brain.setDyeColour(dye);
                        if (!player.func_184812_l_()) {
                            currentItem.func_190918_g(1);
                        }
                    }
                }
                return ActionResultType.SUCCESS;
            }
            if (currentItem.func_77973_b() == Items.field_151131_as && this.brain.getColour() != -1) {
                if (!this.func_145831_w().field_72995_K && this.brain.getColour() != -1) {
                    this.brain.setColour(-1);
                    if (!player.func_184812_l_()) {
                        player.func_184611_a(hand, new ItemStack((IItemProvider)Items.field_151133_ar));
                        player.field_71071_by.func_70296_d();
                    }
                }
                return ActionResultType.SUCCESS;
            }
        }
        return super.onActivate(player, hand, hit);
    }

    @Override
    protected boolean canNameWithTag(PlayerEntity player) {
        return true;
    }

    @Override
    protected double getInteractRange(PlayerEntity player) {
        return 12.0;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.brain.update();
        if (!this.func_145831_w().field_72995_K && this.inventoryChanged) {
            ServerComputer computer = this.getServerComputer();
            if (computer != null) {
                computer.queueEvent("turtle_inventory");
            }
            this.inventoryChanged = false;
            for (int n = 0; n < this.func_70302_i_(); ++n) {
                this.previousInventory.set(n, (Object)this.func_70301_a(n).func_77946_l());
            }
        }
    }

    @Override
    protected void updateBlockState(ComputerState newState) {
    }

    @Override
    public void onNeighbourChange(@Nonnull BlockPos neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.onNeighbourChange(neighbour);
        }
    }

    @Override
    public void onNeighbourTileEntityChange(@Nonnull BlockPos neighbour) {
        if (this.moveState == MoveState.NOT_MOVED) {
            super.onNeighbourTileEntityChange(neighbour);
        }
    }

    public void notifyMoveStart() {
        if (this.moveState == MoveState.NOT_MOVED) {
            this.moveState = MoveState.IN_PROGRESS;
        }
    }

    public void notifyMoveEnd() {
        if (this.moveState == MoveState.IN_PROGRESS) {
            this.moveState = MoveState.NOT_MOVED;
        }
    }

    @Override
    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        ListNBT nbttaglist = nbt.func_150295_c("Items", 10);
        this.inventory.clear();
        this.previousInventory.clear();
        for (int i = 0; i < nbttaglist.size(); ++i) {
            CompoundNBT tag = nbttaglist.func_150305_b(i);
            int slot = tag.func_74771_c("Slot") & 0xFF;
            if (slot >= this.func_70302_i_()) continue;
            this.inventory.set(slot, (Object)ItemStack.func_199557_a((CompoundNBT)tag));
            this.previousInventory.set(slot, (Object)((ItemStack)this.inventory.get(slot)).func_77946_l());
        }
        this.brain.readFromNBT(nbt);
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT nbt) {
        ListNBT nbttaglist = new ListNBT();
        for (int i = 0; i < 16; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.inventory.get(i)).func_77955_b(tag);
            nbttaglist.add((Object)tag);
        }
        nbt.func_218657_a("Items", (INBT)nbttaglist);
        nbt = this.brain.writeToNBT(nbt);
        return super.func_189515_b(nbt);
    }

    @Override
    protected boolean isPeripheralBlockedOnSide(ComputerSide localSide) {
        return this.hasPeripheralUpgradeOnSide(localSide);
    }

    @Override
    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)BlockTurtle.FACING);
    }

    public void setDirection(Direction dir) {
        if (dir.func_176740_k() == Direction.Axis.Y) {
            dir = Direction.NORTH;
        }
        this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)BlockTurtle.FACING, (Comparable)dir));
        this.updateOutput();
        this.updateInput();
        this.onTileEntityChange();
    }

    @Override
    public ITurtleUpgrade getUpgrade(TurtleSide side) {
        return this.brain.getUpgrade(side);
    }

    @Override
    public int getColour() {
        return this.brain.getColour();
    }

    @Override
    public ResourceLocation getOverlay() {
        return this.brain.getOverlay();
    }

    @Override
    public ITurtleAccess getAccess() {
        return this.brain;
    }

    @Override
    public Vector3d getRenderOffset(float f) {
        return this.brain.getRenderOffset(f);
    }

    @Override
    public float getRenderYaw(float f) {
        return this.brain.getVisualYaw(f);
    }

    @Override
    public float getToolRenderAngle(TurtleSide side, float f) {
        return this.brain.getToolRenderAngle(side, f);
    }

    void setOwningPlayer(GameProfile player) {
        this.brain.setOwningPlayer(player);
        this.func_70296_d();
    }

    public int func_70302_i_() {
        return 16;
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < 16 ? (ItemStack)this.inventory.get(slot) : ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70304_b(int slot) {
        ItemStack result = this.func_70301_a(slot);
        this.func_70299_a(slot, ItemStack.field_190927_a);
        return result;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int count) {
        if (count == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = this.func_70301_a(slot);
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (stack.func_190916_E() <= count) {
            this.func_70299_a(slot, ItemStack.field_190927_a);
            return stack;
        }
        ItemStack part = stack.func_77979_a(count);
        this.onInventoryDefinitelyChanged();
        return part;
    }

    public void func_70299_a(int i, @Nonnull ItemStack stack) {
        if (i >= 0 && i < 16 && !InventoryUtil.areItemsEqual(stack, (ItemStack)this.inventory.get(i))) {
            this.inventory.set(i, (Object)stack);
            this.onInventoryDefinitelyChanged();
        }
    }

    public void func_174888_l() {
        boolean changed = false;
        for (int i = 0; i < 16; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
            changed = true;
        }
        if (changed) {
            this.onInventoryDefinitelyChanged();
        }
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.inventoryChanged) {
            for (int n = 0; n < this.func_70302_i_(); ++n) {
                if (ItemStack.func_77989_b((ItemStack)this.func_70301_a(n), (ItemStack)((ItemStack)this.previousInventory.get(n)))) continue;
                this.inventoryChanged = true;
                break;
            }
        }
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        return this.isUsable(player, false);
    }

    private void onInventoryDefinitelyChanged() {
        super.func_70296_d();
        this.inventoryChanged = true;
    }

    public void onTileEntityChange() {
        super.func_70296_d();
    }

    @Override
    protected void writeDescription(@Nonnull CompoundNBT nbt) {
        super.writeDescription(nbt);
        this.brain.writeDescription(nbt);
    }

    @Override
    protected void readDescription(@Nonnull CompoundNBT nbt) {
        super.readDescription(nbt);
        this.brain.readDescription(nbt);
    }

    private boolean hasPeripheralUpgradeOnSide(ComputerSide side) {
        ITurtleUpgrade upgrade;
        switch (side) {
            case RIGHT: {
                upgrade = this.getUpgrade(TurtleSide.RIGHT);
                break;
            }
            case LEFT: {
                upgrade = this.getUpgrade(TurtleSide.LEFT);
                break;
            }
            default: {
                return false;
            }
        }
        return upgrade != null && upgrade.getType().isPeripheral();
    }

    public void transferStateFrom(TileTurtle copy) {
        super.transferStateFrom(copy);
        Collections.copy(this.inventory, copy.inventory);
        Collections.copy(this.previousInventory, copy.previousInventory);
        this.inventoryChanged = copy.inventoryChanged;
        this.brain = copy.brain;
        this.brain.setOwner(this);
        copy.moveState = MoveState.MOVED;
        copy.peripheral = CapabilityUtil.invalidate(copy.peripheral);
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.itemHandlerCap == null) {
                this.itemHandlerCap = LazyOptional.of(() -> new InvWrapper((IInventory)this));
            }
            return this.itemHandlerCap.cast();
        }
        if (cap == Capabilities.CAPABILITY_PERIPHERAL) {
            if (this.hasMoved()) {
                return LazyOptional.empty();
            }
            if (this.peripheral == null) {
                this.peripheral = LazyOptional.of(() -> new ComputerPeripheral("turtle", this.createProxy()));
            }
            return this.peripheral.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public Container createMenu(int id, @Nonnull PlayerInventory inventory, @Nonnull PlayerEntity player) {
        return new ContainerTurtle(id, inventory, this.brain);
    }

    static enum MoveState {
        NOT_MOVED,
        IN_PROGRESS,
        MOVED;

    }
}

