/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import dan200.computercraft.data.RecipeWrapper;
import dan200.computercraft.data.Tags;
import dan200.computercraft.shared.PocketUpgrades;
import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.TurtleUpgrades;
import dan200.computercraft.shared.common.ColourableRecipe;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.media.recipes.DiskRecipe;
import dan200.computercraft.shared.media.recipes.PrintoutRecipe;
import dan200.computercraft.shared.pocket.items.PocketComputerItemFactory;
import dan200.computercraft.shared.pocket.recipes.PocketComputerUpgradeRecipe;
import dan200.computercraft.shared.turtle.items.TurtleItemFactory;
import dan200.computercraft.shared.turtle.recipes.TurtleUpgradeRecipe;
import dan200.computercraft.shared.util.Colour;
import dan200.computercraft.shared.util.ImpostorRecipe;
import dan200.computercraft.shared.util.ImpostorShapelessRecipe;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Blocks;
import net.minecraft.data.CustomRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;

public class Recipes
extends RecipeProvider {
    public Recipes(DataGenerator generator) {
        super(generator);
    }

    protected void func_200404_a(@Nonnull Consumer<IFinishedRecipe> add) {
        this.basicRecipes(add);
        this.diskColours(add);
        this.pocketUpgrades(add);
        this.turtleUpgrades(add);
        Recipes.addSpecial(add, PrintoutRecipe.SERIALIZER);
        Recipes.addSpecial(add, DiskRecipe.SERIALIZER);
        Recipes.addSpecial(add, ColourableRecipe.SERIALIZER);
        Recipes.addSpecial(add, TurtleUpgradeRecipe.SERIALIZER);
        Recipes.addSpecial(add, PocketComputerUpgradeRecipe.SERIALIZER);
    }

    private void diskColours(@Nonnull Consumer<IFinishedRecipe> add) {
        for (Colour colour : Colour.VALUES) {
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModItems.DISK.get())).func_203221_a((ITag)Tags.Items.DUSTS_REDSTONE).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)DyeItem.func_195961_a((DyeColor)Recipes.ofColour(colour))).func_200490_a("computercraft:disk").func_200483_a("has_drive", (ICriterionInstance)Recipes.inventoryChange((IItemProvider)Registry.ModBlocks.DISK_DRIVE.get())).func_200485_a(RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add, x -> x.func_74768_a("Color", colour.getHex())), new ResourceLocation("computercraft", "disk_" + (colour.ordinal() + 1)));
        }
    }

    private void turtleUpgrades(@Nonnull Consumer<IFinishedRecipe> add) {
        for (ComputerFamily family : ComputerFamily.values()) {
            ItemStack base = TurtleItemFactory.create(-1, null, -1, family, null, null, 0, null);
            if (base.func_190926_b()) continue;
            String nameId = family.name().toLowerCase(Locale.ROOT);
            TurtleUpgrades.getVanillaUpgrades().forEach(upgrade -> {
                ItemStack result = TurtleItemFactory.create(-1, null, -1, family, null, upgrade, -1, null);
                ShapedRecipeBuilder.func_200470_a((IItemProvider)result.func_77973_b()).func_200473_b(String.format("%s:turtle_%s", "computercraft", nameId)).func_200472_a("#T").func_200462_a(Character.valueOf('#'), (IItemProvider)base.func_77973_b()).func_200462_a(Character.valueOf('T'), (IItemProvider)upgrade.getCraftingItem().func_77973_b()).func_200465_a("has_items", (ICriterionInstance)Recipes.inventoryChange(new IItemProvider[]{base.func_77973_b(), upgrade.getCraftingItem().func_77973_b()})).func_200467_a(RecipeWrapper.wrap(ImpostorRecipe.SERIALIZER, add, result.func_77978_p()), new ResourceLocation("computercraft", String.format("turtle_%s/%s/%s", nameId, upgrade.getUpgradeID().func_110624_b(), upgrade.getUpgradeID().func_110623_a())));
            });
        }
    }

    private void pocketUpgrades(@Nonnull Consumer<IFinishedRecipe> add) {
        for (ComputerFamily family : ComputerFamily.values()) {
            ItemStack base = PocketComputerItemFactory.create(-1, null, -1, family, null);
            if (base.func_190926_b()) continue;
            String nameId = family.name().toLowerCase(Locale.ROOT);
            PocketUpgrades.getVanillaUpgrades().forEach(upgrade -> {
                ItemStack result = PocketComputerItemFactory.create(-1, null, -1, family, null);
                ShapedRecipeBuilder.func_200470_a((IItemProvider)result.func_77973_b()).func_200473_b(String.format("%s:pocket_%s", "computercraft", nameId)).func_200472_a("#").func_200472_a("P").func_200462_a(Character.valueOf('#'), (IItemProvider)base.func_77973_b()).func_200462_a(Character.valueOf('P'), (IItemProvider)upgrade.getCraftingItem().func_77973_b()).func_200465_a("has_items", (ICriterionInstance)Recipes.inventoryChange(new IItemProvider[]{base.func_77973_b(), upgrade.getCraftingItem().func_77973_b()})).func_200467_a(RecipeWrapper.wrap(ImpostorRecipe.SERIALIZER, add, result.func_77978_p()), new ResourceLocation("computercraft", String.format("pocket_%s/%s/%s", nameId, upgrade.getUpgradeID().func_110624_b(), upgrade.getUpgradeID().func_110623_a())));
            });
        }
    }

    private void basicRecipes(@Nonnull Consumer<IFinishedRecipe> add) {
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)Registry.ModItems.CABLE.get()), (int)6).func_200472_a(" # ").func_200472_a("#R#").func_200472_a(" # ").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200465_a("has_modem", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.COMPUTER_NORMAL.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_redstone", (ICriterionInstance)Recipes.inventoryChange((ITag<Item>)Tags.Items.DUSTS_REDSTONE)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.COMPUTER_ADVANCED.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_components", (ICriterionInstance)Recipes.inventoryChange(new IItemProvider[]{Items.field_151137_ax, Items.field_151043_k})).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.COMPUTER_COMMAND.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('R'), (IItemProvider)Blocks.field_150483_bI).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_components", (ICriterionInstance)Recipes.inventoryChange(new IItemProvider[]{Blocks.field_150483_bI})).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.DISK_DRIVE.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#R#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.MONITOR_NORMAL.get())).func_200472_a("###").func_200472_a("#G#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200468_a((IItemProvider)((IItemProvider)Registry.ModBlocks.MONITOR_ADVANCED.get()), (int)4).func_200472_a("###").func_200472_a("#G#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModItems.POCKET_COMPUTER_NORMAL.get())).func_200472_a("###").func_200472_a("#A#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_151153_ao).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200465_a("has_apple", (ICriterionInstance)Recipes.inventoryChange(new IItemProvider[]{Items.field_151153_ao})).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModItems.POCKET_COMPUTER_ADVANCED.get())).func_200472_a("###").func_200472_a("#A#").func_200472_a("#G#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('A'), (IItemProvider)Items.field_151153_ao).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS_PANES).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200465_a("has_apple", (ICriterionInstance)Recipes.inventoryChange(new IItemProvider[]{Items.field_151153_ao})).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.PRINTER.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("#D#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200469_a(Character.valueOf('D'), (ITag)Tags.Items.DYES).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.SPEAKER.get())).func_200472_a("###").func_200472_a("#N#").func_200472_a("#R#").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200462_a(Character.valueOf('N'), (IItemProvider)Blocks.field_196586_al).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModItems.WIRED_MODEM.get())).func_200472_a("###").func_200472_a("#R#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('R'), (ITag)Tags.Items.DUSTS_REDSTONE).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200465_a("has_cable", (ICriterionInstance)Recipes.inventoryChange((IItemProvider)Registry.ModItems.CABLE.get())).func_200464_a(add);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModBlocks.WIRED_MODEM_FULL.get())).func_200487_b((IItemProvider)Registry.ModItems.WIRED_MODEM.get()).func_200483_a("has_modem", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.WIRED_MODEM)).func_200485_a(add, new ResourceLocation("computercraft", "wired_modem_full_from"));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModItems.WIRED_MODEM.get())).func_200487_b((IItemProvider)Registry.ModBlocks.WIRED_MODEM_FULL.get()).func_200483_a("has_modem", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.WIRED_MODEM)).func_200485_a(add, new ResourceLocation("computercraft", "wired_modem_full_to"));
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.WIRELESS_MODEM_NORMAL.get())).func_200472_a("###").func_200472_a("#E#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('E'), (ITag)Tags.Items.ENDER_PEARLS).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200464_a(add);
        ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)Registry.ModBlocks.WIRELESS_MODEM_ADVANCED.get())).func_200472_a("###").func_200472_a("#E#").func_200472_a("###").func_200469_a(Character.valueOf('#'), (ITag)Tags.Items.INGOTS_GOLD).func_200462_a(Character.valueOf('E'), (IItemProvider)Items.field_151061_bv).func_200465_a("has_computer", (ICriterionInstance)Recipes.inventoryChange(Tags.CCTags.COMPUTER)).func_200465_a("has_wireless", (ICriterionInstance)Recipes.inventoryChange((IItemProvider)Registry.ModBlocks.WIRELESS_MODEM_NORMAL.get())).func_200464_a(add);
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196184_dx).func_203221_a((ITag)Tags.Items.HEADS).func_200487_b((IItemProvider)Registry.ModItems.MONITOR_NORMAL.get()).func_200483_a("has_monitor", (ICriterionInstance)Recipes.inventoryChange((IItemProvider)Registry.ModItems.MONITOR_NORMAL.get())).func_200485_a(RecipeWrapper.wrap(IRecipeSerializer.field_222158_b, add, Recipes.playerHead("Cloudhunter", "6d074736-b1e9-4378-a99b-bd8777821c9c")), new ResourceLocation("computercraft", "skull_cloudy"));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)Items.field_196184_dx).func_203221_a((ITag)Tags.Items.HEADS).func_200487_b((IItemProvider)Registry.ModItems.COMPUTER_ADVANCED.get()).func_200483_a("has_computer", (ICriterionInstance)Recipes.inventoryChange((IItemProvider)Registry.ModItems.COMPUTER_ADVANCED.get())).func_200485_a(RecipeWrapper.wrap(IRecipeSerializer.field_222158_b, add, Recipes.playerHead("dan200", "f3c8d69b-0776-4512-8434-d1b2165909eb")), new ResourceLocation("computercraft", "skull_dan200"));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModItems.PRINTED_PAGES.get())).func_200491_b((IItemProvider)Registry.ModItems.PRINTED_PAGE.get(), 2).func_203221_a((ITag)Tags.Items.STRING).func_200483_a("has_printer", (ICriterionInstance)Recipes.inventoryChange((IItemProvider)Registry.ModBlocks.PRINTER.get())).func_200482_a(RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add));
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)Registry.ModItems.PRINTED_BOOK.get())).func_203221_a((ITag)Tags.Items.LEATHER).func_200491_b((IItemProvider)Registry.ModItems.PRINTED_PAGE.get(), 1).func_203221_a((ITag)Tags.Items.STRING).func_200483_a("has_printer", (ICriterionInstance)Recipes.inventoryChange((IItemProvider)Registry.ModBlocks.PRINTER.get())).func_200482_a(RecipeWrapper.wrap(ImpostorShapelessRecipe.SERIALIZER, add));
    }

    private static DyeColor ofColour(Colour colour) {
        return DyeColor.func_196056_a((int)(15 - colour.ordinal()));
    }

    private static InventoryChangeTrigger.Instance inventoryChange(ITag<Item> stack) {
        return InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.func_200309_a().func_200307_a(stack).func_200310_b()});
    }

    private static InventoryChangeTrigger.Instance inventoryChange(IItemProvider ... stack) {
        return InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])stack);
    }

    private static CompoundNBT playerHead(String name, String uuid) {
        CompoundNBT owner = new CompoundNBT();
        owner.func_74778_a("Name", name);
        owner.func_74778_a("Id", uuid);
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("SkullOwner", (INBT)owner);
        return tag;
    }

    private static void addSpecial(Consumer<IFinishedRecipe> add, SpecialRecipeSerializer<?> special) {
        CustomRecipeBuilder.func_218656_a(special).func_200499_a(add, special.getRegistryName().toString());
    }
}

