/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.turtle.event;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.event.TurtleAction;
import dan200.computercraft.api.turtle.event.TurtleBlockEvent;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.items.IItemHandler;

public abstract class TurtleInventoryEvent
extends TurtleBlockEvent {
    private final IItemHandler handler;

    protected TurtleInventoryEvent(@Nonnull ITurtleAccess turtle, @Nonnull TurtleAction action, @Nonnull FakePlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable IItemHandler handler) {
        super(turtle, action, player, world, pos);
        this.handler = handler;
    }

    @Nullable
    public IItemHandler getItemHandler() {
        return this.handler;
    }

    public static class Drop
    extends TurtleInventoryEvent {
        private final ItemStack stack;

        public Drop(@Nonnull ITurtleAccess turtle, @Nonnull FakePlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable IItemHandler handler, @Nonnull ItemStack stack) {
            super(turtle, TurtleAction.DROP, player, world, pos, handler);
            Objects.requireNonNull(stack, "stack cannot be null");
            this.stack = stack;
        }

        @Nonnull
        public ItemStack getStack() {
            return this.stack;
        }
    }

    public static class Suck
    extends TurtleInventoryEvent {
        public Suck(@Nonnull ITurtleAccess turtle, @Nonnull FakePlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nullable IItemHandler handler) {
            super(turtle, TurtleAction.SUCK, player, world, pos, handler);
        }
    }
}

