/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.tile;

import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import vectorwing.farmersdelight.blocks.StoveBlock;
import vectorwing.farmersdelight.mixin.accessors.RecipeManagerAccessor;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.FDSyncedTileEntity;
import vectorwing.farmersdelight.utils.ItemUtils;

public class StoveTileEntity
extends FDSyncedTileEntity
implements ITickableTileEntity {
    private static final VoxelShape GRILLING_AREA = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final int INVENTORY_SLOT_COUNT = 6;
    private final ItemStackHandler inventory = this.createHandler();
    private final int[] cookingTimes = new int[6];
    private final int[] cookingTimesTotal = new int[6];
    private ResourceLocation[] lastRecipeIDs = new ResourceLocation[6];

    public StoveTileEntity() {
        super((TileEntityType)ModTileEntityTypes.STOVE_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        if (compound.func_74764_b("Inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("Inventory"));
        } else {
            this.inventory.deserializeNBT(compound);
        }
        if (compound.func_150297_b("CookingTimes", 11)) {
            int[] arrayCookingTimes = compound.func_74759_k("CookingTimes");
            System.arraycopy(arrayCookingTimes, 0, this.cookingTimes, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimes.length));
        }
        if (compound.func_150297_b("CookingTotalTimes", 11)) {
            int[] arrayCookingTimesTotal = compound.func_74759_k("CookingTotalTimes");
            System.arraycopy(arrayCookingTimesTotal, 0, this.cookingTimesTotal, 0, Math.min(this.cookingTimesTotal.length, arrayCookingTimesTotal.length));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeItems(compound);
        compound.func_74783_a("CookingTimes", this.cookingTimes);
        compound.func_74783_a("CookingTotalTimes", this.cookingTimesTotal);
        return compound;
    }

    private CompoundNBT writeItems(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        return compound;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        boolean isStoveLit = (Boolean)this.func_195044_w().func_177229_b((Property)StoveBlock.LIT);
        if (this.field_145850_b.field_72995_K) {
            if (isStoveLit) {
                this.addParticles();
            }
        } else if (this.isStoveBlockedAbove()) {
            if (!ItemUtils.isInventoryEmpty((IItemHandler)this.inventory)) {
                ItemUtils.dropItems(this.field_145850_b, this.field_174879_c, (IItemHandler)this.inventory);
                this.inventoryChanged();
            }
        } else if (isStoveLit) {
            this.cookAndOutputItems();
        } else {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                if (this.cookingTimes[i] <= 0) continue;
                this.cookingTimes[i] = MathHelper.func_76125_a((int)(this.cookingTimes[i] - 2), (int)0, (int)this.cookingTimesTotal[i]);
            }
        }
    }

    private void cookAndOutputItems() {
        if (this.field_145850_b == null) {
            return;
        }
        boolean didInventoryChange = false;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack resultStack;
            ItemStack stoveStack = this.inventory.getStackInSlot(i);
            if (stoveStack.func_190926_b()) continue;
            int n = i;
            this.cookingTimes[n] = this.cookingTimes[n] + 1;
            if (this.cookingTimes[i] < this.cookingTimesTotal[i]) continue;
            Inventory inventoryWrapper = new Inventory(new ItemStack[]{stoveStack});
            Optional<CampfireCookingRecipe> recipe = this.getMatchingRecipe((IInventory)inventoryWrapper, i);
            if (recipe.isPresent() && !(resultStack = recipe.get().func_77571_b()).func_190926_b()) {
                ItemUtils.spawnItemEntity(this.field_145850_b, resultStack.func_77946_l(), (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, this.field_145850_b.field_73012_v.nextGaussian() * (double)0.01f, 0.1f, this.field_145850_b.field_73012_v.nextGaussian() * (double)0.01f);
            }
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            didInventoryChange = true;
        }
        if (didInventoryChange) {
            this.inventoryChanged();
        }
    }

    public boolean addItem(ItemStack itemStackIn) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            Optional<CampfireCookingRecipe> recipe;
            ItemStack slotStack = this.inventory.getStackInSlot(i);
            if (!slotStack.func_190926_b() || !(recipe = this.getMatchingRecipe((IInventory)new Inventory(new ItemStack[]{itemStackIn}), i)).isPresent()) continue;
            this.cookingTimesTotal[i] = recipe.get().func_222137_e();
            this.cookingTimes[i] = 0;
            this.inventory.setStackInSlot(i, itemStackIn.func_77979_a(1));
            this.lastRecipeIDs[i] = recipe.get().func_199560_c();
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    private Optional<CampfireCookingRecipe> getMatchingRecipe(IInventory recipeWrapper, int slot) {
        IRecipe recipe;
        if (this.field_145850_b == null) {
            return Optional.empty();
        }
        if (this.lastRecipeIDs[slot] != null && (recipe = ((RecipeManagerAccessor)this.field_145850_b.func_199532_z()).getRecipeMap(IRecipeType.field_222153_e).get(this.lastRecipeIDs[slot])) instanceof CampfireCookingRecipe && recipe.func_77569_a(recipeWrapper, this.field_145850_b)) {
            return Optional.of((CampfireCookingRecipe)recipe);
        }
        recipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222153_e, recipeWrapper, this.field_145850_b);
        if (recipe.isPresent()) {
            this.lastRecipeIDs[slot] = ((CampfireCookingRecipe)recipe.get()).func_199560_c();
            return recipe;
        }
        return Optional.empty();
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean isStoveBlockedAbove() {
        if (this.field_145850_b != null) {
            BlockState above = this.field_145850_b.func_180495_p(this.field_174879_c.func_177984_a());
            return VoxelShapes.func_197879_c((VoxelShape)GRILLING_AREA, (VoxelShape)above.func_196954_c((IBlockReader)this.field_145850_b, this.field_174879_c.func_177984_a()), (IBooleanFunction)IBooleanFunction.field_223238_i_);
        }
        return false;
    }

    public Vector2f getStoveItemOffset(int index) {
        float X_OFFSET = 0.3f;
        float Y_OFFSET = 0.2f;
        Vector2f[] OFFSETS = new Vector2f[]{new Vector2f(0.3f, 0.2f), new Vector2f(0.0f, 0.2f), new Vector2f(-0.3f, 0.2f), new Vector2f(0.3f, -0.2f), new Vector2f(0.0f, -0.2f), new Vector2f(-0.3f, -0.2f)};
        return OFFSETS[index];
    }

    private void addParticles() {
        if (this.field_145850_b == null) {
            return;
        }
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b() || !(this.field_145850_b.field_73012_v.nextFloat() < 0.2f)) continue;
            Vector2f stoveItemVector = this.getStoveItemOffset(i);
            Direction direction = (Direction)this.func_195044_w().func_177229_b((Property)StoveBlock.field_185512_D);
            int directionIndex = direction.func_176736_b();
            Vector2f offset = directionIndex % 2 == 0 ? stoveItemVector : new Vector2f(stoveItemVector.field_189983_j, stoveItemVector.field_189982_i);
            double x = (double)this.field_174879_c.func_177958_n() + 0.5 - (double)((float)direction.func_82601_c() * offset.field_189982_i) + (double)((float)direction.func_176746_e().func_82601_c() * offset.field_189982_i);
            double y = (double)this.field_174879_c.func_177956_o() + 1.0;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5 - (double)((float)direction.func_82599_e() * offset.field_189983_j) + (double)((float)direction.func_176746_e().func_82599_e() * offset.field_189983_j);
            for (int k = 0; k < 3; ++k) {
                this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.writeItems(new CompoundNBT());
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(6){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
    }
}

