/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.blocks;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import vectorwing.farmersdelight.blocks.state.CookingPotSupport;
import vectorwing.farmersdelight.registry.ModSounds;
import vectorwing.farmersdelight.registry.ModTileEntityTypes;
import vectorwing.farmersdelight.tile.CookingPotTileEntity;
import vectorwing.farmersdelight.utils.MathUtils;
import vectorwing.farmersdelight.utils.TextUtils;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class CookingPotBlock
extends HorizontalBlock
implements IWaterLoggable {
    public static final EnumProperty<CookingPotSupport> SUPPORT = EnumProperty.func_177709_a((String)"support", CookingPotSupport.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0);
    protected static final VoxelShape SHAPE_WITH_TRAY = VoxelShapes.func_197872_a((VoxelShape)SHAPE, (VoxelShape)Block.func_208617_a((double)0.0, (double)-1.0, (double)0.0, (double)16.0, (double)0.0, (double)16.0));

    public CookingPotBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(0.8f, 6.0f).func_200947_a(SoundType.field_222475_v));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a(SUPPORT, (Comparable)((Object)CookingPotSupport.NONE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult result) {
        ItemStack heldStack = player.func_184586_b(handIn);
        if (heldStack.func_190926_b() && player.func_225608_bj_()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(SUPPORT, (Comparable)((Object)(((CookingPotSupport)((Object)state.func_177229_b(SUPPORT))).equals((Object)CookingPotSupport.HANDLE) ? this.getTrayState((IWorld)world, pos) : CookingPotSupport.HANDLE))));
            world.func_184133_a(null, pos, SoundEvents.field_219640_fO, SoundCategory.BLOCKS, 0.7f, 1.0f);
        } else if (!world.field_72995_K) {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof CookingPotTileEntity) {
                CookingPotTileEntity cookingPotEntity = (CookingPotTileEntity)tileEntity;
                ItemStack servingStack = cookingPotEntity.useHeldItemOnMeal(heldStack);
                if (servingStack != ItemStack.field_190927_a) {
                    if (!player.field_71071_by.func_70441_a(servingStack)) {
                        player.func_71019_a(servingStack, false);
                    }
                    world.func_184133_a(null, pos, SoundEvents.field_187719_p, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)cookingPotEntity, (BlockPos)pos);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.SUCCESS;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((CookingPotSupport)((Object)state.func_177229_b(SUPPORT))).equals((Object)CookingPotSupport.TRAY) ? SHAPE_WITH_TRAY : SHAPE;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        FluidState fluid = world.func_204610_c(context.func_195995_a());
        BlockState state = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.func_206886_c() == Fluids.field_204546_a));
        if (context.func_196000_l().equals((Object)Direction.DOWN)) {
            return (BlockState)state.func_206870_a(SUPPORT, (Comparable)((Object)CookingPotSupport.HANDLE));
        }
        return (BlockState)state.func_206870_a(SUPPORT, (Comparable)((Object)this.getTrayState((IWorld)world, pos)));
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (facing.func_176740_k().equals((Object)Direction.Axis.Y) && !((CookingPotSupport)((Object)state.func_177229_b(SUPPORT))).equals((Object)CookingPotSupport.HANDLE)) {
            return (BlockState)state.func_206870_a(SUPPORT, (Comparable)((Object)this.getTrayState(world, currentPos)));
        }
        return state;
    }

    private CookingPotSupport getTrayState(IWorld world, BlockPos pos) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c().func_203417_a(ModTags.TRAY_HEAT_SOURCES)) {
            return CookingPotSupport.TRAY;
        }
        return CookingPotSupport.NONE;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, BlockState state) {
        ItemStack stack = super.func_185473_a(worldIn, pos, state);
        CookingPotTileEntity cookingPotEntity = (CookingPotTileEntity)worldIn.func_175625_s(pos);
        if (cookingPotEntity != null) {
            CompoundNBT nbt = cookingPotEntity.writeMeal(new CompoundNBT());
            if (!nbt.isEmpty()) {
                stack.func_77983_a("BlockEntityTag", (INBT)nbt);
            }
            if (cookingPotEntity.func_145818_k_()) {
                stack.func_200302_a(cookingPotEntity.func_200201_e());
            }
        }
        return stack;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof CookingPotTileEntity) {
                CookingPotTileEntity cookingPotEntity = (CookingPotTileEntity)tileEntity;
                InventoryHelper.func_219961_a((World)worldIn, (BlockPos)pos, cookingPotEntity.getDroppableInventory());
                cookingPotEntity.grantStoredRecipeExperience(worldIn, Vector3d.func_237489_a_((Vector3i)pos));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT nbt = stack.func_179543_a("BlockEntityTag");
        if (nbt != null) {
            CompoundNBT inventoryTag = nbt.func_74775_l("Inventory");
            if (inventoryTag.func_150297_b("Items", 9)) {
                ItemStackHandler handler = new ItemStackHandler();
                handler.deserializeNBT(inventoryTag);
                ItemStack mealStack = handler.getStackInSlot(6);
                if (!mealStack.func_190926_b()) {
                    IFormattableTextComponent textServingsOf = mealStack.func_190916_E() == 1 ? TextUtils.getTranslation("tooltip.cooking_pot.single_serving", new Object[0]) : TextUtils.getTranslation("tooltip.cooking_pot.many_servings", mealStack.func_190916_E());
                    tooltip.add((ITextComponent)textServingsOf.func_240699_a_(TextFormatting.GRAY));
                    IFormattableTextComponent textMealName = mealStack.func_200301_q().func_230532_e_();
                    tooltip.add((ITextComponent)textMealName.func_240699_a_(mealStack.func_77953_t().field_77937_e));
                }
            }
        } else {
            IFormattableTextComponent textEmpty = TextUtils.getTranslation("tooltip.cooking_pot.empty", new Object[0]);
            tooltip.add((ITextComponent)textEmpty.func_240699_a_(TextFormatting.GRAY));
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{field_185512_D, SUPPORT, WATERLOGGED});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileEntity tileEntity;
        if (stack.func_82837_s() && (tileEntity = worldIn.func_175625_s(pos)) instanceof CookingPotTileEntity) {
            ((CookingPotTileEntity)tileEntity).setCustomName(stack.func_200301_q());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CookingPotTileEntity && ((CookingPotTileEntity)tileEntity).isHeated()) {
            CookingPotTileEntity cookingPotEntity = (CookingPotTileEntity)tileEntity;
            SoundEvent boilSound = !cookingPotEntity.getMeal().func_190926_b() ? (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL_SOUP.get() : (SoundEvent)ModSounds.BLOCK_COOKING_POT_BOIL.get();
            double x = (double)pos.func_177958_n() + 0.5;
            double y = pos.func_177956_o();
            double z = (double)pos.func_177952_p() + 0.5;
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a(x, y, z, boilSound, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.2f + 0.9f, false);
            }
        }
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof CookingPotTileEntity) {
            ItemStackHandler inventory = ((CookingPotTileEntity)tileEntity).getInventory();
            return MathUtils.calcRedstoneFromItemHandler((IItemHandlerModifiable)inventory);
        }
        return 0;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModTileEntityTypes.COOKING_POT_TILE.get()).func_200968_a();
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

