/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.partyparrots.common;

import me.ichun.mods.partyparrots.client.core.TwerkHandler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="partyparrots")
public class PartyParrots {
    public static final String MOD_ID = "partyparrots";
    public static final String MOD_NAME = "Party Parrots";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Config config;

    public PartyParrots() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::setupConfig);
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> LOGGER.log(Level.ERROR, "You are loading Party Parrots on a server. Party Parrots is a client only mod!"));
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
    }

    private void setupConfig() {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        config = new Config(configBuilder);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, configBuilder.build(), "partyparrots.toml");
    }

    public class Config {
        public final ForgeConfigSpec.BooleanValue partyShoulder;
        public final ForgeConfigSpec.BooleanValue partyFlying;
        public final ForgeConfigSpec.BooleanValue partyStanding;
        public final ForgeConfigSpec.BooleanValue partySitting;
        public final ForgeConfigSpec.BooleanValue partyTwerk;
        public final ForgeConfigSpec.DoubleValue partyTwerkRange;
        private boolean twerkHandlerRegistered = false;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.comment("Party settings").push("party");
            this.partyShoulder = builder.comment("Do parrots party when they're on your shoulder?").translation("config.partyparrots.prop.partyShoulder.desc").define("partyShoulder", true);
            this.partyFlying = builder.comment("Do parrots party when they're flying?").translation("config.partyparrots.prop.partyFlying.desc").define("partyFlying", true);
            this.partyStanding = builder.comment("Do parrots party when they're standing?").translation("config.partyparrots.prop.partyStanding.desc").define("partyStanding", true);
            this.partySitting = builder.comment("Do parrots party when they're sitting?").translation("config.partyparrots.prop.partySitting.desc").define("partySitting", false);
            this.partyTwerk = builder.comment("Do parrots party when players twerk?").translation("config.partyparrots.prop.partyTwerk.desc").define("partyTwerk", false);
            this.partyTwerkRange = builder.comment("How far do players have to be twerking for parrots to PARTY?!").translation("config.partyparrots.prop.partyTwerkRange.desc").defineInRange("partyTwerkRange", 5.0, 2.0, 32.0);
            builder.pop();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigReload);
        }

        private void onConfigLoad(ModConfig.Loading event) {
            this.registerTwerkHandler();
        }

        private void onConfigReload(ModConfig.Reloading event) {
            this.registerTwerkHandler();
        }

        public void registerTwerkHandler() {
            if (!this.twerkHandlerRegistered) {
                this.twerkHandlerRegistered = true;
                MinecraftForge.EVENT_BUS.register((Object)new TwerkHandler());
            }
        }
    }
}

