/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.libmc.detail;

import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.Logger;

public class PlayerBlockInteraction {
    public static void init(String modid, Logger logger) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, PlayerInteractEvent.class, PlayerBlockInteraction::onPlayerInteract);
    }

    public static void onPlayerInteract(PlayerInteractEvent event) {
        boolean is_lclick;
        World world = event.getWorld();
        if (world.func_201670_d()) {
            return;
        }
        boolean is_rclick = event instanceof PlayerInteractEvent.RightClickBlock && event.getHand() == Hand.MAIN_HAND;
        boolean bl = is_lclick = event instanceof PlayerInteractEvent.LeftClickBlock && event.getHand() == Hand.MAIN_HAND && event.getFace() != Direction.DOWN;
        if (!is_rclick && !is_lclick) {
            return;
        }
        BlockPos fromPos = event.getPos();
        for (Direction facing : Direction.values()) {
            if (event.getFace() == facing) continue;
            BlockPos pos = fromPos.func_177972_a(facing);
            BlockState state = event.getWorld().func_180495_p(pos);
            if (!(state.func_177230_c() instanceof INeighbourBlockInteractionSensitive) || !((INeighbourBlockInteractionSensitive)state.func_177230_c()).onNeighborBlockPlayerInteraction(world, pos, state, fromPos, event.getEntityLiving(), event.getHand(), is_lclick)) continue;
            event.setCancellationResult(ActionResultType.CONSUME);
        }
    }

    public static interface INeighbourBlockInteractionSensitive {
        default public boolean onNeighborBlockPlayerInteraction(World world, BlockPos pos, BlockState state, BlockPos fromPos, LivingEntity entity, Hand hand, boolean isLeftClick) {
            return false;
        }
    }
}

