/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.StorageNetwork;
import com.lothrazar.storagenetwork.block.main.TileMain;
import com.lothrazar.storagenetwork.capability.handler.ItemStackMatcher;
import com.lothrazar.storagenetwork.gui.ContainerNetwork;
import com.lothrazar.storagenetwork.network.StackRefreshClientMessage;
import com.lothrazar.storagenetwork.network.StackResponseClientMessage;
import com.lothrazar.storagenetwork.registry.PacketRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.ItemHandlerHelper;

public class RequestMessage {
    private int mouseButton = 0;
    private ItemStack stack = ItemStack.field_190927_a;
    private boolean shift;
    private boolean ctrl;

    public String toString() {
        return "RequestMessage [mouseButton=" + this.mouseButton + ", shift=" + this.shift + ", ctrl=" + this.ctrl + ", stack=" + this.stack.toString() + "]";
    }

    public RequestMessage() {
    }

    public RequestMessage(int id, ItemStack stackIn, boolean shift, boolean ctrl) {
        this.mouseButton = id;
        this.stack = stackIn.func_77946_l();
        if (this.stack.func_190916_E() > 64) {
            this.stack.func_190920_e(64);
        }
        this.shift = shift;
        this.ctrl = ctrl;
    }

    public static void handle(RequestMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            TileMain root = null;
            ContainerNetwork ctr = null;
            if (player.field_71070_bA instanceof ContainerNetwork) {
                ctr = (ContainerNetwork)player.field_71070_bA;
                root = ctr.getTileMain();
            } else {
                StorageNetwork.log("Bad container");
            }
            if (root == null) {
                StorageNetwork.log("Request message cancelled, null tile");
                return;
            }
            int in = root.getAmount(new ItemStackMatcher(message.stack, false, true));
            boolean isLeftClick = message.mouseButton == 0;
            boolean isRightClick = message.mouseButton == 1;
            int sizeRequested = 0;
            if (message.ctrl) {
                sizeRequested = 1;
            } else if (isLeftClick) {
                sizeRequested = message.stack.func_77976_d();
            } else if (isRightClick) {
                sizeRequested = Math.min(message.stack.func_77976_d() / 2, in / 2);
            }
            sizeRequested = Math.max(sizeRequested, 1);
            boolean ore = false;
            boolean nbt = true;
            ItemStack stack = root.request(new ItemStackMatcher(message.stack, ore, nbt), sizeRequested, false);
            if (stack.func_190926_b()) {
                nbt = false;
                stack = root.request(new ItemStackMatcher(message.stack, ore, nbt), sizeRequested, false);
            }
            if (!stack.func_190926_b()) {
                if (message.shift) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
                } else {
                    player.field_71071_by.func_70437_b(stack);
                    PacketRegistry.INSTANCE.sendTo((Object)new StackResponseClientMessage(stack), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
                }
            }
            List<ItemStack> list = root.getSortedStacks();
            PacketRegistry.INSTANCE.sendTo((Object)new StackRefreshClientMessage(list, new ArrayList<ItemStack>()), player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            player.field_71070_bA.func_75142_b();
        });
        ctx.get().setPacketHandled(true);
    }

    public static RequestMessage decode(PacketBuffer buf) {
        RequestMessage msg = new RequestMessage();
        msg.mouseButton = buf.readInt();
        msg.stack = ItemStack.func_199557_a((CompoundNBT)buf.func_150793_b());
        msg.shift = buf.readBoolean();
        msg.ctrl = buf.readBoolean();
        return msg;
    }

    public static void encode(RequestMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.mouseButton);
        buf.func_150786_a(msg.stack.serializeNBT());
        buf.writeBoolean(msg.shift);
        buf.writeBoolean(msg.ctrl);
    }
}

