/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.block.BlockModificationEventJS;
import dev.latvian.kubejs.core.JsonSerializableKJS;
import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.item.ItemModificationEventJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.text.TextString;
import dev.latvian.kubejs.text.TextTranslate;
import dev.latvian.kubejs.util.JSObjectType;
import dev.latvian.kubejs.util.JsonUtilsJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.WrappedJS;
import dev.latvian.kubejs.world.WorldJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.Copyable;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.shedaniel.architectury.registry.ToolType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.loot.BinomialRange;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.EndNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jetbrains.annotations.Nullable;

public class UtilsJS {
    public static final Random RANDOM = new Random();
    public static final Pattern REGEX_PATTERN = Pattern.compile("\\/(.*)\\/([a-z]*)");
    public static final ResourceLocation AIR_LOCATION = new ResourceLocation("minecraft:air");
    public static final Pattern SNAKE_CASE_SPLIT = Pattern.compile("[_/]");

    public static void init() {
    }

    public static void tryIO(TryIO tryIO) {
        try {
            tryIO.run();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static <T> T cast(Object o) {
        return (T)o;
    }

    @Nullable
    public static Pattern parseRegex(Object o) {
        if (o instanceof CharSequence || o instanceof NativeRegExp) {
            return UtilsJS.regex(o.toString());
        }
        if (o instanceof Pattern) {
            return (Pattern)o;
        }
        return null;
    }

    @Nullable
    public static Pattern regex(String string) {
        if (string.length() < 3) {
            return null;
        }
        Matcher matcher = REGEX_PATTERN.matcher(string);
        if (matcher.matches()) {
            int flags = 0;
            String f = matcher.group(2);
            block9: for (int i = 0; i < f.length(); ++i) {
                switch (f.charAt(i)) {
                    case 'd': {
                        flags |= 1;
                        continue block9;
                    }
                    case 'i': {
                        flags |= 2;
                        continue block9;
                    }
                    case 'x': {
                        flags |= 4;
                        continue block9;
                    }
                    case 'm': {
                        flags |= 8;
                        continue block9;
                    }
                    case 's': {
                        flags |= 0x20;
                        continue block9;
                    }
                    case 'u': {
                        flags |= 0x40;
                        continue block9;
                    }
                    case 'U': {
                        flags |= 0x100;
                    }
                }
            }
            return Pattern.compile(matcher.group(1), flags);
        }
        return null;
    }

    public static String toRegexString(Pattern pattern) {
        StringBuilder sb = new StringBuilder("/");
        sb.append(pattern.pattern());
        sb.append('/');
        int flags = pattern.flags();
        if ((flags & 1) != 0) {
            sb.append('d');
        }
        if ((flags & 2) != 0) {
            sb.append('i');
        }
        if ((flags & 4) != 0) {
            sb.append('x');
        }
        if ((flags & 8) != 0) {
            sb.append('m');
        }
        if ((flags & 0x20) != 0) {
            sb.append('s');
        }
        if ((flags & 0x40) != 0) {
            sb.append('u');
        }
        if ((flags & 0x100) != 0) {
            sb.append('U');
        }
        return sb.toString();
    }

    public static void queueIO(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Path getFile(String path) throws IOException {
        return KubeJS.verifyFilePath(KubeJS.getGameDirectory().resolve(path));
    }

    @Nullable
    public static Object copy(@Nullable Object o) {
        if (o instanceof Copyable) {
            return ((Copyable)o).copy();
        }
        if (o instanceof JsonElement) {
            return JsonUtilsJS.copy((JsonElement)o);
        }
        if (o instanceof INBT) {
            return ((INBT)o).func_74737_b();
        }
        return o;
    }

    @Nullable
    public static Object wrap(@Nullable Object o, JSObjectType type) {
        if (o == null || o instanceof WrappedJS || o instanceof INBT || o instanceof Number || o instanceof Character || o instanceof String || o instanceof Enum || o.getClass().isPrimitive() && !o.getClass().isArray()) {
            return o;
        }
        if (o instanceof CharSequence || o instanceof ResourceLocation) {
            return o.toString();
        }
        if (o instanceof Wrapper) {
            return UtilsJS.wrap(((Wrapper)o).unwrap(), type);
        }
        if (o instanceof ITextComponent) {
            TextString t = new TextString("");
            ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
            list.add((ITextComponent)o);
            list.addAll(((ITextComponent)o).func_150253_a());
            for (ITextComponent c : list) {
                HoverEvent he;
                Text t1 = c instanceof TranslationTextComponent ? new TextTranslate(((TranslationTextComponent)c).func_150268_i(), ((TranslationTextComponent)c).func_150271_j()) : new TextString(c.func_150261_e());
                t1.bold(c.func_150256_b().func_150223_b());
                t1.italic(c.func_150256_b().func_150242_c());
                t1.underlined(c.func_150256_b().func_150234_e());
                t1.strikethrough(c.func_150256_b().func_150236_d());
                t1.obfuscated(c.func_150256_b().func_150233_f());
                t1.insertion(c.func_150256_b().func_179986_j());
                ClickEvent ce = c.func_150256_b().func_150235_h();
                if (ce != null) {
                    if (ce.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
                        t1.click("command:" + ce.func_150668_b());
                    } else if (ce.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
                        t1.click("suggest_command:" + ce.func_150668_b());
                    } else if (ce.func_150669_a() == ClickEvent.Action.COPY_TO_CLIPBOARD) {
                        t1.click("copy:" + ce.func_150668_b());
                    } else if (ce.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                        t1.click(ce.func_150668_b());
                    }
                }
                if ((he = c.func_150256_b().func_150210_i()) != null && he.func_150701_a() == HoverEvent.Action.field_230550_a_) {
                    t1.hover(Text.of(he.func_240662_a_(HoverEvent.Action.field_230550_a_)));
                }
                t.append(t1);
            }
            return t;
        }
        if (o instanceof Map) {
            if (!type.checkMap()) {
                return null;
            }
            MapJS map = new MapJS(((Map)o).size());
            map.putAll((Map)o);
            return map;
        }
        if (o instanceof Iterable) {
            if (!type.checkList()) {
                return null;
            }
            ListJS list = new ListJS();
            for (Object o1 : (Iterable)o) {
                list.add(o1);
            }
            return list;
        }
        if (o.getClass().isArray()) {
            if (type.checkList()) {
                return ListJS.ofArray(o);
            }
            return null;
        }
        if (o instanceof JsonPrimitive) {
            return JsonUtilsJS.toPrimitive((JsonElement)((JsonPrimitive)o));
        }
        if (o instanceof JsonObject) {
            if (!type.checkMap()) {
                return null;
            }
            MapJS map = new MapJS(((JsonObject)o).size());
            for (Map.Entry entry : ((JsonObject)o).entrySet()) {
                map.put((String)entry.getKey(), entry.getValue());
            }
            return map;
        }
        if (o instanceof JsonNull || o instanceof EndNBT) {
            return null;
        }
        if (o instanceof CompoundNBT) {
            if (!type.checkMap()) {
                return null;
            }
            CompoundNBT nbt = (CompoundNBT)o;
            MapJS map = new MapJS(nbt.func_186856_d());
            for (String s : nbt.func_150296_c()) {
                map.put(s, (Object)nbt.func_74781_a(s));
            }
            return map;
        }
        if (o instanceof NumberNBT) {
            return ((NumberNBT)o).func_209908_j();
        }
        if (o instanceof StringNBT) {
            return ((StringNBT)o).func_150285_a_();
        }
        return o;
    }

    public static int parseInt(@Nullable Object object, int def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Integer.parseInt(s);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static double parseDouble(@Nullable Object object, double def) {
        if (object == null) {
            return def;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            String s = object.toString();
            if (s.isEmpty()) {
                return def;
            }
            return Double.parseDouble(String.valueOf(object));
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static Stat<ResourceLocation> getStat(ResourceLocation id) {
        return Stats.field_199092_j.func_199076_b((Object)id);
    }

    public static ToolType getToolType(String id) {
        return ToolType.byName((String)id);
    }

    public static WorldJS getWorld(World world) {
        if (world.func_201670_d()) {
            return UtilsJS.getClientWorld();
        }
        return ServerJS.instance.getLevel(world);
    }

    public static WorldJS getClientWorld() {
        return KubeJS.PROXY.getClientWorld();
    }

    public static String getID(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft:air";
        }
        if (s.indexOf(58) == -1) {
            return "minecraft:" + s;
        }
        return s;
    }

    public static ResourceLocation getMCID(@Nullable Object o) {
        if (o == null) {
            return AIR_LOCATION;
        }
        if (o instanceof ResourceLocation) {
            return (ResourceLocation)o;
        }
        String s = o.toString();
        if (s == null || s.isEmpty()) {
            return AIR_LOCATION;
        }
        return new ResourceLocation(s);
    }

    public static String getNamespace(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "minecraft";
        }
        int i = s.indexOf(58);
        return i == -1 ? "minecraft" : s.substring(0, i);
    }

    public static String getPath(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return "air";
        }
        int i = s.indexOf(58);
        return i == -1 ? s : s.substring(i + 1);
    }

    public static BlockState parseBlockState(String string) {
        if (string.isEmpty()) {
            return Blocks.field_150350_a.func_176223_P();
        }
        int i = string.indexOf(91);
        boolean hasProperties = i >= 0 && string.indexOf(93) == string.length() - 1;
        BlockState state = ((Block)KubeJSRegistries.blocks().get(new ResourceLocation(hasProperties ? string.substring(0, i) : string))).func_176223_P();
        if (hasProperties) {
            for (String s : string.substring(i + 1, string.length() - 1).split(",")) {
                Optional o;
                Property p;
                String[] s1 = s.split("=", 2);
                if (s1.length != 2 || s1[0].isEmpty() || s1[1].isEmpty() || (p = state.func_177230_c().func_176194_O().func_185920_a(s1[0])) == null || !(o = p.func_185929_b(s1[1])).isPresent()) continue;
                state = (BlockState)state.func_206870_a(p, (Comparable)UtilsJS.cast(o.get()));
            }
        }
        return state;
    }

    public static ListJS rollChestLoot(ResourceLocation id, @Nullable EntityJS entity) {
        ListJS list = new ListJS();
        if (ServerJS.instance != null) {
            LootContext.Builder builder;
            MinecraftServer server = ServerJS.instance.getMinecraftServer();
            LootTableManager tables = ServerJS.instance.getMinecraftServer().func_200249_aQ();
            LootTable table = tables.func_186521_a(id);
            if (entity != null) {
                Entity mcEntity = entity.minecraftEntity;
                builder = new LootContext.Builder((ServerWorld)mcEntity.field_70170_p).func_216021_b(LootParameters.field_216281_a, (Object)mcEntity).func_216015_a(LootParameters.field_237457_g_, (Object)mcEntity.func_213303_ch());
            } else {
                builder = new LootContext.Builder(server.func_241755_D_()).func_216021_b(LootParameters.field_216281_a, null).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.field_186680_a);
            }
            table.func_216120_b(builder.func_216022_a(LootParameterSets.field_216261_b), stack -> list.add(ItemStackJS.of(stack)));
        }
        return list;
    }

    public static void postModificationEvents() {
        new BlockModificationEventJS().post(ScriptType.STARTUP, "block.modification");
        new ItemModificationEventJS().post(ScriptType.STARTUP, "item.modification");
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            .Gson.Preconditions.checkArgument((boolean)(rawType instanceof Class));
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return Array.newInstance(UtilsJS.getRawType(componentType), 0).getClass();
        }
        if (type instanceof TypeVariable) {
            return Object.class;
        }
        if (type instanceof WildcardType) {
            return UtilsJS.getRawType(((WildcardType)type).getUpperBounds()[0]);
        }
        String className = type == null ? "null" : type.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type + "> is of type " + className);
    }

    public static String convertSnakeCaseToCamelCase(String string) {
        String[] s = SNAKE_CASE_SPLIT.split(string, 0);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String value : s) {
            if (value.isEmpty()) continue;
            if (first) {
                first = false;
                sb.append(value);
                continue;
            }
            sb.append(Character.toUpperCase(value.charAt(0)));
            sb.append(value, 1, value.length());
        }
        return sb.toString();
    }

    public static IRandomRange randomIntGeneratorOf(Object o) {
        if (o instanceof Number) {
            float f = ((Number)o).floatValue();
            return RandomValueRange.func_215837_a((float)f, (float)f);
        }
        if (o instanceof List && ((List)o).size() == 2) {
            List l = (List)o;
            return RandomValueRange.func_215837_a((float)((Number)l.get(0)).floatValue(), (float)((Number)l.get(1)).floatValue());
        }
        if (o instanceof List && ((List)o).size() == 1) {
            List l = (List)o;
            return RandomValueRange.func_215837_a((float)((Number)l.get(0)).floatValue(), (float)((Number)l.get(0)).floatValue());
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            if (m.containsKey("min") && m.containsKey("max")) {
                return RandomValueRange.func_215837_a((float)((Number)m.get("min")).intValue(), (float)((Number)m.get("max")).floatValue());
            }
            if (m.containsKey("n") && m.containsKey("p")) {
                return BinomialRange.func_215838_a((int)((Number)m.get("n")).intValue(), (float)((Number)m.get("p")).floatValue());
            }
            if (m.containsKey("value")) {
                float f = ((Number)m.get("value")).floatValue();
                return RandomValueRange.func_215837_a((float)f, (float)f);
            }
        }
        return ConstantRange.func_215835_a((int)0);
    }

    public static JsonElement randomIntGeneratorJson(IRandomRange gen) {
        if (gen instanceof JsonSerializableKJS) {
            return ((JsonSerializableKJS)gen).toJsonKJS();
        }
        throw new IllegalArgumentException("Unknown gen type: " + gen.getClass().getName());
    }

    public static interface TryIO {
        public void run() throws IOException;
    }
}

