/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.mods.rhino.mod.util.JsonSerializable;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class JsonUtilsJS {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();

    public static JsonElement copy(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return JsonNull.INSTANCE;
        }
        if (element instanceof JsonArray) {
            JsonArray a = new JsonArray();
            for (JsonElement e : (JsonArray)element) {
                a.add(JsonUtilsJS.copy(e));
            }
            return a;
        }
        if (element instanceof JsonObject) {
            JsonObject o = new JsonObject();
            for (Map.Entry entry : ((JsonObject)element).entrySet()) {
                o.add((String)entry.getKey(), JsonUtilsJS.copy((JsonElement)entry.getValue()));
            }
            return o;
        }
        return element;
    }

    public static JsonElement of(@Nullable Object o) {
        if (o == null) {
            return JsonNull.INSTANCE;
        }
        if (o instanceof JsonSerializable) {
            return ((JsonSerializable)o).toJson();
        }
        if (o instanceof JsonElement) {
            return (JsonElement)o;
        }
        if (o instanceof CharSequence) {
            return new JsonPrimitive(o.toString());
        }
        if (o instanceof Boolean) {
            return new JsonPrimitive((Boolean)o);
        }
        if (o instanceof Number) {
            return new JsonPrimitive((Number)o);
        }
        if (o instanceof Character) {
            return new JsonPrimitive((Character)o);
        }
        return JsonNull.INSTANCE;
    }

    @Nullable
    public static Object toObject(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return null;
        }
        if (json.isJsonObject()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            JsonObject o = json.getAsJsonObject();
            for (Map.Entry entry : o.entrySet()) {
                map.put((String)entry.getKey(), JsonUtilsJS.toObject((JsonElement)entry.getValue()));
            }
            return map;
        }
        if (json.isJsonArray()) {
            JsonArray a = json.getAsJsonArray();
            ArrayList<Object> objects = new ArrayList<Object>(a.size());
            for (JsonElement e : a) {
                objects.add(JsonUtilsJS.toObject(e));
            }
            return objects;
        }
        return JsonUtilsJS.toPrimitive(json);
    }

    public static String toString(JsonElement json) {
        StringWriter writer = new StringWriter();
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setSerializeNulls(true);
            jsonWriter.setLenient(true);
            jsonWriter.setHtmlSafe(false);
            Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return writer.toString();
    }

    public static String toPrettyString(JsonElement json) {
        StringWriter writer = new StringWriter();
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setIndent("\t");
            jsonWriter.setSerializeNulls(true);
            jsonWriter.setLenient(true);
            jsonWriter.setHtmlSafe(false);
            Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return writer.toString();
    }

    public static JsonElement fromString(@Nullable String string) {
        if (string == null || string.isEmpty() || string.equals("null")) {
            return JsonNull.INSTANCE;
        }
        try {
            JsonReader jsonReader = new JsonReader((Reader)new StringReader(string));
            boolean lenient = jsonReader.isLenient();
            jsonReader.setLenient(true);
            JsonElement element = Streams.parse((JsonReader)jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return JsonNull.INSTANCE;
        }
    }

    @Nullable
    public static Object toPrimitive(@Nullable JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive p = element.getAsJsonPrimitive();
            if (p.isBoolean()) {
                return p.getAsBoolean();
            }
            if (p.isNumber()) {
                return p.getAsNumber();
            }
            try {
                Double.parseDouble(p.getAsString());
                return p.getAsNumber();
            }
            catch (Exception ex) {
                return p.getAsString();
            }
        }
        return null;
    }

    @Nullable
    public static MapJS read(File file) throws IOException {
        KubeJS.verifyFilePath(file);
        if (!file.exists()) {
            return null;
        }
        try (FileReader fileReader = new FileReader(file);){
            MapJS mapJS;
            try (JsonReader jsonReader = new JsonReader((Reader)fileReader);){
                boolean lenient = jsonReader.isLenient();
                jsonReader.setLenient(true);
                JsonElement element = Streams.parse((JsonReader)jsonReader);
                if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                    throw new JsonSyntaxException("Did not consume the entire document.");
                }
                mapJS = MapJS.of(element);
            }
            return mapJS;
        }
    }

    public static void write(File file, @Nullable MapJS o) throws IOException {
        KubeJS.verifyFilePath(file);
        if (o == null) {
            file.delete();
            return;
        }
        JsonObject json = o.toJson();
        try (FileWriter fileWriter = new FileWriter(file);
             JsonWriter jsonWriter = new JsonWriter((Writer)new BufferedWriter(fileWriter));){
            jsonWriter.setIndent("\t");
            jsonWriter.setSerializeNulls(true);
            jsonWriter.setLenient(true);
            Streams.write((JsonElement)json, (JsonWriter)jsonWriter);
        }
    }

    @Nullable
    public static MapJS read(String file) throws IOException {
        return JsonUtilsJS.read(KubeJS.getGameDirectory().resolve(file).toFile());
    }

    public static void write(String file, @Nullable MapJS json) throws IOException {
        JsonUtilsJS.write(KubeJS.getGameDirectory().resolve(file).toFile(), json);
    }
}

