/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.server;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSPaths;
import dev.latvian.kubejs.item.ingredient.IngredientWithCustomPredicateJS;
import dev.latvian.kubejs.recipe.RecipeEventJS;
import dev.latvian.kubejs.recipe.RecipeTypeJS;
import dev.latvian.kubejs.recipe.RecipeTypeRegistryEventJS;
import dev.latvian.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.kubejs.script.ScriptFile;
import dev.latvian.kubejs.script.ScriptFileInfo;
import dev.latvian.kubejs.script.ScriptManager;
import dev.latvian.kubejs.script.ScriptPack;
import dev.latvian.kubejs.script.ScriptPackInfo;
import dev.latvian.kubejs.script.ScriptSource;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.script.data.DataPackEventJS;
import dev.latvian.kubejs.script.data.VirtualKubeJSDataPack;
import dev.latvian.kubejs.server.KubeJSServerResourcePack;
import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.kubejs.util.KubeJSPlugins;
import dev.latvian.kubejs.util.UtilsJS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.util.ResourceLocation;

public class ServerScriptManager {
    public static ServerScriptManager instance;
    public final ScriptManager scriptManager = new ScriptManager(ScriptType.SERVER, KubeJSPaths.SERVER_SCRIPTS, "/data/kubejs/example_server_script.js");

    public void init(DataPackRegistries serverResources) {
        try {
            if (Files.notExists(KubeJSPaths.DATA, new LinkOption[0])) {
                Files.createDirectories(KubeJSPaths.DATA, new FileAttribute[0]);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("KubeJS failed to register it's script loader!", ex);
        }
    }

    public void reloadScriptManager(IResourceManager resourceManager) {
        this.scriptManager.unload();
        this.scriptManager.loadFromDirectory();
        HashMap<String, List> packs = new HashMap<String, List>();
        for (ResourceLocation resourceLocation : resourceManager.func_199003_a("kubejs", s -> s.endsWith(".js"))) {
            packs.computeIfAbsent(resourceLocation.func_110624_b(), s -> new ArrayList()).add(resourceLocation);
        }
        for (Map.Entry entry : packs.entrySet()) {
            ScriptPack pack = new ScriptPack(this.scriptManager, new ScriptPackInfo((String)entry.getKey(), "kubejs/"));
            for (ResourceLocation id : (List)entry.getValue()) {
                pack.info.scripts.add(new ScriptFileInfo(pack.info, id.func_110623_a().substring(7)));
            }
            for (ScriptFileInfo fileInfo : pack.info.scripts) {
                ScriptSource.FromResource scriptSource = info -> resourceManager.func_199002_a(info.id);
                Throwable error = fileInfo.preload(scriptSource);
                if (fileInfo.isIgnored()) continue;
                if (error == null) {
                    pack.scripts.add(new ScriptFile(pack, fileInfo, scriptSource));
                    continue;
                }
                KubeJS.LOGGER.error("Failed to pre-load script file " + fileInfo.location + ": " + error);
            }
            pack.scripts.sort(null);
            this.scriptManager.packs.put(pack.info.namespace, pack);
        }
        this.scriptManager.load();
    }

    public List<IResourcePack> resourcePackList(List<IResourcePack> list0) {
        VirtualKubeJSDataPack virtualDataPackLow = new VirtualKubeJSDataPack(false);
        VirtualKubeJSDataPack virtualDataPackHigh = new VirtualKubeJSDataPack(true);
        ArrayList<IResourcePack> list = new ArrayList<IResourcePack>();
        list.add((IResourcePack)virtualDataPackLow);
        list.addAll(list0);
        list.add(new KubeJSServerResourcePack());
        list.add((IResourcePack)virtualDataPackHigh);
        SimpleReloadableResourceManager resourceManager = new SimpleReloadableResourceManager(ResourcePackType.SERVER_DATA);
        for (IResourcePack p : list) {
            resourceManager.func_199021_a(p);
        }
        this.reloadScriptManager((IResourceManager)resourceManager);
        ConsoleJS.SERVER.setLineNumber(true);
        new DataPackEventJS(virtualDataPackLow).post(ScriptType.SERVER, "server.datapack.last");
        new DataPackEventJS(virtualDataPackLow).post(ScriptType.SERVER, "server.datapack.low_priority");
        new DataPackEventJS(virtualDataPackHigh).post(ScriptType.SERVER, "server.datapack.first");
        new DataPackEventJS(virtualDataPackHigh).post(ScriptType.SERVER, "server.datapack.high_priority");
        UtilsJS.postModificationEvents();
        ConsoleJS.SERVER.setLineNumber(false);
        ConsoleJS.SERVER.info("Scripts loaded");
        HashMap<ResourceLocation, RecipeTypeJS> typeMap = new HashMap<ResourceLocation, RecipeTypeJS>();
        RegisterRecipeHandlersEvent modEvent = new RegisterRecipeHandlersEvent(typeMap);
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addRecipes(modEvent));
        ((Consumer)RegisterRecipeHandlersEvent.EVENT.invoker()).accept(modEvent);
        new RecipeTypeRegistryEventJS(typeMap).post(ScriptType.SERVER, "recipes.type_registry");
        if (Platform.isForge()) {
            RecipeEventJS.customIngredientMap = new HashMap<UUID, IngredientWithCustomPredicateJS>();
        }
        RecipeEventJS.instance = new RecipeEventJS(typeMap);
        return list;
    }
}

