/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.server;

import com.mojang.brigadier.CommandDispatcher;
import dev.latvian.kubejs.command.KubeJSCommands;
import dev.latvian.kubejs.player.PlayerDataJS;
import dev.latvian.kubejs.player.SimplePlayerEventJS;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.AttachServerDataEvent;
import dev.latvian.kubejs.server.CommandEventJS;
import dev.latvian.kubejs.server.ScheduledEvent;
import dev.latvian.kubejs.server.ServerEventJS;
import dev.latvian.kubejs.server.ServerJS;
import dev.latvian.kubejs.server.ServerScriptManager;
import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.kubejs.world.AttachWorldDataEvent;
import dev.latvian.kubejs.world.ServerWorldJS;
import dev.latvian.kubejs.world.SimpleWorldEventJS;
import dev.latvian.kubejs.world.WorldJS;
import dev.latvian.mods.rhino.RhinoException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import me.shedaniel.architectury.event.events.CommandPerformEvent;
import me.shedaniel.architectury.event.events.CommandRegistrationEvent;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.event.events.TickEvent;
import me.shedaniel.architectury.hooks.LevelResourceHooks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;

public class KubeJSServerEventHandler {
    private static final FolderName PERSISTENT_DATA = LevelResourceHooks.create((String)"kubejs_persistent_data.nbt");

    public static void init() {
        LifecycleEvent.SERVER_BEFORE_START.register(KubeJSServerEventHandler::serverAboutToStart);
        CommandRegistrationEvent.EVENT.register(KubeJSServerEventHandler::registerCommands);
        LifecycleEvent.SERVER_STARTED.register(KubeJSServerEventHandler::serverStarted);
        LifecycleEvent.SERVER_STOPPING.register(KubeJSServerEventHandler::serverStopping);
        LifecycleEvent.SERVER_WORLD_SAVE.register(KubeJSServerEventHandler::serverWorldSave);
        TickEvent.SERVER_POST.register(KubeJSServerEventHandler::serverTick);
        CommandPerformEvent.EVENT.register(KubeJSServerEventHandler::command);
    }

    public static void serverAboutToStart(MinecraftServer server) {
        if (ServerJS.instance != null) {
            KubeJSServerEventHandler.destroyServer();
        }
        ServerJS.instance = new ServerJS(server, ServerScriptManager.instance);
        Path p = server.func_240776_a_(PERSISTENT_DATA);
        if (Files.exists(p, new LinkOption[0])) {
            try {
                CompoundNBT tag = CompressedStreamTools.func_244263_a((File)p.toFile());
                if (tag != null) {
                    ServerJS.instance.persistentData.func_197643_a(tag);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSource> dispatcher, Commands.EnvironmentType selection) {
        KubeJSCommands.register(dispatcher);
    }

    public static void serverStarted(MinecraftServer server) {
        ServerJS.instance.overworld = new ServerWorldJS(ServerJS.instance, server.func_71218_a(World.field_234918_g_));
        ServerJS.instance.levelMap.put("minecraft:overworld", ServerJS.instance.overworld);
        ServerJS.instance.worlds.add(ServerJS.instance.overworld);
        for (ServerWorld serverWorld : server.func_212370_w()) {
            if (serverWorld == ServerJS.instance.overworld.minecraftLevel) continue;
            ServerWorldJS w = new ServerWorldJS(ServerJS.instance, serverWorld);
            ServerJS.instance.levelMap.put(serverWorld.func_234923_W_().func_240901_a_().toString(), w);
        }
        ServerJS.instance.updateWorldList();
        new AttachServerDataEvent(ServerJS.instance).invoke();
        new ServerEventJS().post(ScriptType.SERVER, "server.load");
        for (ServerWorldJS serverWorldJS : ServerJS.instance.worlds) {
            new AttachWorldDataEvent(ServerJS.instance.getOverworld()).invoke();
            new SimpleWorldEventJS(ServerJS.instance.getOverworld()).post("world.load");
        }
    }

    public static void serverStopping(MinecraftServer server) {
        KubeJSServerEventHandler.destroyServer();
    }

    public static void destroyServer() {
        ServerJS s = ServerJS.instance;
        for (PlayerDataJS playerDataJS : s.playerMap.values()) {
            new SimplePlayerEventJS((PlayerEntity)playerDataJS.getMinecraftPlayer()).post("player.logged_out");
        }
        for (WorldJS worldJS : s.levelMap.values()) {
            new SimpleWorldEventJS(worldJS).post("world.unload");
        }
        new ServerEventJS().post(ScriptType.SERVER, "server.unload");
        s.release();
        ServerJS.instance = null;
    }

    private static void serverWorldSave(ServerWorld level) {
        ServerJS s = ServerJS.instance;
        Path p = level.func_73046_m().func_240776_a_(PERSISTENT_DATA);
        if (s != null && level.func_234923_W_() == World.field_234918_g_) {
            Util.func_240992_g_().execute(() -> {
                try {
                    CompressedStreamTools.func_244264_a((CompoundNBT)s.persistentData, (File)p.toFile());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
        }
    }

    public static void serverTick(MinecraftServer server) {
        Object e;
        ArrayList<Object> list;
        Iterator<ScheduledEvent> eventIterator;
        long now;
        ServerJS s = ServerJS.instance;
        if (!s.scheduledEvents.isEmpty()) {
            now = System.currentTimeMillis();
            eventIterator = s.scheduledEvents.iterator();
            list = new ArrayList<Object>();
            while (eventIterator.hasNext()) {
                e = eventIterator.next();
                if (now < ((ScheduledEvent)e).getEndTime()) continue;
                list.add(e);
                eventIterator.remove();
            }
            for (ScheduledEvent scheduledEvent : list) {
                try {
                    scheduledEvent.call();
                }
                catch (RhinoException ex) {
                    ConsoleJS.SERVER.error("Error occurred while handling scheduled event callback: " + ex.getMessage());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (!s.scheduledTickEvents.isEmpty()) {
            now = s.getOverworld().getTime();
            eventIterator = s.scheduledTickEvents.iterator();
            list = new ArrayList();
            while (eventIterator.hasNext()) {
                e = eventIterator.next();
                if (now < ((ScheduledEvent)e).getEndTime()) continue;
                list.add(e);
                eventIterator.remove();
            }
            for (ScheduledEvent scheduledEvent : list) {
                try {
                    scheduledEvent.call();
                }
                catch (RhinoException ex) {
                    ConsoleJS.SERVER.error("Error occurred while handling scheduled event callback: " + ex.getMessage());
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        new ServerEventJS().post(ScriptType.SERVER, "server.tick");
    }

    public static ActionResultType command(CommandPerformEvent event) {
        if (new CommandEventJS(event).post(ScriptType.SERVER, "command.run")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }
}

