/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.script;

import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.script.ScriptManager;
import dev.latvian.kubejs.server.ServerScriptManager;
import dev.latvian.kubejs.util.ConsoleJS;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.world.IWorldReader;
import org.apache.logging.log4j.LogManager;

public enum ScriptType {
    STARTUP("startup", "KubeJS Startup", () -> KubeJS.startupScriptManager),
    SERVER("server", "KubeJS Server", () -> ServerScriptManager.instance.scriptManager),
    CLIENT("client", "KubeJS Client", () -> KubeJS.clientScriptManager);

    public final String name;
    public final List<String> errors;
    public final List<String> warnings;
    public final ConsoleJS console;
    public final Supplier<ScriptManager> manager;

    public static ScriptType of(IWorldReader world) {
        return world.func_201670_d() ? CLIENT : SERVER;
    }

    private ScriptType(String n2, String cname, Supplier<ScriptManager> m) {
        this.name = n2;
        this.errors = new ArrayList<String>();
        this.warnings = new ArrayList<String>();
        this.console = new ConsoleJS(this, LogManager.getLogger((String)cname));
        this.manager = m;
    }

    public Path getLogFile() {
        Path dir = Platform.getGameFolder().resolve("logs/kubejs");
        Path file = dir.resolve(this.name + ".txt");
        try {
            if (!Files.exists(dir, new LinkOption[0])) {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return file;
    }

    public boolean isClient() {
        return this == CLIENT;
    }

    public boolean isServer() {
        return this == SERVER;
    }
}

