/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.kubejs.recipe.RecipeEventJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeTypeJS;
import dev.latvian.kubejs.recipe.minecraft.CustomRecipeJS;
import dev.latvian.kubejs.recipe.mod.TechRebornCompat;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeJS {
    public static RecipeJS currentRecipe = null;
    public static boolean itemErrors = false;
    private static MessageDigest messageDigest;
    public ResourceLocation id;
    public RecipeTypeJS type;
    public JsonObject json = null;
    public IRecipe<?> originalRecipe = null;
    public final List<ItemStackJS> outputItems = new ArrayList<ItemStackJS>(1);
    public final List<IngredientJS> inputItems = new ArrayList<IngredientJS>(1);
    public boolean serializeOutputs;
    public boolean serializeInputs;
    private String recipeStage = "";

    public abstract void create(ListJS var1);

    public abstract void deserialize();

    public abstract void serialize();

    public final void deserializeJson() {
        currentRecipe = this;
        this.deserialize();
        currentRecipe = null;
    }

    public final void serializeJson() {
        currentRecipe = this;
        this.json.addProperty("type", this.type.getId());
        this.serialize();
        currentRecipe = null;
    }

    public final void save() {
        this.originalRecipe = null;
    }

    public RecipeJS merge(Object data) {
        JsonObject j = MapJS.json(data);
        if (j != null) {
            for (Map.Entry entry : j.entrySet()) {
                this.json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            this.save();
        }
        return this;
    }

    @Deprecated
    public RecipeJS set(Object data) {
        return this.merge(data);
    }

    public RecipeJS id(ResourceLocation _id) {
        this.id = _id;
        this.save();
        return this;
    }

    public RecipeJS group(String g) {
        this.setGroup(g);
        this.save();
        return this;
    }

    public final boolean hasInput(IngredientJS ingredient, boolean exact) {
        if (this.getInputIndex(ingredient, exact) != -1) {
            return true;
        }
        if (this.originalRecipe != null && this instanceof CustomRecipeJS && ServerSettings.instance.useOriginalRecipeForFilters) {
            try {
                for (Ingredient in0 : this.originalRecipe.func_192400_c()) {
                    IngredientJS in = IngredientJS.of(in0);
                    if (in.isEmpty() || !(exact ? in.equals(ingredient) : in.anyStackMatches(ingredient))) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public final int getInputIndex(IngredientJS ingredient, boolean exact) {
        for (int i = 0; i < this.inputItems.size(); ++i) {
            IngredientJS in = this.inputItems.get(i);
            if (!(exact ? in.equals(ingredient) : in.anyStackMatches(ingredient))) continue;
            return i;
        }
        return -1;
    }

    public final boolean replaceInput(IngredientJS i, IngredientJS with, boolean exact) {
        return this.replaceInput(i, with, exact, (in, original) -> in.withCount(original.getCount()));
    }

    public final boolean replaceInput(IngredientJS i, IngredientJS with, boolean exact, BiFunction<IngredientJS, IngredientJS, IngredientJS> func) {
        boolean changed = false;
        for (int j = 0; j < this.inputItems.size(); ++j) {
            if (!(exact ? this.inputItems.get(j).equals(i) : this.inputItems.get(j).anyStackMatches(i))) continue;
            this.inputItems.set(j, this.convertReplacedInput(j, this.inputItems.get(j), func.apply(with.copy(), this.inputItems.get(j))));
            changed = true;
            this.serializeInputs = true;
            this.save();
        }
        return changed;
    }

    public final boolean hasOutput(IngredientJS ingredient, boolean exact) {
        if (this.getOutputIndex(ingredient, exact) != -1) {
            return true;
        }
        if (this.originalRecipe != null && this instanceof CustomRecipeJS && ServerSettings.instance.useOriginalRecipeForFilters) {
            try {
                ItemStackJS out = ItemStackJS.of(this.originalRecipe.func_77571_b());
                if (!out.isEmpty()) {
                    return exact ? ingredient.equals(out) : ingredient.test(out);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public final int getOutputIndex(IngredientJS ingredient, boolean exact) {
        for (int i = 0; i < this.outputItems.size(); ++i) {
            ItemStackJS out = this.outputItems.get(i);
            if (!(exact ? ingredient.equals(out) : ingredient.test(out))) continue;
            return i;
        }
        return -1;
    }

    public final boolean replaceOutput(IngredientJS i, ItemStackJS with, boolean exact) {
        return this.replaceOutput(i, with, exact, (out, original) -> out.withCount(original.getCount()).withChance(original.getChance()));
    }

    public final boolean replaceOutput(IngredientJS i, ItemStackJS with, boolean exact, BiFunction<ItemStackJS, ItemStackJS, ItemStackJS> func) {
        boolean changed = false;
        for (int j = 0; j < this.outputItems.size(); ++j) {
            if (!(exact ? i.equals(this.outputItems.get(j)) : i.test(this.outputItems.get(j)))) continue;
            this.outputItems.set(j, this.convertReplacedOutput(j, this.outputItems.get(j), func.apply(with.copy(), this.outputItems.get(j))));
            changed = true;
            this.serializeOutputs = true;
            this.save();
        }
        return changed;
    }

    public String getGroup() {
        JsonElement e = this.json.get("group");
        return e instanceof JsonPrimitive ? e.getAsString() : "";
    }

    public void setGroup(String g) {
        if (g.isEmpty()) {
            this.json.remove("group");
        } else {
            this.json.addProperty("group", g);
        }
        this.save();
    }

    public String toString() {
        return this.getOrCreateId() + "[" + this.type + "]";
    }

    public String getId() {
        return this.getOrCreateId().toString();
    }

    public String getMod() {
        return this.getOrCreateId().func_110624_b();
    }

    public String getPath() {
        return this.getOrCreateId().func_110623_a();
    }

    public String getType() {
        return this.type.toString();
    }

    public ResourceLocation getOrCreateId() {
        if (this.id == null) {
            this.id = new ResourceLocation(this.type.getIdRL().func_110624_b() + ":kjs_" + this.getUniqueId());
        }
        return this.id;
    }

    public IngredientJS convertReplacedInput(int index, IngredientJS oldIngredient, IngredientJS newIngredient) {
        return newIngredient;
    }

    public ItemStackJS convertReplacedOutput(int index, ItemStackJS oldStack, ItemStackJS newStack) {
        return newStack;
    }

    @Nullable
    public ItemStackJS resultFromRecipeJson(JsonObject json) {
        return null;
    }

    @Nullable
    public JsonElement serializeIngredientStack(IngredientStackJS in) {
        return null;
    }

    @Nullable
    public JsonElement serializeItemStack(ItemStackJS stack) {
        return null;
    }

    public IngredientJS parseIngredientItem(@Nullable Object o, String key) {
        IngredientJS ingredient = IngredientJS.of(o);
        if (ingredient.isInvalidRecipeIngredient() && !Platform.isFabric()) {
            if (key.isEmpty()) {
                throw new RecipeExceptionJS(o + " is not a valid ingredient!");
            }
            throw new RecipeExceptionJS(o + " with key '" + key + "' is not a valid ingredient!");
        }
        return ingredient;
    }

    public IngredientJS parseIngredientItem(@Nullable Object o) {
        return this.parseIngredientItem(o, "");
    }

    public ItemStackJS parseResultItem(@Nullable Object o) {
        ItemStackJS result = ItemStackJS.of(o);
        if (result.isInvalidRecipeIngredient() && !Platform.isFabric()) {
            throw new RecipeExceptionJS(o + " is not a valid result!");
        }
        return result;
    }

    public List<IngredientJS> parseIngredientItemList(@Nullable Object o) {
        ArrayList<IngredientJS> list = new ArrayList<IngredientJS>();
        if (o instanceof JsonElement) {
            JsonArray array;
            if (o instanceof JsonArray) {
                array = ((JsonArray)o).getAsJsonArray();
            } else {
                array = new JsonArray();
                array.add((JsonElement)o);
            }
            for (JsonElement e : array) {
                list.add(this.parseIngredientItem(e));
            }
        } else {
            for (Object o1 : ListJS.orSelf(o)) {
                list.add(this.parseIngredientItem(o1));
            }
        }
        return list;
    }

    public List<IngredientStackJS> parseIngredientItemStackList(@Nullable Object o) {
        return this.parseIngredientItemList(o).stream().map(IngredientJS::asIngredientStack).collect(Collectors.toList());
    }

    public List<ItemStackJS> parseResultItemList(@Nullable Object o) {
        ArrayList<ItemStackJS> list = new ArrayList<ItemStackJS>();
        if (o instanceof JsonElement) {
            JsonArray array;
            if (o instanceof JsonArray) {
                array = ((JsonArray)o).getAsJsonArray();
            } else {
                array = new JsonArray();
                array.add((JsonElement)o);
            }
            for (JsonElement e : array) {
                list.add(this.parseResultItem(e));
            }
        } else {
            for (Object o1 : ListJS.orSelf(o)) {
                list.add(this.parseResultItem(o1));
            }
        }
        return list;
    }

    public String getFromToString() {
        return this.inputItems + " -> " + this.outputItems;
    }

    private static void writeJsonHash(DataOutputStream stream, @Nullable JsonElement element) throws IOException {
        if (element == null || element.isJsonNull()) {
            stream.writeByte(45);
        } else if (element instanceof JsonArray) {
            stream.writeByte(91);
            for (JsonElement e : (JsonArray)element) {
                RecipeJS.writeJsonHash(stream, e);
            }
        } else if (element instanceof JsonObject) {
            stream.writeByte(123);
            for (Map.Entry e : ((JsonObject)element).entrySet()) {
                stream.writeBytes((String)e.getKey());
                RecipeJS.writeJsonHash(stream, (JsonElement)e.getValue());
            }
        } else if (element instanceof JsonPrimitive) {
            stream.writeByte(61);
            if (((JsonPrimitive)element).isBoolean()) {
                stream.writeBoolean(element.getAsBoolean());
            } else if (((JsonPrimitive)element).isNumber()) {
                stream.writeDouble(element.getAsDouble());
            } else {
                stream.writeBytes(element.getAsString());
            }
        } else {
            stream.writeByte(63);
            stream.writeInt(element.hashCode());
        }
    }

    public byte[] getJsonHashBytes() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            RecipeJS.writeJsonHash(new DataOutputStream(baos), (JsonElement)this.json);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            int h = this.json.hashCode();
            return new byte[]{(byte)(h >> 24), (byte)(h >> 16), (byte)(h >> 8), (byte)(h >> 0)};
        }
        return baos.toByteArray();
    }

    public String getUniqueId() {
        if (messageDigest == null) {
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new InternalError("MD5 not supported", nsae);
            }
        }
        if (messageDigest == null) {
            return new BigInteger(Hex.encodeHexString((byte[])this.getJsonHashBytes()), 16).toString(36);
        }
        messageDigest.reset();
        return new BigInteger(Hex.encodeHexString((byte[])messageDigest.digest(this.getJsonHashBytes())), 16).toString(36);
    }

    public RecipeJS stage(String s) {
        this.recipeStage = s;
        this.save();
        if (!Platform.isModLoaded((String)"recipestages")) {
            ConsoleJS.SERVER.warn("Recipe requires stage '" + this.recipeStage + "' but Recipe Stages mod isn't installed!");
        }
        return this;
    }

    public IRecipe<?> createRecipe() throws Throwable {
        this.serializeJson();
        if (!this.recipeStage.isEmpty() && Platform.isModLoaded((String)"recipestages")) {
            IRecipeSerializer stageSerializer = (IRecipeSerializer)KubeJSRegistries.recipeSerializers().get(new ResourceLocation("recipestages:stage"));
            JsonObject o = new JsonObject();
            o.addProperty("stage", this.recipeStage);
            o.add("recipe", (JsonElement)this.json);
            return stageSerializer.func_199425_a_(this.getOrCreateId(), o);
        }
        IRecipe resultRecipe = Objects.requireNonNull(this.type.serializer.func_199425_a_(this.getOrCreateId(), this.json));
        if (Platform.isFabric() && this.type.serializer.getClass().getName().contains("RebornRecipeType")) {
            MethodHandle constructor = TechRebornCompat.getTRRecipeConstructor(resultRecipe, this);
            resultRecipe = constructor.invoke(this.type.serializer, this.getOrCreateId());
            TechRebornCompat.getTRRecipeSerializer(resultRecipe).invoke(resultRecipe, this.json);
        }
        return resultRecipe;
    }

    public void dontAdd() {
        RecipeEventJS.instance.addedRecipes.remove(this);
    }
}

