/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.recipe;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.kubejs.CommonProperties;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.core.RecipeManagerKJS;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientWithCustomPredicateJS;
import dev.latvian.kubejs.recipe.CustomRecipeTypeJS;
import dev.latvian.kubejs.recipe.MissingRecipeFunctionException;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeFunction;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.recipe.RecipeTypeJS;
import dev.latvian.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.kubejs.recipe.forge.RecipeEventJSImpl;
import dev.latvian.kubejs.recipe.special.SpecialRecipeSerializerManager;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.util.ConsoleJS;
import dev.latvian.kubejs.util.JsonUtilsJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class RecipeEventJS
extends EventJS {
    public static final String FORGE_CONDITIONAL = "forge:conditional";
    private static final Pattern SKIP_ERROR = Pattern.compile("at dev.latvian.kubejs.recipe.RecipeEventJS.post");
    public static Map<UUID, IngredientWithCustomPredicateJS> customIngredientMap = null;
    public static RecipeEventJS instance;
    private final List<IRecipe<?>> fallbackedRecipes = new ArrayList();
    private final List<RecipeJS> originalRecipes = new ArrayList<RecipeJS>();
    final List<RecipeJS> addedRecipes;
    private final Set<RecipeJS> removedRecipes;
    private final Set<RecipeJS> modifiedRecipes;
    private final Map<String, Object> recipeFunctions;
    private AtomicInteger modifiedRecipesCount;
    public final RecipeFunction shaped;
    public final RecipeFunction shapeless;
    public final RecipeFunction smelting;
    public final RecipeFunction blasting;
    public final RecipeFunction smoking;
    public final RecipeFunction campfireCooking;
    public final RecipeFunction stonecutting;
    public final RecipeFunction smithing;

    public RecipeEventJS(Map<ResourceLocation, RecipeTypeJS> t) {
        ConsoleJS.SERVER.info("Scanning recipes...");
        this.addedRecipes = new ArrayList<RecipeJS>();
        this.removedRecipes = new HashSet<RecipeJS>();
        this.modifiedRecipes = new HashSet<RecipeJS>();
        this.recipeFunctions = new HashMap<String, Object>();
        HashMap<String, Map> serializers = new HashMap<String, Map>();
        for (Map.Entry entry : KubeJSRegistries.recipeSerializers().entrySet()) {
            serializers.computeIfAbsent(((RegistryKey)entry.getKey()).func_240901_a_().func_110624_b(), n -> new HashMap()).put(((RegistryKey)entry.getKey()).func_240901_a_().func_110623_a(), (IRecipeSerializer)entry.getValue());
        }
        for (Map.Entry entry : serializers.entrySet()) {
            HashMap<String, RecipeFunction> funcs = new HashMap<String, RecipeFunction>();
            for (Map.Entry entry1 : ((Map)entry.getValue()).entrySet()) {
                ResourceLocation location;
                RecipeTypeJS typeJS = t.get(location = new ResourceLocation((String)entry.getKey(), (String)entry1.getKey()));
                RecipeFunction func = new RecipeFunction(this, location, typeJS != null ? typeJS : new CustomRecipeTypeJS((IRecipeSerializer)entry1.getValue()));
                funcs.put(UtilsJS.convertSnakeCaseToCamelCase((String)entry1.getKey()), func);
                funcs.put((String)entry1.getKey(), func);
                this.recipeFunctions.put(UtilsJS.convertSnakeCaseToCamelCase((String)entry.getKey() + "_" + (String)entry1.getKey()), func);
                this.recipeFunctions.put((String)entry.getKey() + "_" + (String)entry1.getKey(), func);
            }
            this.recipeFunctions.put(UtilsJS.convertSnakeCaseToCamelCase((String)entry.getKey()), funcs);
            this.recipeFunctions.put((String)entry.getKey(), funcs);
        }
        SpecialRecipeSerializerManager.INSTANCE.reset();
        SpecialRecipeSerializerManager.INSTANCE.post(ScriptType.SERVER, "recipes.serializer.special.flag");
        this.shaped = this.getRecipeFunction("minecraft:crafting_shaped");
        this.shapeless = this.getRecipeFunction("minecraft:crafting_shapeless");
        this.smelting = this.getRecipeFunction("minecraft:smelting");
        this.blasting = this.getRecipeFunction("minecraft:blasting");
        this.smoking = this.getRecipeFunction("minecraft:smoking");
        this.campfireCooking = this.getRecipeFunction("minecraft:campfire_cooking");
        this.stonecutting = this.getRecipeFunction("minecraft:stonecutting");
        this.smithing = this.getRecipeFunction("minecraft:smithing");
    }

    @HideFromJS
    public void post(RecipeManager recipeManager, Map<ResourceLocation, JsonObject> jsonMap) {
        RecipeJS.itemErrors = false;
        ConsoleJS.SERVER.setLineNumber(true);
        Stopwatch timer = Stopwatch.createStarted();
        JsonObject allRecipeMap = new JsonObject();
        for (Map.Entry<ResourceLocation, JsonObject> entry : jsonMap.entrySet()) {
            ResourceLocation recipeId = entry.getKey();
            if (Platform.isForge() && recipeId.func_110623_a().startsWith("_")) continue;
            String recipeIdAndType = recipeId + "[unknown:type]";
            try {
                JsonArray array;
                JsonObject json = entry.getValue();
                String type = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
                recipeIdAndType = recipeId + "[" + type + "]";
                if (!RecipeEventJS.processConditions(json, "conditions")) {
                    if (!ServerSettings.instance.logSkippedRecipes) continue;
                    ConsoleJS.SERVER.info("Skipping loading recipe " + recipeIdAndType + " as it's conditions were not met");
                    continue;
                }
                if (type.equals(FORGE_CONDITIONAL)) {
                    JsonArray items = JSONUtils.func_151214_t((JsonObject)json, (String)"recipes");
                    boolean skip = true;
                    for (int idx = 0; idx < items.size(); ++idx) {
                        JsonElement e = items.get(idx);
                        if (!e.isJsonObject()) {
                            throw new RecipeExceptionJS("Invalid recipes entry at index " + idx + " Must be JsonObject");
                        }
                        JsonObject o = e.getAsJsonObject();
                        if (!RecipeEventJS.processConditions(o, "conditions")) continue;
                        json = o.get("recipe").getAsJsonObject();
                        type = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
                        recipeIdAndType = recipeId + "[" + type + "]";
                        skip = false;
                        break;
                    }
                    if (skip) {
                        if (!ServerSettings.instance.logSkippedRecipes) continue;
                        ConsoleJS.SERVER.info("Skipping loading recipe " + recipeIdAndType + " as it's conditions were not met");
                        continue;
                    }
                }
                RecipeFunction function = this.getRecipeFunction(type);
                if (function.type == null) {
                    throw new MissingRecipeFunctionException("Unknown recipe type!").fallback();
                }
                RecipeJS recipe3 = function.type.factory.get();
                recipe3.id = recipeId;
                recipe3.type = function.type;
                recipe3.json = json;
                recipe3.originalRecipe = function.type.serializer.func_199425_a_(recipeId, json);
                if (recipe3.originalRecipe == null) {
                    if (!ServerSettings.instance.logSkippedRecipes) continue;
                    ConsoleJS.SERVER.info("Skipping loading recipe " + recipeIdAndType + " as it's conditions were not met");
                    continue;
                }
                recipe3.deserializeJson();
                this.originalRecipes.add(recipe3);
                if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    if (SpecialRecipeSerializerManager.INSTANCE.isSpecial(recipe3.originalRecipe)) {
                        ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": <dynamic>");
                    } else {
                        ConsoleJS.SERVER.debug("Loaded recipe " + recipeIdAndType + ": " + recipe3.getFromToString());
                    }
                }
                if (ServerSettings.dataExport == null) continue;
                JsonObject exp = new JsonObject();
                exp.add("recipe", (JsonElement)json);
                if (!recipe3.inputItems.isEmpty()) {
                    array = new JsonArray();
                    for (IngredientJS in : recipe3.inputItems) {
                        array.add(in.toJson());
                    }
                    exp.add("inputs", (JsonElement)array);
                }
                if (!recipe3.outputItems.isEmpty()) {
                    array = new JsonArray();
                    for (ItemStackJS out : recipe3.outputItems) {
                        array.add(out.toResultJson());
                    }
                    exp.add("outputs", (JsonElement)array);
                }
                allRecipeMap.add(recipe3.getId(), (JsonElement)exp);
            }
            catch (Throwable ex) {
                if (!(ex instanceof RecipeExceptionJS) || ((RecipeExceptionJS)ex).fallback) {
                    if (ServerSettings.instance.logErroringRecipes) {
                        ConsoleJS.SERVER.warn("Failed to parse recipe '" + recipeIdAndType + "'! Falling back to vanilla", ex, SKIP_ERROR);
                    }
                    try {
                        this.fallbackedRecipes.add(Objects.requireNonNull(RecipeManager.func_215377_a((ResourceLocation)recipeId, (JsonObject)entry.getValue())));
                    }
                    catch (JsonParseException | IllegalArgumentException | NullPointerException ex2) {
                        if (!ServerSettings.instance.logErroringRecipes) continue;
                        ConsoleJS.SERVER.warn("Failed to parse recipe " + recipeIdAndType, ex2, SKIP_ERROR);
                    }
                    catch (Exception ex3) {
                        ConsoleJS.SERVER.warn("Failed to parse recipe " + recipeIdAndType + ":");
                        ConsoleJS.SERVER.printStackTrace(ex3, SKIP_ERROR);
                    }
                    continue;
                }
                if (!ServerSettings.instance.logErroringRecipes) continue;
                ConsoleJS.SERVER.warn("Failed to parse recipe '" + recipeIdAndType + "'", ex, SKIP_ERROR);
            }
        }
        MutableInt removed = new MutableInt(0);
        MutableInt added = new MutableInt(0);
        MutableInt failed = new MutableInt(0);
        MutableInt fallbacked = new MutableInt(0);
        this.modifiedRecipesCount = new AtomicInteger(0);
        ConsoleJS.SERVER.info("Found " + this.originalRecipes.size() + " recipes and " + this.fallbackedRecipes.size() + " failed recipes in " + timer.stop());
        timer.reset().start();
        ConsoleJS.SERVER.setLineNumber(true);
        this.post(ScriptType.SERVER, "recipes");
        ConsoleJS.SERVER.setLineNumber(false);
        ConsoleJS.SERVER.info("Posted recipe events in " + timer.stop());
        HashMap newRecipeMap = new HashMap();
        HashMap existingRecipes = new HashMap();
        timer.reset().start();
        this.originalRecipes.stream().filter(recipe -> {
            if (this.removedRecipes.contains(recipe)) {
                removed.increment();
                return false;
            }
            return true;
        }).map(recipe -> {
            try {
                recipe.originalRecipe = recipe.createRecipe();
            }
            catch (Throwable ex) {
                ConsoleJS.SERVER.warn("Error parsing recipe " + recipe + ": " + recipe.json, ex);
                failed.increment();
            }
            if (recipe.originalRecipe != null) {
                existingRecipes.put(recipe.id, recipe.originalRecipe.func_222127_g());
            }
            return recipe.originalRecipe;
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(IRecipe::func_222127_g, Collectors.groupingBy(IRecipe::func_199560_c, Collectors.reducing(null, Function.identity(), (recipe, recipe2) -> recipe2)))).forEach((recipeType, map) -> newRecipeMap.computeIfAbsent((IRecipeType<?>)recipeType, type -> new HashMap()).putAll(map));
        this.fallbackedRecipes.stream().filter(Objects::nonNull).peek(recipe -> existingRecipes.put(recipe.func_199560_c(), recipe.func_222127_g())).collect(Collectors.groupingBy(IRecipe::func_222127_g, Collectors.groupingBy(IRecipe::func_199560_c, Collectors.reducing(null, Function.identity(), (recipe, recipe2) -> recipe2)))).forEach((recipeType, map) -> {
            fallbacked.add(map.size());
            newRecipeMap.computeIfAbsent((IRecipeType<?>)recipeType, type -> new HashMap()).putAll(map);
        });
        ConsoleJS.SERVER.info("Modified & removed recipes in " + timer.stop());
        timer.reset().start();
        this.addedRecipes.stream().map(recipe -> {
            ResourceLocation id;
            IRecipeType t;
            try {
                recipe.originalRecipe = recipe.createRecipe();
            }
            catch (Throwable ex) {
                ConsoleJS.SERVER.warn("Error creating recipe " + recipe + ": " + recipe.json, ex, SKIP_ERROR);
                failed.increment();
            }
            if (recipe.originalRecipe != null && (t = (IRecipeType)existingRecipes.remove(id = recipe.getOrCreateId())) != null) {
                ((Map)newRecipeMap.get(t)).remove(id);
                if (ServerSettings.instance.logOverrides) {
                    ConsoleJS.SERVER.info("Overriding existing recipe with ID " + id + "(" + t + " => " + recipe.getType() + ")");
                }
            }
            return recipe.originalRecipe;
        }).filter(Objects::nonNull).collect(Collectors.groupingBy(IRecipe::func_222127_g, Collectors.groupingBy(IRecipe::func_199560_c, Collectors.reducing(null, Function.identity(), (recipe, recipe2) -> recipe2)))).forEach((recipeType, map) -> {
            added.add(map.size());
            newRecipeMap.computeIfAbsent((IRecipeType<?>)recipeType, type -> new HashMap()).putAll(map);
        });
        if (ServerSettings.dataExport != null) {
            for (RecipeJS r : this.removedRecipes) {
                JsonElement e = allRecipeMap.get(r.getId());
                if (!(e instanceof JsonObject)) continue;
                ((JsonObject)e).addProperty("removed", Boolean.valueOf(true));
            }
            ServerSettings.dataExport.add("recipes", (JsonElement)allRecipeMap);
        }
        ConsoleJS.SERVER.info("Added recipes in " + timer.stop());
        RecipeEventJS.pingNewRecipes(newRecipeMap);
        ((RecipeManagerKJS)recipeManager).setRecipesKJS(newRecipeMap);
        ConsoleJS.SERVER.info("Added " + added.getValue() + " recipes, removed " + removed.getValue() + " recipes, modified " + this.modifiedRecipesCount.get() + " recipes, with " + failed.getValue() + " failed recipes and " + fallbacked.getValue() + " fall-backed recipes");
        RecipeJS.itemErrors = false;
        if (CommonProperties.get().debugInfo) {
            ConsoleJS.SERVER.info("======== Debug output of all added recipes ========");
            for (RecipeJS r : this.addedRecipes) {
                ConsoleJS.SERVER.info(r.id + ": " + r.json);
            }
            ConsoleJS.SERVER.info("======== Debug output of all modified recipes ========");
            for (RecipeJS r : this.modifiedRecipes) {
                ConsoleJS.SERVER.info(r.id + ": " + r.json);
            }
            ConsoleJS.SERVER.info("======== Debug output of all removed recipes ========");
            for (RecipeJS r : this.removedRecipes) {
                ConsoleJS.SERVER.info(r.id + ": " + r.json);
            }
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void pingNewRecipes(Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> map) {
        RecipeEventJSImpl.pingNewRecipes(map);
    }

    public Map<String, Object> getRecipes() {
        return this.recipeFunctions;
    }

    public RecipeJS addRecipe(RecipeJS r, RecipeTypeJS type, ListJS args1) {
        this.addedRecipes.add(r);
        if (ServerSettings.instance.logAddedRecipes) {
            ConsoleJS.SERVER.info("+ " + r.getType() + ": " + r.getFromToString());
        } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
            ConsoleJS.SERVER.debug("+ " + r.getType() + ": " + r.getFromToString());
        }
        return r;
    }

    public RecipeFilter customFilter(RecipeFilter filter) {
        return filter;
    }

    public void forEachRecipe(RecipeFilter filter, Consumer<RecipeJS> consumer) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            this.originalRecipes.forEach(consumer);
        } else if (filter != RecipeFilter.ALWAYS_FALSE) {
            this.originalRecipes.stream().filter(filter).forEach(consumer);
        }
    }

    public void forEachRecipeAsync(RecipeFilter filter, Consumer<RecipeJS> consumer) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            this.originalRecipes.parallelStream().forEach(consumer);
        } else if (filter != RecipeFilter.ALWAYS_FALSE) {
            this.originalRecipes.parallelStream().filter(filter).forEach(consumer);
        }
    }

    public int countRecipes(RecipeFilter filter) {
        if (filter == RecipeFilter.ALWAYS_TRUE) {
            return this.originalRecipes.size();
        }
        if (filter != RecipeFilter.ALWAYS_FALSE) {
            return (int)this.originalRecipes.stream().filter(filter).count();
        }
        return 0;
    }

    public int remove(RecipeFilter filter) {
        MutableInt count = new MutableInt();
        this.forEachRecipe(filter, r -> {
            if (this.removedRecipes.add((RecipeJS)r)) {
                if (ServerSettings.instance.logRemovedRecipes) {
                    ConsoleJS.SERVER.info("- " + r + ": " + r.getFromToString());
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("- " + r + ": " + r.getFromToString());
                }
                count.increment();
            }
        });
        return count.getValue();
    }

    public int replaceInput(RecipeFilter filter, IngredientJS ingredient, IngredientJS with, boolean exact) {
        AtomicInteger count = new AtomicInteger();
        String is = ingredient.toString();
        String ws = with.toString();
        this.forEachRecipeAsync(filter, r -> {
            if (r.replaceInput(ingredient, with, exact)) {
                count.incrementAndGet();
                this.modifiedRecipes.add((RecipeJS)r);
                if (ServerSettings.instance.logAddedRecipes || ServerSettings.instance.logRemovedRecipes) {
                    ConsoleJS.SERVER.info("~ " + r + ": IN " + is + " -> " + ws);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + r + ": IN " + is + " -> " + ws);
                }
            }
        });
        this.modifiedRecipesCount.addAndGet(count.get());
        return count.get();
    }

    public int replaceInput(RecipeFilter filter, IngredientJS ingredient, IngredientJS with) {
        return this.replaceInput(filter, ingredient, with, false);
    }

    public int replaceInput(IngredientJS ingredient, IngredientJS with) {
        return this.replaceInput(RecipeFilter.ALWAYS_TRUE, ingredient, with);
    }

    public int replaceOutput(RecipeFilter filter, IngredientJS ingredient, ItemStackJS with, boolean exact) {
        AtomicInteger count = new AtomicInteger();
        String is = ingredient.toString();
        String ws = with.toString();
        this.forEachRecipeAsync(filter, r -> {
            if (r.replaceOutput(ingredient, with, exact)) {
                count.incrementAndGet();
                this.modifiedRecipes.add((RecipeJS)r);
                if (ServerSettings.instance.logAddedRecipes || ServerSettings.instance.logRemovedRecipes) {
                    ConsoleJS.SERVER.info("~ " + r + ": OUT " + is + " -> " + ws);
                } else if (ConsoleJS.SERVER.shouldPrintDebug()) {
                    ConsoleJS.SERVER.debug("~ " + r + ": OUT " + is + " -> " + ws);
                }
            }
        });
        this.modifiedRecipesCount.addAndGet(count.get());
        return count.get();
    }

    public int replaceOutput(RecipeFilter filter, IngredientJS ingredient, ItemStackJS with) {
        return this.replaceOutput(filter, ingredient, with, false);
    }

    public int replaceOutput(IngredientJS ingredient, ItemStackJS with) {
        return this.replaceOutput(RecipeFilter.ALWAYS_TRUE, ingredient, with);
    }

    public RecipeFunction getRecipeFunction(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            throw new NullPointerException("Recipe type is null!");
        }
        String namespace = UtilsJS.getNamespace(id);
        String path = UtilsJS.getPath(id);
        Object func0 = this.recipeFunctions.get(namespace);
        if (func0 instanceof RecipeFunction) {
            return (RecipeFunction)func0;
        }
        if (!(func0 instanceof Map)) {
            throw new NullPointerException("Unknown recipe type: " + id);
        }
        RecipeFunction func = (RecipeFunction)((Map)func0).get(path);
        if (func == null) {
            throw new NullPointerException("Unknown recipe type: " + id);
        }
        return func;
    }

    public RecipeJS custom(Object o) {
        MapJS json = Objects.requireNonNull(MapJS.of(o));
        return this.getRecipeFunction(json.getOrDefault("type", "").toString()).createRecipe(new Object[]{json});
    }

    public void printTypes() {
        ConsoleJS.SERVER.info("== All recipe types [used] ==");
        HashSet list = new HashSet();
        this.originalRecipes.forEach(r -> list.add(r.type.toString()));
        list.stream().sorted().forEach(ConsoleJS.SERVER::info);
        ConsoleJS.SERVER.info(list.size() + " types");
    }

    public void printAllTypes() {
        ConsoleJS.SERVER.info("== All recipe types [available] ==");
        List<String> list = KubeJSRegistries.recipeSerializers().entrySet().stream().map(e -> ((RegistryKey)e.getKey()).func_240901_a_().toString()).sorted().collect(Collectors.toList());
        list.forEach(ConsoleJS.SERVER::info);
        ConsoleJS.SERVER.info(list.size() + " types");
    }

    public void printExamples(String type) {
        List list = this.originalRecipes.stream().filter(recipeJS -> recipeJS.type.toString().equals(type)).collect(Collectors.toList());
        Collections.shuffle(list);
        ConsoleJS.SERVER.info("== Random examples of '" + type + "' ==");
        for (int i = 0; i < Math.min(list.size(), 5); ++i) {
            RecipeJS r = (RecipeJS)list.get(i);
            ConsoleJS.SERVER.info("- " + r.getOrCreateId() + ":\n" + JsonUtilsJS.toPrettyString((JsonElement)r.json));
        }
    }

    public void setItemErrors(boolean b) {
        RecipeJS.itemErrors = b;
    }

    public void stage(RecipeFilter filter, String stage) {
        this.forEachRecipe(filter, r -> r.stage(stage));
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean processConditions(JsonObject json, String key) {
        void var1_1;
        return RecipeEventJSImpl.processConditions(json, (String)var1_1);
    }
}

