/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.loot;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.event.EventJS;
import dev.latvian.kubejs.loot.LootBuilder;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class LootEventJS
extends EventJS {
    private final Map<ResourceLocation, JsonElement> lootMap;

    public LootEventJS(Map<ResourceLocation, JsonElement> c) {
        this.lootMap = c;
    }

    public void addJson(ResourceLocation id, JsonObject json) {
        this.lootMap.put(this.getDirectory().isEmpty() ? id : new ResourceLocation(id.func_110624_b(), this.getDirectory() + "/" + id.func_110623_a()), (JsonElement)json);
    }

    public abstract String getType();

    public abstract String getDirectory();

    LootBuilder createLootBuilder(@Nullable ResourceLocation id, Consumer<LootBuilder> consumer) {
        LootBuilder builder = new LootBuilder(id == null ? null : this.lootMap.get(id));
        builder.type = this.getType();
        consumer.accept(builder);
        return builder;
    }

    public void modify(ResourceLocation id, Consumer<LootBuilder> b) {
        LootBuilder builder = this.createLootBuilder(this.getDirectory().isEmpty() ? id : new ResourceLocation(id.func_110624_b(), this.getDirectory() + "/" + id.func_110623_a()), b);
        this.addJson(id, builder.toJson());
    }

    public void removeAll() {
        this.lootMap.clear();
    }
}

