/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.util.ConsoleJS;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public final class WeakNBTIngredientJS
implements IngredientJS {
    private static final boolean NBTIP_INSTALLED = Platform.isModLoaded((String)"nbt_ingredient_predicate");
    private final ItemStackJS item;

    public WeakNBTIngredientJS(ItemStackJS i) {
        this.item = i;
    }

    @Override
    public boolean test(ItemStackJS stack) {
        if (this.item.areItemsEqual(stack) && this.item.hasNBT() == stack.hasNBT()) {
            if (this.item.hasNBT()) {
                for (String key : this.item.getNbt().func_150296_c()) {
                    if (Objects.equals(this.item.getNbt().func_74781_a(key), stack.getNbt().func_74781_a(key))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean testVanilla(ItemStack stack) {
        if (this.item.areItemsEqual(stack) && this.item.hasNBT() == stack.func_77942_o()) {
            if (this.item.hasNBT()) {
                CompoundNBT t = this.item.getNbt();
                for (String key : t.func_150296_c()) {
                    if (Objects.equals(t.func_74781_a(key), stack.func_77978_p().func_74781_a(key))) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean testVanillaItem(Item i) {
        return this.item.getItem() == i;
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return this.item.getStacks();
    }

    @Override
    public Set<Item> getVanillaItems() {
        return Collections.singleton(this.item.getItem());
    }

    @Override
    public IngredientJS copy() {
        return new WeakNBTIngredientJS(this.item.copy());
    }

    @Override
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.item.getId());
        if (this.item.hasNBT()) {
            if (NBTIP_INSTALLED) {
                json.addProperty("type", "nbt_ingredient_predicate:nbt_includes");
            } else {
                json.addProperty("type", "forge:nbt");
                ConsoleJS.SERVER.setLineNumber(true);
                ConsoleJS.SERVER.error("weakNBT() requires 'NBT Ingredient Predicate' mod to be installed! Defaulting to exact match");
                ConsoleJS.SERVER.setLineNumber(false);
            }
            json.addProperty("nbt", this.item.getNbtString());
        }
        return json;
    }
}

