/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item.ingredient;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.item.DummyFluidItemStackJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.CustomIngredient;
import dev.latvian.kubejs.item.ingredient.FilteredIngredientJS;
import dev.latvian.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.kubejs.item.ingredient.MatchAllIngredientJS;
import dev.latvian.kubejs.item.ingredient.MatchAnyIngredientJS;
import dev.latvian.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.kubejs.item.ingredient.NotIngredientJS;
import dev.latvian.kubejs.item.ingredient.RegexIngredientJS;
import dev.latvian.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.kubejs.item.ingredient.VanillaPredicate;
import dev.latvian.kubejs.item.ingredient.forge.IngredientJSImpl;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.Copyable;
import dev.latvian.mods.rhino.mod.util.JsonSerializable;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface IngredientJS
extends JsonSerializable,
WrappedJS,
Copyable {
    public static IngredientJS of(@Nullable Object o) {
        if (o instanceof Wrapper) {
            o = ((Wrapper)o).unwrap();
        }
        if (o == null || o == ItemStack.field_190927_a || o == Items.field_190931_a) {
            return ItemStackJS.EMPTY;
        }
        if (o instanceof IngredientJS) {
            return (IngredientJS)o;
        }
        if (o instanceof FluidStackJS) {
            return new DummyFluidItemStackJS((FluidStackJS)o);
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = UtilsJS.parseRegex(o);
            if (reg != null) {
                return new RegexIngredientJS(reg);
            }
            return ItemStackJS.EMPTY;
        }
        if (o instanceof JsonElement) {
            return IngredientJS.ingredientFromRecipeJson((JsonElement)o);
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            if (RecipeJS.itemErrors && count <= 0) {
                throw new RecipeExceptionJS("Invalid count!").error();
            }
            if (s.equals("*")) {
                return MatchAllIngredientJS.INSTANCE.withCount(count);
            }
            if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
                return ItemStackJS.EMPTY;
            }
            if (s.startsWith("#")) {
                return TagIngredientJS.createTag(s.substring(1)).withCount(count);
            }
            if (s.startsWith("@")) {
                return new ModIngredientJS(s.substring(1)).withCount(count);
            }
            if (s.startsWith("%")) {
                ItemGroup group = ItemStackJS.findGroup(s.substring(1));
                if (group == null) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item group '" + s.substring(1) + "' not found!").error();
                    }
                    return ItemStackJS.EMPTY;
                }
                return new GroupIngredientJS(group).withCount(count);
            }
            Pattern reg = UtilsJS.parseRegex(s);
            if (reg != null) {
                return new RegexIngredientJS(reg).withCount(count);
            }
            Item item = (Item)KubeJSRegistries.items().get(new ResourceLocation(s));
            if (item == Items.field_190931_a) {
                return ItemStackJS.EMPTY;
            }
            return new ItemStackJS(new ItemStack((IItemProvider)item, count));
        }
        if (o instanceof Ingredient) {
            if (((Ingredient)o).func_203189_d()) {
                return ItemStackJS.EMPTY;
            }
            ArrayList<ItemStackJS> in = new ArrayList<ItemStackJS>();
            for (ItemStack stack : ((Ingredient)o).func_193365_a()) {
                if (stack.func_190926_b()) continue;
                in.add(ItemStackJS.of(stack));
            }
            return IngredientJS.of(in);
        }
        ListJS list = ListJS.of(o);
        if (list != null) {
            MatchAnyIngredientJS l = new MatchAnyIngredientJS();
            for (Object o1 : list) {
                IngredientJS ingredient = IngredientJS.of(o1);
                if (ingredient == ItemStackJS.EMPTY) continue;
                l.ingredients.add(ingredient);
            }
            return l.ingredients.isEmpty() ? ItemStackJS.EMPTY : l;
        }
        MapJS map = MapJS.of(o);
        if (map != null) {
            IngredientJS in = ItemStackJS.EMPTY;
            boolean val = map.containsKey("value");
            if (map.containsKey("type")) {
                JsonObject json = map.toJson();
                try {
                    Ingredient ingredient = IngredientJS.getCustomIngredient(json);
                    return new CustomIngredient(ingredient, json);
                }
                catch (Exception ex) {
                    throw new RecipeExceptionJS("Failed to parse custom ingredient (" + json.get("type") + ") from " + json + ": " + ex).fallback();
                }
            }
            if (val || map.containsKey("ingredient")) {
                in = IngredientJS.of(val ? map.get("value") : map.get("ingredient"));
            } else if (map.containsKey("tag")) {
                in = TagIngredientJS.createTag(map.get("tag").toString());
            } else if (map.containsKey("item")) {
                in = ItemStackJS.of(map);
            } else if (map.containsKey("fluid")) {
                return new DummyFluidItemStackJS(FluidStackJS.of(map));
            }
            if (map.containsKey("count")) {
                in = in.withCount(UtilsJS.parseInt(map.get("count"), 1));
            } else if (map.containsKey("amount") && (in = in.withCount(UtilsJS.parseInt(map.get("amount"), 1))) instanceof IngredientStackJS) {
                ((IngredientStackJS)in).countKey = "amount";
            }
            if (val && in instanceof IngredientStackJS) {
                ((IngredientStackJS)in).ingredientKey = "value";
            }
            return in;
        }
        return ItemStackJS.of(o);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Ingredient getCustomIngredient(JsonObject object) {
        return IngredientJSImpl.getCustomIngredient(object);
    }

    public static IngredientJS ingredientFromRecipeJson(JsonElement json) {
        if (json.isJsonArray()) {
            MatchAnyIngredientJS any = new MatchAnyIngredientJS();
            for (JsonElement e : json.getAsJsonArray()) {
                any.ingredients.add(IngredientJS.ingredientFromRecipeJson(e));
            }
            return any;
        }
        if (json.isJsonPrimitive()) {
            return IngredientJS.of(json.getAsString());
        }
        if (json.isJsonObject()) {
            JsonObject o = json.getAsJsonObject();
            IngredientJS in = ItemStackJS.EMPTY;
            boolean val = o.has("value");
            if (o.has("type")) {
                try {
                    Ingredient ingredient = IngredientJS.getCustomIngredient(o);
                    return new CustomIngredient(ingredient, o);
                }
                catch (Exception ex) {
                    throw new RecipeExceptionJS("Failed to parse custom ingredient (" + o.get("type") + ") from " + o + ": " + ex);
                }
            }
            if (val || o.has("ingredient")) {
                in = IngredientJS.ingredientFromRecipeJson(val ? o.get("value") : o.get("ingredient"));
            } else if (o.has("tag")) {
                in = TagIngredientJS.createTag(o.get("tag").getAsString());
            } else if (o.has("item")) {
                in = ItemStackJS.of(o.get("item").getAsString());
            }
            if (o.has("count")) {
                in = in.withCount(o.get("count").getAsInt());
            } else if (o.has("amount") && (in = in.withCount(o.get("amount").getAsInt())) instanceof IngredientStackJS) {
                ((IngredientStackJS)in).countKey = "amount";
            }
            if (val && in instanceof IngredientStackJS) {
                ((IngredientStackJS)in).ingredientKey = "value";
            }
            return in;
        }
        return ItemStackJS.EMPTY;
    }

    public boolean test(ItemStackJS var1);

    default public boolean testVanilla(ItemStack stack) {
        return this.test(new ItemStackJS(stack));
    }

    default public boolean testVanillaItem(Item item) {
        return this.test(new ItemStackJS(new ItemStack((IItemProvider)item)));
    }

    default public Predicate<ItemStack> getVanillaPredicate() {
        return new VanillaPredicate(this);
    }

    default public boolean isEmpty() {
        return this.getFirst().isEmpty();
    }

    default public boolean isInvalidRecipeIngredient() {
        return false;
    }

    default public Set<ItemStackJS> getStacks() {
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        for (ItemStackJS stack : ItemStackJS.getList()) {
            if (!this.test(stack)) continue;
            set.add(stack.copy());
        }
        return set;
    }

    default public Set<Item> getVanillaItems() {
        LinkedHashSet<Item> set = new LinkedHashSet<Item>();
        for (Item item : KubeJSRegistries.items()) {
            if (item == Items.field_190931_a || !this.testVanillaItem(item)) continue;
            set.add(item);
        }
        return set;
    }

    default public Set<String> getItemIds() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (Item item : this.getVanillaItems()) {
            ResourceLocation id = KubeJSRegistries.items().getId((Object)item);
            if (id == null) continue;
            ids.add(id.toString());
        }
        return ids;
    }

    default public IngredientJS filter(IngredientJS filter) {
        return new FilteredIngredientJS(this, filter);
    }

    default public IngredientJS not() {
        return new NotIngredientJS(this);
    }

    default public ItemStackJS getFirst() {
        for (ItemStackJS stack : this.getStacks()) {
            if (stack.isEmpty()) continue;
            return stack.withCount(this.getCount());
        }
        return ItemStackJS.EMPTY;
    }

    default public IngredientJS withCount(int count) {
        if (count <= 0) {
            return ItemStackJS.EMPTY;
        }
        return count == 1 ? this.copy() : new IngredientStackJS(this.copy(), count);
    }

    default public IngredientJS x(int c) {
        return this.withCount(c);
    }

    default public IngredientJS copy() {
        return this;
    }

    default public int getCount() {
        return 1;
    }

    default public JsonElement toJson() {
        Set<ItemStackJS> set = this.getStacks();
        if (set.size() == 1) {
            return set.iterator().next().toJson();
        }
        JsonArray array = new JsonArray();
        for (ItemStackJS stackJS : set) {
            array.add(stackJS.toJson());
        }
        return array;
    }

    default public boolean anyStackMatches(IngredientJS ingredient) {
        for (ItemStackJS stack : this.getStacks()) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    default public IngredientStackJS asIngredientStack() {
        return new IngredientStackJS(this.withCount(1), this.getCount());
    }

    default public List<IngredientJS> unwrapStackIngredient() {
        int count = this.getCount();
        if (count <= 0) {
            return Collections.singletonList(this.withCount(1));
        }
        ArrayList<IngredientJS> list = new ArrayList<IngredientJS>();
        for (int i = 0; i < count; ++i) {
            list.add(this.withCount(1));
        }
        return list;
    }

    default public Ingredient createVanillaIngredient() {
        return Ingredient.func_234819_a_(this.getStacks().stream().map(ItemStackJS::getItemStack));
    }
}

