/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.item.DummyFluidItemStackJS;
import dev.latvian.kubejs.item.DummyItemStackJSIngredient;
import dev.latvian.kubejs.item.forge.ItemStackJSImpl;
import dev.latvian.kubejs.item.ingredient.GroupIngredientJS;
import dev.latvian.kubejs.item.ingredient.IgnoreNBTIngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.kubejs.item.ingredient.MatchAllIngredientJS;
import dev.latvian.kubejs.item.ingredient.ModIngredientJS;
import dev.latvian.kubejs.item.ingredient.RegexIngredientJS;
import dev.latvian.kubejs.item.ingredient.TagIngredientJS;
import dev.latvian.kubejs.item.ingredient.WeakNBTIngredientJS;
import dev.latvian.kubejs.player.PlayerJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.recipe.RecipeJS;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.Tags;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.ChangeListener;
import dev.latvian.mods.rhino.mod.util.CompoundTagWrapper;
import dev.latvian.mods.rhino.mod.util.NBTSerializable;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.util.SpecialEquality;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.registry.ToolType;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.BlockItem;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ItemStackJS
implements IngredientJS,
NBTSerializable,
ChangeListener<INBT>,
SpecialEquality {
    public static final ItemStackJS EMPTY = new ItemStackJS(ItemStack.field_190927_a){

        @Override
        public String getId() {
            return "minecraft:air";
        }

        @Override
        public Collection<ResourceLocation> getTags() {
            return Collections.emptySet();
        }

        @Override
        public boolean hasTag(ResourceLocation tag) {
            return false;
        }

        @Override
        public Item getItem() {
            return Items.field_190931_a;
        }

        @Override
        public ItemStackJS copy() {
            return this;
        }

        @Override
        public void setCount(int c) {
        }

        @Override
        public int getCount() {
            return 0;
        }

        @Override
        public ItemStackJS withCount(int c) {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Nullable
        public CompoundNBT getNbt() {
            return null;
        }

        @Override
        public void setNbt(@Nullable CompoundNBT tag) {
        }

        @Override
        public boolean hasNBT() {
            return false;
        }

        @Override
        public String getNbtString() {
            return "null";
        }

        @Override
        public ItemStackJS removeNBT() {
            return this;
        }

        @Override
        public ItemStackJS withNBT(CompoundNBT nbt) {
            return this;
        }

        @Override
        public void setChance(double c) {
        }

        @Override
        public double getChance() {
            return Double.NaN;
        }

        @Override
        public boolean hasChance() {
            return false;
        }

        @Override
        public String toString() {
            return "item.empty";
        }

        @Override
        public boolean test(ItemStackJS other) {
            return false;
        }

        @Override
        public boolean testVanilla(ItemStack other) {
            return false;
        }

        @Override
        public boolean testVanillaItem(Item item) {
            return false;
        }

        @Override
        public Set<ItemStackJS> getStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<Item> getVanillaItems() {
            return Collections.emptySet();
        }

        @Override
        public ItemStackJS getFirst() {
            return this;
        }

        @Override
        public IngredientJS not() {
            return MatchAllIngredientJS.INSTANCE;
        }

        @Override
        public ItemStackJS withName(@Nullable ITextComponent displayName) {
            return this;
        }

        @Override
        public MapJS getEnchantments() {
            return new MapJS(){

                @Override
                protected boolean setChangeListener(@Nullable Object v) {
                    return false;
                }
            };
        }

        @Override
        public boolean hasEnchantment(Enchantment enchantment, int level) {
            return false;
        }

        @Override
        public ItemStackJS enchant(MapJS map) {
            return this;
        }

        @Override
        public ItemStackJS enchant(Enchantment enchantment, int level) {
            return this;
        }

        @Override
        public String getMod() {
            return "minecraft";
        }

        @Override
        public boolean areItemsEqual(ItemStackJS other) {
            return other.isEmpty();
        }

        @Override
        public boolean areItemsEqual(ItemStack other) {
            return other.func_190926_b();
        }

        @Override
        public boolean isNBTEqual(ItemStackJS other) {
            return !other.hasNBT();
        }

        @Override
        public boolean isNBTEqual(ItemStack other) {
            return !other.func_77942_o();
        }

        @Override
        public boolean equals(Object o) {
            return 1.of(o).isEmpty();
        }

        @Override
        public boolean strongEquals(Object o) {
            return 1.of(o).isEmpty();
        }

        @Override
        public int getHarvestLevel(ToolType tool, @Nullable PlayerJS<?> player, @Nullable BlockContainerJS block) {
            return -1;
        }

        @Override
        public JsonElement toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", "minecraft:air");
            return json;
        }

        @Override
        public JsonElement toRawResultJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", "minecraft:air");
            json.addProperty("count", (Number)1);
            return json;
        }

        @Override
        public void onChanged(@Nullable INBT o) {
        }

        @Override
        public String getItemGroup() {
            return "";
        }
    };
    private static List<ItemStackJS> cachedItemList;
    private static ListJS cachedItemListJS;
    private static ListJS cachedItemTypeListJS;
    private final ItemStack stack;
    private double chance = Double.NaN;

    public static ItemStackJS of(@Nullable Object o) {
        if (o instanceof Wrapper) {
            o = ((Wrapper)o).unwrap();
        }
        if (o == null || o == ItemStack.field_190927_a || o == Items.field_190931_a) {
            return EMPTY;
        }
        if (o instanceof ItemStackJS) {
            return (ItemStackJS)o;
        }
        if (o instanceof FluidStackJS) {
            return new DummyFluidItemStackJS((FluidStackJS)o);
        }
        if (o instanceof IngredientJS) {
            return ((IngredientJS)o).getFirst();
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return stack.func_190926_b() ? EMPTY : new ItemStackJS(stack);
        }
        if (o instanceof ResourceLocation) {
            Item item = (Item)KubeJSRegistries.items().get((ResourceLocation)o);
            if (item == Items.field_190931_a) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item '" + o + "' not found!").error();
                }
                return EMPTY;
            }
            return new ItemStackJS(new ItemStack((IItemProvider)item));
        }
        if (o instanceof IItemProvider) {
            return new ItemStackJS(new ItemStack((IItemProvider)((IItemProvider)o).func_199767_j()));
        }
        if (o instanceof JsonElement) {
            return ItemStackJS.resultFromRecipeJson((JsonElement)o);
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = UtilsJS.parseRegex(o);
            if (reg != null) {
                return new RegexIngredientJS(reg).getFirst();
            }
            return EMPTY;
        }
        if (o instanceof CharSequence) {
            String s = o.toString().trim();
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
                return EMPTY;
            }
            if (s.startsWith("#")) {
                return TagIngredientJS.createTag(s.substring(1)).getFirst().withCount(count);
            }
            if (s.startsWith("@")) {
                return new ModIngredientJS(s.substring(1)).getFirst().withCount(count);
            }
            if (s.startsWith("%")) {
                ItemGroup group = ItemStackJS.findGroup(s.substring(1));
                if (group == null) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item group '" + s.substring(1) + "' not found!").error();
                    }
                    return EMPTY;
                }
                return new GroupIngredientJS(group).getFirst().withCount(count);
            }
            Pattern reg = UtilsJS.parseRegex(s);
            if (reg != null) {
                return new RegexIngredientJS(reg).getFirst().withCount(count);
            }
            Item item = (Item)KubeJSRegistries.items().get(new ResourceLocation(s));
            if (item == Items.field_190931_a) {
                if (RecipeJS.itemErrors) {
                    throw new RecipeExceptionJS("Item '" + s + "' not found!").error();
                }
                return EMPTY;
            }
            return new ItemStackJS(new ItemStack((IItemProvider)item, count));
        }
        MapJS map = MapJS.of(o);
        if (map != null) {
            if (map.containsKey("item")) {
                String id = KubeJS.appendModId(map.get("item").toString());
                Item item = (Item)KubeJSRegistries.items().get(new ResourceLocation(id));
                if (item == Items.field_190931_a) {
                    if (RecipeJS.itemErrors) {
                        throw new RecipeExceptionJS("Item '" + id + "' not found!").error();
                    }
                    return EMPTY;
                }
                ItemStack stack = new ItemStack((IItemProvider)item);
                if (map.get("count") instanceof Number) {
                    stack.func_190920_e(((Number)map.get("count")).intValue());
                }
                if (map.containsKey("nbt")) {
                    stack.func_77982_d(MapJS.nbt(map.get("nbt")));
                }
                return new ItemStackJS(stack);
            }
            if (map.get("tag") instanceof CharSequence) {
                ItemStackJS stack = TagIngredientJS.createTag(map.get("tag").toString()).getFirst();
                if (map.containsKey("count")) {
                    stack.setCount(UtilsJS.parseInt(map.get("count"), 1));
                }
                return stack;
            }
            if (map.get("fluid") instanceof CharSequence) {
                return new DummyFluidItemStackJS(FluidStackJS.of(map));
            }
        }
        return EMPTY;
    }

    public static Item getRawItem(@Nullable Object o) {
        if (o == null) {
            return Items.field_190931_a;
        }
        if (o instanceof Item) {
            return (Item)o;
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s == null || s.isEmpty()) {
                return Items.field_190931_a;
            }
            if (s.charAt(0) != '#') {
                return (Item)KubeJSRegistries.items().get(UtilsJS.getMCID(s));
            }
        }
        return ItemStackJS.of(o).getItem();
    }

    public static ItemStackJS resultFromRecipeJson(@Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackJS.of(json.getAsString());
        }
        if (json.isJsonObject()) {
            ItemStackJS is;
            JsonObject o = json.getAsJsonObject();
            if (RecipeJS.currentRecipe != null && (is = RecipeJS.currentRecipe.resultFromRecipeJson(o)) != null) {
                return is;
            }
            if (o.has("item")) {
                ItemStackJS stack = ItemStackJS.of(o.get("item").getAsString());
                if (o.has("count")) {
                    stack.setCount(o.get("count").getAsInt());
                }
                if (o.has("nbt")) {
                    JsonElement element = o.get("nbt");
                    stack = element.isJsonObject() ? stack.withNBT(MapJS.nbt(element)) : stack.withNBT(MapJS.nbt(element.getAsString()));
                }
                if (o.has("chance")) {
                    boolean locked = o.has("locked") && o.get("locked").getAsBoolean();
                    double c = o.get("chance").getAsDouble();
                    stack.setChance(locked ? -c : c);
                }
                return stack;
            }
            if (o.has("tag")) {
                int c = 1;
                if (o.has("count")) {
                    c = o.get("count").getAsInt();
                } else if (o.has("amount")) {
                    c = o.get("amount").getAsInt();
                }
                return TagIngredientJS.createTag(o.get("tag").getAsString()).getFirst().withCount(c);
            }
        }
        return EMPTY;
    }

    public static List<ItemStackJS> getList() {
        if (cachedItemList != null) {
            return cachedItemList;
        }
        LinkedHashSet<ItemStackJS> set = new LinkedHashSet<ItemStackJS>();
        NonNullList stackList = NonNullList.func_191196_a();
        for (Item item : KubeJSRegistries.items()) {
            try {
                item.func_150895_a(ItemGroup.field_78027_g, stackList);
            }
            catch (Throwable throwable) {}
        }
        for (ItemStack stack : stackList) {
            if (stack.func_190926_b()) continue;
            set.add(new ItemStackJS(stack).withCount(1));
        }
        cachedItemList = Collections.unmodifiableList(Arrays.asList(set.toArray(new ItemStackJS[0])));
        return cachedItemList;
    }

    public static ListJS getListJS() {
        if (cachedItemListJS == null) {
            cachedItemListJS = Objects.requireNonNull(ListJS.of(ItemStackJS.getList()));
        }
        return cachedItemListJS;
    }

    public static void clearListCache() {
        cachedItemList = null;
        cachedItemListJS = null;
    }

    public static ListJS getTypeList() {
        if (cachedItemTypeListJS == null) {
            cachedItemTypeListJS = new ListJS();
            for (ResourceLocation id : KubeJSRegistries.items().getIds()) {
                cachedItemTypeListJS.add(id.toString());
            }
        }
        return cachedItemTypeListJS;
    }

    @Nullable
    public static ItemGroup findGroup(String id) {
        for (ItemGroup group : ItemGroup.field_78032_a) {
            if (!id.equals(group.func_200300_c())) continue;
            return group;
        }
        return null;
    }

    public ItemStackJS(ItemStack s) {
        this.stack = s;
    }

    public Item getItem() {
        return this.stack.func_77973_b();
    }

    public ItemStack getItemStack() {
        return this.stack;
    }

    public String getId() {
        return Registries.getId((Object)this.getItem(), (RegistryKey)Registry.field_239714_o_).toString();
    }

    public Collection<ResourceLocation> getTags() {
        return Tags.byItem(this.getItem());
    }

    public boolean hasTag(ResourceLocation tag) {
        return Tags.items().func_241834_b(tag).func_230235_a_((Object)this.getItem());
    }

    @Override
    public ItemStackJS copy() {
        ItemStackJS s = new ItemStackJS(this.stack.func_77946_l());
        s.chance = this.chance;
        return s;
    }

    public void setCount(int count) {
        this.stack.func_190920_e(count);
    }

    @Override
    public int getCount() {
        return this.stack.func_190916_E();
    }

    @Override
    public ItemStackJS withCount(int c) {
        if (c <= 0) {
            return EMPTY;
        }
        ItemStackJS is = this.copy();
        is.setCount(c);
        return is;
    }

    @Override
    @Deprecated
    public final ItemStackJS x(int c) {
        return this.withCount(c);
    }

    @Override
    public boolean isEmpty() {
        return this.stack.func_190926_b();
    }

    @Override
    public boolean isInvalidRecipeIngredient() {
        return this.stack.func_190926_b();
    }

    public boolean isBlock() {
        return this.stack.func_77973_b() instanceof BlockItem;
    }

    @Nullable
    public CompoundNBT getNbt() {
        return this.stack.func_77978_p();
    }

    public void setNbt(@Nullable CompoundNBT tag) {
        this.stack.func_77982_d(tag);
    }

    public boolean hasNBT() {
        return this.stack.func_77942_o();
    }

    public String getNbtString() {
        return String.valueOf(this.getNbt());
    }

    @Deprecated
    @Nullable
    public CompoundNBT getMinecraftNbt() {
        return this.getNbt();
    }

    public ItemStackJS removeNBT() {
        ItemStackJS s = this.copy();
        s.stack.func_77982_d(null);
        return s;
    }

    public ItemStackJS withNBT(CompoundNBT nbt) {
        ItemStack is = this.stack.func_77946_l();
        if (is.func_77978_p() == null) {
            is.func_77982_d(nbt);
        } else if (nbt != null && !nbt.isEmpty()) {
            for (String key : nbt.func_150296_c()) {
                is.func_77978_p().func_218657_a(key, nbt.func_74781_a(key));
            }
        }
        return new ItemStackJS(is).withChance(this.getChance());
    }

    public boolean hasChance() {
        return !Double.isNaN(this.chance);
    }

    public void removeChance() {
        this.setChance(Double.NaN);
    }

    public void setChance(double c) {
        this.chance = c;
    }

    public double getChance() {
        return this.chance;
    }

    public final ItemStackJS withChance(double c) {
        if (Double.isNaN(this.chance) && Double.isNaN(c) || this.chance == c) {
            return this;
        }
        ItemStackJS is = this.copy();
        is.setChance(c);
        return is;
    }

    @Deprecated
    public final ItemStackJS chance(double c) {
        return this.withChance(c);
    }

    public Text getName() {
        return Text.of(this.getItemStack().func_200301_q());
    }

    public ItemStackJS withName(@Nullable ITextComponent displayName) {
        ItemStack is = this.stack.func_77946_l();
        if (displayName != null) {
            is.func_200302_a(displayName);
        } else {
            is.func_135074_t();
        }
        return new ItemStackJS(is);
    }

    public String toString() {
        boolean hasChanceOrNbt;
        StringBuilder builder = new StringBuilder();
        int count = this.getCount();
        boolean bl = hasChanceOrNbt = this.hasChance() || this.hasNBT();
        if (count > 1 && !hasChanceOrNbt) {
            builder.append('\'');
            builder.append(count);
            builder.append("x ");
            builder.append(this.getId());
            builder.append('\'');
        } else if (hasChanceOrNbt) {
            builder.append("Item.of('");
            builder.append(this.getId());
            builder.append('\'');
            ArrayList<Pair> enchants = null;
            if (count > 1) {
                builder.append(", ");
                builder.append(count);
            }
            if (this.hasNBT()) {
                CompoundNBT t = this.getNbt();
                if (t != null && !t.isEmpty()) {
                    String key;
                    String string = key = this.getItem() == Items.field_151134_bR ? "StoredEnchantments" : "Enchantments";
                    if (t.func_150297_b(key, 9)) {
                        ListNBT l = t.func_150295_c(key, 10);
                        enchants = new ArrayList<Pair>(l.size());
                        for (int i = 0; i < l.size(); ++i) {
                            CompoundNBT t1 = l.func_150305_b(i);
                            enchants.add(Pair.of((Object)t1.func_74779_i("id"), (Object)t1.func_74762_e("lvl")));
                        }
                        t = t.func_74737_b();
                        t.func_82580_o(key);
                        if (t.isEmpty()) {
                            t = null;
                        }
                    }
                }
                if (t != null) {
                    builder.append(", ");
                    NBTUtils.quoteAndEscapeForJS((StringBuilder)builder, (String)t.toString());
                }
            }
            builder.append(')');
            if (enchants != null) {
                for (Pair e : enchants) {
                    builder.append(".enchant('");
                    builder.append((String)e.getKey());
                    builder.append("', ");
                    builder.append(e.getValue());
                    builder.append(')');
                }
            }
            if (this.hasChance()) {
                builder.append(".withChance(");
                builder.append(this.getChance());
                builder.append(')');
            }
        } else {
            builder.append('\'');
            builder.append(this.getId());
            builder.append('\'');
        }
        return builder.toString();
    }

    @Override
    public boolean test(ItemStackJS other) {
        return this.testVanilla(other.stack);
    }

    @Override
    public boolean testVanilla(ItemStack other) {
        if (this.stack.func_77973_b() == other.func_77973_b()) {
            CompoundNBT nbt = this.stack.func_77978_p();
            CompoundNBT nbt2 = other.func_77978_p();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    @Override
    public boolean testVanillaItem(Item item) {
        return item == this.getItem();
    }

    @Override
    public Set<ItemStackJS> getStacks() {
        return Collections.singleton(this);
    }

    @Override
    public Set<Item> getVanillaItems() {
        return Collections.singleton(this.getItem());
    }

    @Override
    public ItemStackJS getFirst() {
        return this.copy();
    }

    public int hashCode() {
        return Objects.hash(this.getItem(), this.hasNBT() ? this.getNbt() : Integer.valueOf(0));
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(UtilsJS.getID(o.toString()));
        }
        if (o instanceof ItemStack) {
            ItemStack s = (ItemStack)o;
            return !s.func_190926_b() && this.areItemsEqual(s) && this.isNBTEqual(s);
        }
        ItemStackJS s = ItemStackJS.of(o);
        return !s.isEmpty() && this.areItemsEqual(s) && this.isNBTEqual(s);
    }

    public boolean strongEquals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(UtilsJS.getID(o.toString())) && this.getCount() == 1 && !this.hasNBT();
        }
        if (o instanceof ItemStack) {
            ItemStack s = (ItemStack)o;
            return this.getCount() == s.func_190916_E() && this.areItemsEqual(s) && this.isNBTEqual(s);
        }
        ItemStackJS s = ItemStackJS.of(o);
        return this.getCount() == s.getCount() && this.areItemsEqual(s) && this.isNBTEqual(s);
    }

    public MapJS getEnchantments() {
        MapJS map = new MapJS();
        for (Map.Entry entry : EnchantmentHelper.func_82781_a((ItemStack)this.getItemStack()).entrySet()) {
            ResourceLocation id = KubeJSRegistries.enchantments().getId((Object)((Enchantment)entry.getKey()));
            if (id == null) continue;
            map.put(id.toString(), entry.getValue());
        }
        return map;
    }

    public boolean hasEnchantment(Enchantment enchantment, int level) {
        return EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)this.stack) >= level;
    }

    public ItemStackJS enchant(MapJS enchantments) {
        ItemStackJS is = this;
        for (Map.Entry entry : enchantments.entrySet()) {
            Enchantment enchantment = (Enchantment)KubeJSRegistries.enchantments().get(UtilsJS.getMCID(entry.getKey()));
            if (enchantment == null || !(entry.getValue() instanceof Number)) continue;
            is = is.enchant(enchantment, ((Number)entry.getValue()).intValue());
        }
        return is;
    }

    public ItemStackJS enchant(Enchantment enchantment, int level) {
        ItemStack is = this.stack.func_77946_l();
        if (is.func_77973_b() == Items.field_151134_bR) {
            EnchantedBookItem.func_92115_a((ItemStack)is, (EnchantmentData)new EnchantmentData(enchantment, level));
        } else {
            is.func_77966_a(enchantment, level);
        }
        return new ItemStackJS(is).withChance(this.getChance());
    }

    public String getMod() {
        return Registries.getId((Object)this.getItem(), (RegistryKey)Registry.field_239714_o_).func_110624_b();
    }

    public IngredientJS ignoreNBT() {
        return new IgnoreNBTIngredientJS(this);
    }

    public IngredientJS weakNBT() {
        return new WeakNBTIngredientJS(this);
    }

    public boolean areItemsEqual(ItemStackJS other) {
        return this.getItem() == other.getItem();
    }

    public boolean areItemsEqual(ItemStack other) {
        return this.getItem() == other.func_77973_b();
    }

    public boolean isNBTEqual(ItemStackJS other) {
        if (this.hasNBT() == other.hasNBT()) {
            CompoundNBT nbt = this.stack.func_77978_p();
            CompoundNBT nbt2 = other.getNbt();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    public boolean isNBTEqual(ItemStack other) {
        if (this.hasNBT() == other.func_77942_o()) {
            CompoundNBT nbt = this.stack.func_77978_p();
            CompoundNBT nbt2 = other.func_77978_p();
            return Objects.equals(nbt, nbt2);
        }
        return false;
    }

    public int getHarvestLevel(ToolType tool, @Nullable PlayerJS<?> player, @Nullable BlockContainerJS block) {
        return ItemStackJS._getHarvestLevel(this.getItemStack(), tool, player, block);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static int _getHarvestLevel(ItemStack stack, ToolType tool, @Nullable PlayerJS<?> player, @Nullable BlockContainerJS block) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ItemStackJSImpl._getHarvestLevel(stack, (ToolType)var1_1, var2_2, (BlockContainerJS)var3_3);
    }

    public int getHarvestLevel(ToolType tool) {
        return this.getHarvestLevel(tool, null, null);
    }

    public float getHarvestSpeed(@Nullable BlockContainerJS block) {
        return this.getItemStack().func_150997_a(block == null ? Blocks.field_150350_a.func_176223_P() : block.getBlockState());
    }

    public float getHarvestSpeed() {
        return this.getHarvestSpeed(null);
    }

    @Override
    public JsonElement toJson() {
        int c = this.getCount();
        if (c == 1) {
            return new DummyItemStackJSIngredient(this).toJson();
        }
        return new IngredientStackJS(new DummyItemStackJSIngredient(this), c).toJson();
    }

    public JsonElement toResultJson() {
        JsonElement e;
        if (RecipeJS.currentRecipe != null && (e = RecipeJS.currentRecipe.serializeItemStack(this)) != null) {
            return e;
        }
        return this.toRawResultJson();
    }

    public JsonElement toRawResultJson() {
        JsonObject json = new JsonObject();
        json.addProperty("item", this.getId());
        json.addProperty("count", (Number)this.getCount());
        CompoundNBT nbt = this.getNbt();
        if (nbt != null) {
            if (RecipeJS.currentRecipe != null && RecipeJS.currentRecipe.type != null && RecipeJS.currentRecipe.type.getIdRL().func_110624_b().equals("techreborn")) {
                json.add("nbt", (JsonElement)new CompoundTagWrapper(nbt).toJson());
            } else {
                json.addProperty("nbt", nbt.toString());
            }
        }
        if (this.hasChance()) {
            json.addProperty("chance", (Number)this.getChance());
        }
        return json;
    }

    public CompoundNBT toNBT() {
        return this.getItemStack().func_77955_b(new CompoundNBT());
    }

    public void onChanged(@Nullable INBT o) {
        if (o == null || o instanceof CompoundNBT) {
            this.stack.func_77982_d((CompoundNBT)o);
        }
    }

    public String getItemGroup() {
        if (this.getItem().func_77640_w() == null) {
            return "";
        }
        return this.getItem().func_77640_w().func_200300_c();
    }

    @Override
    public Set<String> getItemIds() {
        return Collections.singleton(this.getId());
    }

    @Nullable
    public FluidStackJS getFluidStack() {
        return null;
    }
}

