/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface ItemHandler
extends Iterable<ItemStack> {
    public int getSlots();

    @NotNull
    public ItemStack getStackInSlot(int var1);

    @NotNull
    public ItemStack insertItem(int var1, @NotNull ItemStack var2, boolean var3);

    @NotNull
    public ItemStack extractItem(int var1, int var2, boolean var3);

    public int getSlotLimit(int var1);

    public boolean isItemValid(int var1, @NotNull ItemStack var2);

    @Override
    @NotNull
    default public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor < ItemHandler.this.getSlots();
            }

            @Override
            public ItemStack next() {
                int i = this.cursor;
                if (i >= ItemHandler.this.getSlots()) {
                    throw new NoSuchElementException();
                }
                this.cursor = i + 1;
                return ItemHandler.this.getStackInSlot(i);
            }
        };
    }

    public static interface Mutable
    extends ItemHandler {
        public void setStackInSlot(int var1, @NotNull ItemStack var2);
    }
}

