/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import dev.latvian.kubejs.item.ContainerInventory;
import dev.latvian.kubejs.item.ItemHandler;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.MatchAllIngredientJS;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.LinkedList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.jetbrains.annotations.Nullable;

public class InventoryJS {
    public final ItemHandler minecraftInventory;

    public InventoryJS(ItemHandler h) {
        this.minecraftInventory = h;
    }

    public InventoryJS(IInventory h) {
        this.minecraftInventory = new ContainerInventory(h);
    }

    public int getSize() {
        return this.minecraftInventory.getSlots();
    }

    public ItemStackJS get(int slot) {
        return ItemStackJS.of(this.minecraftInventory.getStackInSlot(slot));
    }

    public void set(int slot, ItemStack item) {
        if (!(this.minecraftInventory instanceof ItemHandler.Mutable)) {
            throw new IllegalStateException("This inventory can't be modified directly! Use insert/extract methods!");
        }
        ((ItemHandler.Mutable)this.minecraftInventory).setStackInSlot(slot, item);
    }

    public ItemStackJS insert(int slot, ItemStack item, boolean simulate) {
        return ItemStackJS.of(this.minecraftInventory.insertItem(slot, item, simulate));
    }

    public ItemStackJS extract(int slot, int amount, boolean simulate) {
        return ItemStackJS.of(this.minecraftInventory.extractItem(slot, amount, simulate));
    }

    public int getSlotLimit(int slot) {
        return this.minecraftInventory.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, ItemStack item) {
        return this.minecraftInventory.isItemValid(slot, item);
    }

    public void clear() {
        ItemHandler.Mutable modInv = this.minecraftInventory instanceof ItemHandler.Mutable ? (ItemHandler.Mutable)this.minecraftInventory : null;
        for (int i = this.minecraftInventory.getSlots(); i >= 0; --i) {
            if (modInv != null) {
                modInv.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            this.minecraftInventory.extractItem(i, this.minecraftInventory.getStackInSlot(i).func_190916_E(), false);
        }
    }

    public void clear(IngredientJS ingredient) {
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            this.clear();
        }
        ItemHandler.Mutable modInv = this.minecraftInventory instanceof ItemHandler.Mutable ? (ItemHandler.Mutable)this.minecraftInventory : null;
        for (int i = this.minecraftInventory.getSlots(); i >= 0; --i) {
            if (!ingredient.testVanilla(this.minecraftInventory.getStackInSlot(i))) continue;
            if (modInv != null) {
                modInv.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            this.minecraftInventory.extractItem(i, this.minecraftInventory.getStackInSlot(i).func_190916_E(), false);
        }
    }

    public int find() {
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (stack1.func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int find(IngredientJS ingredient) {
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            return this.find();
        }
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (!ingredient.testVanilla(stack1)) continue;
            return i;
        }
        return -1;
    }

    public int count() {
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            count += this.minecraftInventory.getStackInSlot(i).func_190916_E();
        }
        return count;
    }

    public int count(IngredientJS ingredient) {
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            return this.count();
        }
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (!ingredient.testVanilla(stack1)) continue;
            count += stack1.func_190916_E();
        }
        return count;
    }

    public int countNonEmpty() {
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            if (this.minecraftInventory.getStackInSlot(i).func_190926_b()) continue;
            ++count;
        }
        return count;
    }

    public int countNonEmpty(IngredientJS ingredient) {
        if (ingredient == MatchAllIngredientJS.INSTANCE) {
            return this.countNonEmpty();
        }
        int count = 0;
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            ItemStack stack1 = this.minecraftInventory.getStackInSlot(i);
            if (!ingredient.testVanilla(stack1)) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.minecraftInventory.getSlots(); ++i) {
            if (this.minecraftInventory.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < this.getSize(); ++i) {
            list.add(this.get(i).toString());
        }
        return list.toString();
    }

    public void markDirty() {
        if (this.minecraftInventory instanceof ContainerInventory) {
            ((ContainerInventory)this.minecraftInventory).getInv().func_70296_d();
        }
    }

    @Nullable
    public BlockContainerJS getBlock(WorldJS world) {
        IInventory inv;
        if (this.minecraftInventory instanceof ContainerInventory && (inv = ((ContainerInventory)this.minecraftInventory).getInv()) instanceof TileEntity) {
            return world.getBlock((TileEntity)inv);
        }
        return null;
    }
}

