/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.kubejs.item.ItemHandler;
import dev.latvian.kubejs.item.ItemHandlerUtils;
import dev.latvian.kubejs.item.forge.ContainerInventoryImpl;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ContainerInventory
implements ItemHandler.Mutable {
    private final IInventory container;

    public ContainerInventory(IInventory container) {
        this.container = container;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerInventory that = (ContainerInventory)o;
        return this.getInv().equals(that.getInv());
    }

    public int hashCode() {
        return this.getInv().hashCode();
    }

    @Override
    public int getSlots() {
        return this.getInv().func_70302_i_();
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.getInv().func_70301_a(slot);
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getInv().func_70301_a(slot);
        if (!stackInSlot.func_190926_b()) {
            if (stackInSlot.func_190916_E() >= Math.min(stackInSlot.func_77976_d(), this.getSlotLimit(slot))) {
                return stack;
            }
            if (!ItemHandlerUtils.canItemStacksStack(stack, stackInSlot)) {
                return stack;
            }
            if (!this.getInv().func_94041_b(slot, stack)) {
                return stack;
            }
            int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot)) - stackInSlot.func_190916_E();
            if (stack.func_190916_E() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190917_f(stackInSlot.func_190916_E());
                    this.getInv().func_70299_a(slot, copy);
                    this.getInv().func_70296_d();
                }
                return ItemStack.field_190927_a;
            }
            stack = stack.func_77946_l();
            if (!simulate) {
                ItemStack copy = stack.func_77979_a(m);
                copy.func_190917_f(stackInSlot.func_190916_E());
                this.getInv().func_70299_a(slot, copy);
                this.getInv().func_70296_d();
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!this.getInv().func_94041_b(slot, stack)) {
            return stack;
        }
        int m = Math.min(stack.func_77976_d(), this.getSlotLimit(slot));
        if (m < stack.func_190916_E()) {
            stack = stack.func_77946_l();
            if (!simulate) {
                this.getInv().func_70299_a(slot, stack.func_77979_a(m));
                this.getInv().func_70296_d();
                return stack;
            }
            stack.func_190918_g(m);
            return stack;
        }
        if (!simulate) {
            this.getInv().func_70299_a(slot, stack);
            this.getInv().func_70296_d();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        ItemStack stackInSlot = this.getInv().func_70301_a(slot);
        if (stackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (simulate) {
            if (stackInSlot.func_190916_E() < amount) {
                return stackInSlot.func_77946_l();
            }
            ItemStack copy = stackInSlot.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        int m = Math.min(stackInSlot.func_190916_E(), amount);
        ItemStack decrStackSize = this.getInv().func_70298_a(slot, m);
        this.getInv().func_70296_d();
        return decrStackSize;
    }

    @Override
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.getInv().func_70299_a(slot, stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.getInv().func_70297_j_();
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.getInv().func_94041_b(slot, stack);
    }

    public IInventory getInv() {
        return this.container;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean areCapsCompatible(ItemStack a, ItemStack b) {
        void var1_1;
        return ContainerInventoryImpl.areCapsCompatible(a, (ItemStack)var1_1);
    }
}

