/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.fluid;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.fluid.BoundFluidStackJS;
import dev.latvian.kubejs.fluid.EmptyFluidStackJS;
import dev.latvian.kubejs.fluid.UnboundFluidStackJS;
import dev.latvian.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.Tags;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.util.WrappedJS;
import dev.latvian.mods.rhino.mod.util.Copyable;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import java.util.Collection;
import java.util.Objects;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.architectury.registry.Registries;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import org.jetbrains.annotations.Nullable;

public abstract class FluidStackJS
implements WrappedJS,
Copyable {
    public static FluidStackJS of(@Nullable Object o) {
        if (o == null) {
            return EmptyFluidStackJS.INSTANCE;
        }
        if (o instanceof FluidStackJS) {
            return (FluidStackJS)o;
        }
        if (o instanceof FluidStack) {
            return new BoundFluidStackJS((FluidStack)o);
        }
        if (o instanceof Fluid) {
            UnboundFluidStackJS f = new UnboundFluidStackJS(Registries.getId((Object)((Fluid)o), (RegistryKey)Registry.field_239709_j_));
            return f.isEmpty() ? EmptyFluidStackJS.INSTANCE : f;
        }
        if (o instanceof JsonElement) {
            return FluidStackJS.fromJson((JsonElement)o);
        }
        if (o instanceof CharSequence || o instanceof ResourceLocation) {
            String s = o.toString();
            if (s.isEmpty() || s.equals("-") || s.equals("empty") || s.equals("minecraft:empty")) {
                return EmptyFluidStackJS.INSTANCE;
            }
            String[] s1 = s.split(" ", 2);
            return new UnboundFluidStackJS(new ResourceLocation(s1[0])).withAmount(UtilsJS.parseInt(s1.length == 2 ? s1[1] : "", FluidStack.bucketAmount().intValue()));
        }
        MapJS map = MapJS.of(o);
        if (map != null && map.containsKey("fluid")) {
            UnboundFluidStackJS stack = new UnboundFluidStackJS(new ResourceLocation(map.get("fluid").toString()));
            if (map.get("amount") instanceof Number) {
                ((FluidStackJS)stack).setAmount(((Number)map.get("amount")).intValue());
            }
            if (map.containsKey("nbt")) {
                ((FluidStackJS)stack).setNbt(MapJS.nbt(map.get("nbt")));
            }
            return stack;
        }
        return EmptyFluidStackJS.INSTANCE;
    }

    public static FluidStackJS of(@Nullable Object o, int amount, @Nullable CompoundNBT nbt) {
        FluidStackJS stack = FluidStackJS.of(o);
        stack.setAmount(amount);
        stack.setNbt(nbt);
        return stack;
    }

    public static FluidStackJS fromJson(JsonElement e) {
        if (!e.isJsonObject()) {
            return FluidStackJS.of(e.getAsString());
        }
        JsonObject json = e.getAsJsonObject();
        FluidStackJS fluid = FluidStackJS.of(json.get("fluid").getAsString());
        if (fluid.isEmpty()) {
            throw new RecipeExceptionJS(json + " is not a valid fluid!");
        }
        int amount = FluidStack.bucketAmount().intValue();
        CompoundNBT nbt = null;
        if (json.has("amount")) {
            amount = json.get("amount").getAsInt();
        } else if (json.has("count")) {
            amount = json.get("count").getAsInt();
        }
        if (json.has("nbt")) {
            if (json.get("nbt").isJsonObject()) {
                nbt = MapJS.nbt(json.get("nbt"));
            } else {
                try {
                    nbt = JsonToNBT.func_180713_a((String)json.get("nbt").getAsString());
                }
                catch (CommandSyntaxException ex) {
                    return EmptyFluidStackJS.INSTANCE;
                }
            }
        }
        return FluidStackJS.of(fluid, amount, nbt);
    }

    public abstract String getId();

    public Collection<ResourceLocation> getTags() {
        return Tags.byFluid(this.getFluid());
    }

    public boolean hasTag(ResourceLocation tag) {
        return Tags.fluids().func_241834_b(tag).func_230235_a_((Object)this.getFluid());
    }

    public Fluid getFluid() {
        Fluid f = (Fluid)KubeJSRegistries.fluids().get(new ResourceLocation(this.getId()));
        return f == null ? Fluids.field_204541_a : f;
    }

    public abstract FluidStack getFluidStack();

    public boolean isEmpty() {
        return this.getAmount() <= 0;
    }

    public abstract int getAmount();

    public abstract void setAmount(int var1);

    public final FluidStackJS withAmount(int amount) {
        if (amount <= 0) {
            return EmptyFluidStackJS.INSTANCE;
        }
        FluidStackJS fs = this.copy();
        fs.setAmount(amount);
        return fs;
    }

    @Deprecated
    public final FluidStackJS amount(int amount) {
        return this.withAmount(amount);
    }

    @Nullable
    public abstract CompoundNBT getNbt();

    public abstract void setNbt(@Nullable CompoundNBT var1);

    public final FluidStackJS withNBT(@Nullable CompoundNBT nbt) {
        FluidStackJS fs = this.copy();
        fs.setNbt(nbt);
        return fs;
    }

    @Deprecated
    public final FluidStackJS nbt(@Nullable CompoundNBT nbt) {
        return this.withNBT(nbt);
    }

    public abstract FluidStackJS copy();

    public int hashCode() {
        return Objects.hash(this.getFluid(), this.getNbt());
    }

    public boolean equals(Object o) {
        if (o instanceof CharSequence) {
            return this.getId().equals(o.toString());
        }
        FluidStackJS f = FluidStackJS.of(o);
        if (f.isEmpty()) {
            return false;
        }
        return this.getFluid() == f.getFluid() && Objects.equals(this.getNbt(), f.getNbt());
    }

    public boolean strongEquals(Object o) {
        FluidStackJS f = FluidStackJS.of(o);
        if (f.isEmpty()) {
            return false;
        }
        return this.getAmount() == f.getAmount() && this.getFluid() == f.getFluid() && Objects.equals(this.getNbt(), f.getNbt());
    }

    public String toString() {
        int amount = this.getAmount();
        CompoundNBT nbt = this.getNbt();
        StringBuilder builder = new StringBuilder();
        builder.append("Fluid.of('");
        builder.append(this.getId());
        if (amount != FluidStack.bucketAmount().intValue()) {
            builder.append(", ");
            builder.append(amount);
        }
        if (nbt != null) {
            builder.append(", ");
            NBTUtils.quoteAndEscapeForJS((StringBuilder)builder, (String)nbt.toString());
        }
        builder.append("')");
        return builder.toString();
    }

    public JsonObject toJson() {
        JsonObject o = new JsonObject();
        o.addProperty("fluid", this.getId());
        if (this.getAmount() != FluidStack.bucketAmount().intValue()) {
            o.addProperty("amount", (Number)this.getAmount());
        }
        if (this.getNbt() != null) {
            o.add("nbt", (JsonElement)MapJS.json(this.getNbt()));
        }
        return o;
    }

    public CompoundNBT toNBT() {
        CompoundNBT tag = new CompoundNBT();
        this.getFluidStack().write(tag);
        return tag;
    }
}

