/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.entity;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.kubejs.entity.DamageSourceJS;
import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.entity.EntityPotionEffectsJS;
import dev.latvian.kubejs.entity.RayTraceResultJS;
import dev.latvian.kubejs.entity.forge.LivingEntityJSImpl;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.world.WorldJS;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import org.jetbrains.annotations.Nullable;

public class LivingEntityJS
extends EntityJS {
    public final LivingEntity minecraftLivingEntity;

    public LivingEntityJS(WorldJS w, LivingEntity e) {
        super(w, (Entity)e);
        this.minecraftLivingEntity = e;
    }

    @Override
    public boolean isLiving() {
        return true;
    }

    public boolean isChild() {
        return this.minecraftLivingEntity.func_70631_g_();
    }

    public float getHealth() {
        return this.minecraftLivingEntity.func_110143_aJ();
    }

    public void setHealth(float hp) {
        this.minecraftLivingEntity.func_70606_j(hp);
    }

    public void heal(float hp) {
        this.minecraftLivingEntity.func_70691_i(hp);
    }

    public float getMaxHealth() {
        return this.minecraftLivingEntity.func_110138_aP();
    }

    public void setMaxHealth(float hp) {
        this.minecraftLivingEntity.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)hp);
    }

    public boolean isUndead() {
        return this.minecraftLivingEntity.func_70662_br();
    }

    public boolean isOnLadder() {
        return this.minecraftLivingEntity.func_70617_f_();
    }

    public boolean isSleeping() {
        return this.minecraftLivingEntity.func_70608_bn();
    }

    public boolean isElytraFlying() {
        return this.minecraftLivingEntity.func_184613_cA();
    }

    @Nullable
    public LivingEntityJS getRevengeTarget() {
        return this.getWorld().getLivingEntity((Entity)this.minecraftLivingEntity.func_70643_av());
    }

    public int getRevengeTimer() {
        return this.minecraftLivingEntity.func_142015_aE();
    }

    public void setRevengeTarget(@Nullable LivingEntityJS target) {
        this.minecraftLivingEntity.func_70604_c(target == null ? null : target.minecraftLivingEntity);
    }

    @Nullable
    public LivingEntityJS getLastAttackedEntity() {
        return this.getWorld().getLivingEntity((Entity)this.minecraftLivingEntity.func_110144_aD());
    }

    public int getLastAttackedEntityTime() {
        return this.minecraftLivingEntity.func_142013_aG();
    }

    public int getIdleTime() {
        return this.minecraftLivingEntity.func_70654_ax();
    }

    public EntityPotionEffectsJS getPotionEffects() {
        return new EntityPotionEffectsJS(this.minecraftLivingEntity);
    }

    @Nullable
    public DamageSourceJS getLastDamageSource() {
        return this.minecraftLivingEntity.func_189748_bU() == null ? null : new DamageSourceJS(this.getWorld(), this.minecraftLivingEntity.func_189748_bU());
    }

    @Nullable
    public LivingEntityJS getAttackingEntity() {
        return this.getWorld().getLivingEntity((Entity)this.minecraftLivingEntity.func_94060_bK());
    }

    public void swingArm(Hand hand) {
        this.minecraftLivingEntity.func_184609_a(hand);
    }

    public ItemStackJS getEquipment(EquipmentSlotType slot) {
        return ItemStackJS.of(this.minecraftLivingEntity.func_184582_a(slot));
    }

    public void setEquipment(EquipmentSlotType slot, ItemStackJS item) {
        this.minecraftLivingEntity.func_184201_a(slot, item.getItemStack());
    }

    public ItemStackJS getHeldItem(Hand hand) {
        return ItemStackJS.of(this.minecraftLivingEntity.func_184586_b(hand));
    }

    public void setHeldItem(Hand hand, ItemStackJS item) {
        this.minecraftLivingEntity.func_184611_a(hand, item.getItemStack());
    }

    public ItemStackJS getMainHandItem() {
        return this.getEquipment(EquipmentSlotType.MAINHAND);
    }

    public void setMainHandItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlotType.MAINHAND, item);
    }

    public ItemStackJS getOffHandItem() {
        return this.getEquipment(EquipmentSlotType.OFFHAND);
    }

    public void setOffHandItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlotType.OFFHAND, item);
    }

    public ItemStackJS getHeadArmorItem() {
        return this.getEquipment(EquipmentSlotType.HEAD);
    }

    public void setHeadArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlotType.HEAD, item);
    }

    public ItemStackJS getChestArmorItem() {
        return this.getEquipment(EquipmentSlotType.CHEST);
    }

    public void setChestArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlotType.CHEST, item);
    }

    public ItemStackJS getLegsArmorItem() {
        return this.getEquipment(EquipmentSlotType.LEGS);
    }

    public void setLegsArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlotType.LEGS, item);
    }

    public ItemStackJS getFeetArmorItem() {
        return this.getEquipment(EquipmentSlotType.FEET);
    }

    public void setFeetArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlotType.FEET, item);
    }

    public void damageEquipment(EquipmentSlotType slot, int amount, Consumer<ItemStackJS> onBroken) {
        ItemStack stack = this.minecraftLivingEntity.func_184582_a(slot);
        if (!stack.func_190926_b()) {
            stack.func_222118_a(amount, this.minecraftLivingEntity, livingEntity -> onBroken.accept(ItemStackJS.of(stack)));
            if (stack.func_190926_b()) {
                this.minecraftLivingEntity.func_184201_a(slot, ItemStack.field_190927_a);
            }
        }
    }

    public void damageEquipment(EquipmentSlotType slot, int amount) {
        this.damageEquipment(slot, amount, stack -> {});
    }

    public void damageEquipment(EquipmentSlotType slot) {
        this.damageEquipment(slot, 1);
    }

    public void damageHeldItem(Hand hand, int amount, Consumer<ItemStackJS> onBroken) {
        this.damageEquipment(hand == Hand.MAIN_HAND ? EquipmentSlotType.MAINHAND : EquipmentSlotType.OFFHAND, amount, onBroken);
    }

    public void damageHeldItem(Hand hand, int amount) {
        this.damageHeldItem(hand, amount, stack -> {});
    }

    public void damageHeldItem() {
        this.damageHeldItem(Hand.MAIN_HAND, 1);
    }

    public boolean isHoldingInAnyHand(Object ingredient) {
        IngredientJS i = IngredientJS.of(ingredient);
        return i.testVanilla(this.minecraftLivingEntity.func_184586_b(Hand.MAIN_HAND)) || i.testVanilla(this.minecraftLivingEntity.func_184586_b(Hand.OFF_HAND));
    }

    public float getMovementSpeed() {
        return this.minecraftLivingEntity.func_70689_ay();
    }

    public void setMovementSpeed(float speed) {
        this.minecraftLivingEntity.func_70659_e(speed);
    }

    public boolean canEntityBeSeen(EntityJS entity) {
        return this.minecraftLivingEntity.func_70685_l(entity.minecraftEntity);
    }

    public float getAbsorptionAmount() {
        return this.minecraftLivingEntity.func_110139_bj();
    }

    public void setAbsorptionAmount(float amount) {
        this.minecraftLivingEntity.func_110149_m(amount);
    }

    public double getReachDistance() {
        return LivingEntityJS.getReachDistance(this.minecraftLivingEntity);
    }

    public RayTraceResultJS rayTrace() {
        return this.rayTrace(this.getReachDistance());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static double getReachDistance(LivingEntity livingEntity) {
        return LivingEntityJSImpl.getReachDistance(livingEntity);
    }
}

