/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block.predicate;

import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.block.predicate.BlockPredicate;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.world.BlockContainerJS;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.state.Property;
import net.minecraft.util.ResourceLocation;

public class BlockIDPredicate
implements BlockPredicate {
    private final ResourceLocation id;
    private Map<String, String> properties;
    private Block cachedBlock;
    private List<PropertyObject> cachedProperties;

    public BlockIDPredicate(ResourceLocation i) {
        this.id = i;
    }

    public String toString() {
        if (this.properties == null || this.properties.isEmpty()) {
            return this.id.toString();
        }
        StringBuilder sb = new StringBuilder(this.id.toString());
        sb.append('[');
        boolean first = true;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        sb.append(']');
        return sb.toString();
    }

    public BlockIDPredicate with(String key, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, value);
        this.cachedBlock = null;
        this.cachedProperties = null;
        return this;
    }

    private Block getBlock() {
        if (this.cachedBlock == null) {
            this.cachedBlock = (Block)KubeJSRegistries.blocks().get(this.id);
            if (this.cachedBlock == null) {
                this.cachedBlock = Blocks.field_150350_a;
            }
        }
        return this.cachedBlock;
    }

    public List<PropertyObject> getBlockProperties() {
        if (this.cachedProperties == null) {
            this.cachedProperties = new LinkedList<PropertyObject>();
            HashMap<String, Property> map = new HashMap<String, Property>();
            for (Property property : this.getBlock().func_176223_P().func_235904_r_()) {
                map.put(property.func_177701_a(), property);
            }
            for (Map.Entry entry : this.properties.entrySet()) {
                Optional o;
                Property property = (Property)map.get(entry.getKey());
                if (property == null || !(o = property.func_185929_b((String)entry.getValue())).isPresent()) continue;
                PropertyObject po = new PropertyObject();
                po.property = property;
                po.value = o.get();
                this.cachedProperties.add(po);
            }
        }
        return this.cachedProperties;
    }

    public BlockState getBlockState() {
        BlockState state = this.getBlock().func_176223_P();
        for (PropertyObject object : this.getBlockProperties()) {
            state = (BlockState)state.func_206870_a(object.property, (Comparable)UtilsJS.cast(object.value));
        }
        return state;
    }

    @Override
    public boolean check(BlockContainerJS b) {
        return this.getBlock() != Blocks.field_150350_a && this.checkState(b.getBlockState());
    }

    public boolean checkState(BlockState state) {
        if (state.func_177230_c() != this.getBlock()) {
            return false;
        }
        if (this.properties == null || this.properties.isEmpty()) {
            return true;
        }
        for (PropertyObject object : this.getBlockProperties()) {
            if (state.func_177229_b(object.property).equals(object.value)) continue;
            return false;
        }
        return true;
    }

    private static class PropertyObject {
        private Property<?> property;
        private Object value;

        private PropertyObject() {
        }
    }
}

