/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.block;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.latvian.kubejs.KubeJSObjects;
import dev.latvian.kubejs.KubeJSRegistries;
import dev.latvian.kubejs.block.BlockBreakEventJS;
import dev.latvian.kubejs.block.BlockBuilder;
import dev.latvian.kubejs.block.BlockLeftClickEventJS;
import dev.latvian.kubejs.block.BlockPlaceEventJS;
import dev.latvian.kubejs.block.BlockRightClickEventJS;
import dev.latvian.kubejs.block.DetectorBlock;
import dev.latvian.kubejs.block.DetectorInstance;
import dev.latvian.kubejs.block.forge.KubeJSBlockEventHandlerImpl;
import dev.latvian.kubejs.core.BlockKJS;
import dev.latvian.kubejs.fluid.FluidBuilder;
import java.util.Iterator;
import me.shedaniel.architectury.event.events.BlockEvent;
import me.shedaniel.architectury.event.events.InteractionEvent;
import me.shedaniel.architectury.utils.IntValue;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class KubeJSBlockEventHandler {
    public static void init() {
        KubeJSBlockEventHandler.registry();
        InteractionEvent.RIGHT_CLICK_BLOCK.register(KubeJSBlockEventHandler::rightClick);
        InteractionEvent.LEFT_CLICK_BLOCK.register(KubeJSBlockEventHandler::leftClick);
        BlockEvent.BREAK.register(KubeJSBlockEventHandler::blockBreak);
        BlockEvent.PLACE.register(KubeJSBlockEventHandler::blockPlace);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static FlowingFluidBlock buildFluidBlock(FluidBuilder builder, AbstractBlock.Properties properties) {
        void var1_1;
        return KubeJSBlockEventHandlerImpl.buildFluidBlock(builder, (AbstractBlock.Properties)var1_1);
    }

    private static void registry() {
        Iterator<Object> iterator = KubeJSObjects.BLOCKS.values().iterator();
        while (iterator.hasNext()) {
            BlockBuilder blockBuilder;
            BlockBuilder.current = blockBuilder = iterator.next();
            blockBuilder.block = blockBuilder.type.createBlock(blockBuilder);
            if (blockBuilder.block instanceof BlockKJS) {
                ((BlockKJS)blockBuilder.block).setBlockBuilderKJS(blockBuilder);
            }
            KubeJSRegistries.blocks().register(blockBuilder.id, () -> builder.block);
        }
        BlockBuilder.current = null;
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            fluidBuilder.block = KubeJSBlockEventHandler.buildFluidBlock(fluidBuilder, AbstractBlock.Properties.func_200945_a((Material)Material.field_151586_h).func_200942_a().func_200943_b(100.0f).func_222380_e());
            KubeJSRegistries.blocks().register(fluidBuilder.id, () -> builder.block);
        }
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            detectorInstance.block = KubeJSRegistries.blocks().register(new ResourceLocation("kubejs", "detector_" + detectorInstance.id), () -> new DetectorBlock(detector.id));
        }
    }

    private static ActionResultType rightClick(PlayerEntity player, Hand hand, BlockPos pos, Direction direction) {
        if (player != null && player.field_70170_p != null && !player.func_184811_cZ().func_185141_a(player.func_184586_b(hand).func_77973_b()) && new BlockRightClickEventJS(player, hand, pos, direction).post("block.right_click")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType leftClick(PlayerEntity player, Hand hand, BlockPos pos, Direction direction) {
        if (player != null && player.field_70170_p != null && new BlockLeftClickEventJS(player, hand, pos, direction).post("block.left_click")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType blockBreak(World world, BlockPos pos, BlockState state, ServerPlayerEntity player, @Nullable IntValue xp) {
        if (player != null && player.field_70170_p != null && new BlockBreakEventJS(player, world, pos, state, xp).post("block.break")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    private static ActionResultType blockPlace(World world, BlockPos pos, BlockState state, @Nullable Entity placer) {
        if (world != null && (placer == null || placer.field_70170_p != null) && new BlockPlaceEventJS(placer, world, pos, state).post("block.place")) {
            return ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }
}

