/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.KubeJSObjects;
import dev.latvian.kubejs.KubeJSPlugin;
import dev.latvian.kubejs.bindings.BlockWrapper;
import dev.latvian.kubejs.bindings.IngredientWrapper;
import dev.latvian.kubejs.bindings.ItemWrapper;
import dev.latvian.kubejs.bindings.JsonIOWrapper;
import dev.latvian.kubejs.bindings.JsonWrapper;
import dev.latvian.kubejs.bindings.NBTIOWrapper;
import dev.latvian.kubejs.bindings.RarityWrapper;
import dev.latvian.kubejs.bindings.ScriptEventsWrapper;
import dev.latvian.kubejs.bindings.TextWrapper;
import dev.latvian.kubejs.bindings.UtilsWrapper;
import dev.latvian.kubejs.block.BlockBuilder;
import dev.latvian.kubejs.block.BlockRegistryEventJS;
import dev.latvian.kubejs.block.BlockStatePredicate;
import dev.latvian.kubejs.block.DetectorInstance;
import dev.latvian.kubejs.block.MaterialJS;
import dev.latvian.kubejs.block.MaterialListJS;
import dev.latvian.kubejs.block.custom.BasicBlockType;
import dev.latvian.kubejs.block.custom.BlockType;
import dev.latvian.kubejs.block.custom.BlockTypes;
import dev.latvian.kubejs.block.custom.ShapedBlockType;
import dev.latvian.kubejs.client.painter.Painter;
import dev.latvian.kubejs.client.painter.screen.AtlasTextureObject;
import dev.latvian.kubejs.client.painter.screen.GradientObject;
import dev.latvian.kubejs.client.painter.screen.RectangleObject;
import dev.latvian.kubejs.client.painter.screen.ScreenGroup;
import dev.latvian.kubejs.client.painter.screen.TextObject;
import dev.latvian.kubejs.entity.EntityJS;
import dev.latvian.kubejs.event.IEventHandler;
import dev.latvian.kubejs.fluid.FluidBuilder;
import dev.latvian.kubejs.fluid.FluidRegistryEventJS;
import dev.latvian.kubejs.fluid.FluidStackJS;
import dev.latvian.kubejs.fluid.FluidWrapper;
import dev.latvian.kubejs.generator.AssetJsonGenerator;
import dev.latvian.kubejs.generator.DataJsonGenerator;
import dev.latvian.kubejs.item.ItemBuilder;
import dev.latvian.kubejs.item.ItemRegistryEventJS;
import dev.latvian.kubejs.item.ItemStackJS;
import dev.latvian.kubejs.item.custom.ArmorItemType;
import dev.latvian.kubejs.item.custom.BasicItemType;
import dev.latvian.kubejs.item.custom.ItemArmorTierEventJS;
import dev.latvian.kubejs.item.custom.ItemToolTierEventJS;
import dev.latvian.kubejs.item.custom.ItemType;
import dev.latvian.kubejs.item.custom.ItemTypes;
import dev.latvian.kubejs.item.custom.ToolItemType;
import dev.latvian.kubejs.item.ingredient.IngredientJS;
import dev.latvian.kubejs.item.ingredient.IngredientStackJS;
import dev.latvian.kubejs.loot.LootBuilder;
import dev.latvian.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.kubejs.recipe.minecraft.CookingRecipeJS;
import dev.latvian.kubejs.recipe.minecraft.SmithingRecipeJS;
import dev.latvian.kubejs.recipe.minecraft.StonecuttingRecipeJS;
import dev.latvian.kubejs.recipe.mod.AE2GrinderRecipeJS;
import dev.latvian.kubejs.recipe.mod.BotaniaRunicAltarRecipeJS;
import dev.latvian.kubejs.recipe.mod.BotanyPotsCropRecipeJS;
import dev.latvian.kubejs.recipe.mod.IDSqueezerRecipeJS;
import dev.latvian.kubejs.recipe.mod.MATagRecipeJS;
import dev.latvian.kubejs.recipe.mod.ShapedArtisanRecipeJS;
import dev.latvian.kubejs.recipe.mod.ShapelessArtisanRecipeJS;
import dev.latvian.kubejs.script.BindingsEvent;
import dev.latvian.kubejs.script.PlatformWrapper;
import dev.latvian.kubejs.script.ScriptType;
import dev.latvian.kubejs.server.ServerSettings;
import dev.latvian.kubejs.text.Text;
import dev.latvian.kubejs.util.BuilderBase;
import dev.latvian.kubejs.util.ClassFilter;
import dev.latvian.kubejs.util.KubeJSPlugins;
import dev.latvian.kubejs.util.ListJS;
import dev.latvian.kubejs.util.MapJS;
import dev.latvian.kubejs.util.UtilsJS;
import dev.latvian.kubejs.world.BlockContainerJS;
import dev.latvian.mods.rhino.mod.util.NBTWrapper;
import dev.latvian.mods.rhino.mod.wrapper.AABBWrapper;
import dev.latvian.mods.rhino.mod.wrapper.ColorWrapper;
import dev.latvian.mods.rhino.mod.wrapper.DirectionWrapper;
import dev.latvian.mods.rhino.mod.wrapper.UUIDWrapper;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Pattern;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.ToolType;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityClassification;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.functions.CopyName;
import net.minecraft.nbt.CollectionNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.gen.GenerationStage;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BuiltinKubeJSPlugin
extends KubeJSPlugin {
    public static final HashMap<String, Object> GLOBAL = new HashMap();

    @Override
    public void init() {
        BlockTypes.register(BasicBlockType.INSTANCE);
        BlockTypes.register(ShapedBlockType.SLAB);
        BlockTypes.register(ShapedBlockType.STAIRS);
        BlockTypes.register(ShapedBlockType.FENCE);
        BlockTypes.register(ShapedBlockType.FENCE_GATE);
        BlockTypes.register(ShapedBlockType.WALL);
        BlockTypes.register(ShapedBlockType.WOODEN_PRESSURE_PLATE);
        BlockTypes.register(ShapedBlockType.STONE_PRESSURE_PLATE);
        BlockTypes.register(ShapedBlockType.WOODEN_BUTTON);
        BlockTypes.register(ShapedBlockType.STONE_BUTTON);
        ItemTypes.register(BasicItemType.INSTANCE);
        ItemTypes.register(ToolItemType.SWORD);
        ItemTypes.register(ToolItemType.PICKAXE);
        ItemTypes.register(ToolItemType.AXE);
        ItemTypes.register(ToolItemType.SHOVEL);
        ItemTypes.register(ToolItemType.HOE);
        ItemTypes.register(ArmorItemType.HELMET);
        ItemTypes.register(ArmorItemType.CHESTPLATE);
        ItemTypes.register(ArmorItemType.LEGGINGS);
        ItemTypes.register(ArmorItemType.BOOTS);
    }

    @Override
    public void initStartup() {
        new ItemToolTierEventJS().post("item.registry.tool_tiers");
        new ItemArmorTierEventJS().post("item.registry.armor_tiers");
        new BlockRegistryEventJS().post("block.registry");
        new ItemRegistryEventJS().post("item.registry");
        new FluidRegistryEventJS().post("fluid.registry");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientInit() {
        Painter.INSTANCE.registerObject("screen_group", ScreenGroup::new);
        Painter.INSTANCE.registerObject("rectangle", RectangleObject::new);
        Painter.INSTANCE.registerObject("text", TextObject::new);
        Painter.INSTANCE.registerObject("atlas_texture", AtlasTextureObject::new);
        Painter.INSTANCE.registerObject("gradient", GradientObject::new);
    }

    @Override
    public void addClasses(ScriptType type, ClassFilter filter) {
        filter.allow("java.lang.Number");
        filter.allow("java.lang.String");
        filter.allow("java.lang.Character");
        filter.allow("java.lang.Byte");
        filter.allow("java.lang.Short");
        filter.allow("java.lang.Integer");
        filter.allow("java.lang.Long");
        filter.allow("java.lang.Float");
        filter.allow("java.lang.Double");
        filter.allow("java.lang.Boolean");
        filter.allow("java.lang.Runnable");
        filter.allow("java.lang.Iterable");
        filter.allow("java.lang.Comparable");
        filter.allow("java.lang.CharSequence");
        filter.allow("java.math.BigInteger");
        filter.allow("java.math.BigDecimal");
        filter.deny("java.io");
        filter.allow("java.io.Closeable");
        filter.allow("java.io.Serializable");
        filter.deny("java.nio");
        filter.allow("java.nio.ByteOrder");
        filter.allow("java.util");
        filter.deny("java.util.jar");
        filter.deny("java.util.zip");
        filter.allow("it.unimi.dsi.fastutil");
        filter.allow("dev.latvian.kubejs");
        filter.deny("dev.latvian.kubejs.script");
        filter.deny("dev.latvian.kubejs.mixin");
        filter.deny(KubeJSPlugin.class);
        filter.deny(KubeJSPlugins.class);
        filter.allow("net.minecraft");
        filter.allow("com.mojang.authlib.GameProfile");
        filter.allow("com.mojang.util.UUIDTypeAdapter");
        filter.allow("com.mojang.brigadier");
        filter.allow("me.shedaniel.architectury");
        filter.deny("java.net");
        filter.deny("sun");
        filter.deny("com.sun");
        filter.deny("io.netty");
        filter.deny("org.objectweb.asm");
        filter.deny("org.spongepowered.asm");
        filter.deny("org.openjdk.nashorn");
        filter.deny("jdk.nashorn");
        filter.allow("mezz.jei");
    }

    @Override
    public void addBindings(BindingsEvent event) {
        event.add("global", GLOBAL);
        if (event.type == ScriptType.SERVER) {
            ServerSettings.instance = new ServerSettings();
            event.add("settings", ServerSettings.instance);
        }
        event.add("Platform", PlatformWrapper.class);
        event.add("console", event.type.console);
        event.add("events", new ScriptEventsWrapper(event.type.manager.get().events));
        event.addFunction("onEvent", args -> BuiltinKubeJSPlugin.onEvent(event, args), null, IEventHandler.class);
        event.addFunction("java", args -> event.manager.loadJavaClass(event.scope, args), new Class[]{null});
        event.add("JavaMath", Math.class);
        event.add("ResourceLocation", ResourceLocation.class);
        event.add("Utils", UtilsWrapper.class);
        event.add("utils", UtilsWrapper.class);
        event.add("Text", TextWrapper.class);
        event.add("text", TextWrapper.class);
        event.add("UUID", UUIDWrapper.class);
        event.add("uuid", UUIDWrapper.class);
        event.add("JsonUtils", JsonWrapper.class);
        event.add("JsonIO", JsonIOWrapper.class);
        event.add("Block", BlockWrapper.class);
        event.add("block", BlockWrapper.class);
        event.add("Item", ItemWrapper.class);
        event.add("item", ItemWrapper.class);
        event.add("Ingredient", IngredientWrapper.class);
        event.add("ingredient", IngredientWrapper.class);
        event.add("NBT", NBTWrapper.class);
        event.add("NBTIO", NBTIOWrapper.class);
        event.add("Direction", DirectionWrapper.class);
        event.add("Facing", DirectionWrapper.class);
        event.add("AABB", AABBWrapper.class);
        event.add("Fluid", FluidWrapper.class);
        event.add("fluid", FluidWrapper.class);
        event.add("SECOND", 1000L);
        event.add("MINUTE", 60000L);
        event.add("HOUR", 3600000L);
        event.add("Color", ColorWrapper.class);
        event.add("EquipmentSlot", EquipmentSlotType.class);
        event.add("SLOT_MAINHAND", EquipmentSlotType.MAINHAND);
        event.add("SLOT_OFFHAND", EquipmentSlotType.OFFHAND);
        event.add("SLOT_FEET", EquipmentSlotType.FEET);
        event.add("SLOT_LEGS", EquipmentSlotType.LEGS);
        event.add("SLOT_CHEST", EquipmentSlotType.CHEST);
        event.add("SLOT_HEAD", EquipmentSlotType.HEAD);
        event.add("Rarity", RarityWrapper.class);
        event.add("RARITY_COMMON", RarityWrapper.COMMON);
        event.add("RARITY_UNCOMMON", RarityWrapper.UNCOMMON);
        event.add("RARITY_RARE", RarityWrapper.RARE);
        event.add("RARITY_EPIC", RarityWrapper.EPIC);
        event.add("AIR_ITEM", Items.field_190931_a);
        event.add("AIR_BLOCK", Blocks.field_150350_a);
        event.add("ToolType", ToolType.class);
        event.add("TOOL_TYPE_AXE", ToolType.AXE);
        event.add("TOOL_TYPE_PICKAXE", ToolType.PICKAXE);
        event.add("TOOL_TYPE_SHOVEL", ToolType.SHOVEL);
        event.add("TOOL_TYPE_HOE", ToolType.HOE);
        event.add("Hand", Hand.class);
        event.add("MAIN_HAND", Hand.MAIN_HAND);
        event.add("OFF_HAND", Hand.OFF_HAND);
        event.add("DecorationGenerationStep", GenerationStage.Decoration.class);
        event.add("CarvingGenerationStep", GenerationStage.Carving.class);
        event.add("Vec3", Vector3d.class);
        event.add("Vec3d", Vector3d.class);
        event.add("Vec3i", Vector3i.class);
        event.add("BlockPos", BlockPos.class);
        KubeJS.PROXY.clientBindings(event);
    }

    private static Object onEvent(BindingsEvent event, Object[] args) {
        for (Object o : ListJS.orSelf(args[0])) {
            event.type.manager.get().events.listen(String.valueOf(o), (IEventHandler)args[1]);
        }
        return null;
    }

    @Override
    public void addTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        typeWrappers.register(String.class, String::valueOf);
        typeWrappers.register(CharSequence.class, String::valueOf);
        typeWrappers.register(UUID.class, UUIDWrapper::fromString);
        typeWrappers.register(Pattern.class, UtilsJS::parseRegex);
        typeWrappers.register(JsonObject.class, MapJS::json);
        typeWrappers.register(JsonArray.class, ListJS::json);
        typeWrappers.register(ResourceLocation.class, UtilsJS::getMCID);
        typeWrappers.register(ItemStack.class, o -> ItemStackJS.of(o).getItemStack());
        typeWrappers.register(CompoundNBT.class, MapJS::isNbt, MapJS::nbt);
        typeWrappers.register(CollectionNBT.class, ListJS::nbt);
        typeWrappers.register(ListNBT.class, o -> (ListNBT)ListJS.nbt(o));
        typeWrappers.register(ITextComponent.class, Text::componentOf);
        typeWrappers.register(IFormattableTextComponent.class, o -> new StringTextComponent("").func_230529_a_(Text.componentOf(o)));
        typeWrappers.register(BlockPos.class, o -> {
            if (o instanceof BlockPos) {
                return (BlockPos)o;
            }
            if (o instanceof BlockContainerJS) {
                return ((BlockContainerJS)o).getPos();
            }
            if (o instanceof List && ((List)o).size() >= 3) {
                return new BlockPos(((Number)((List)o).get(0)).intValue(), ((Number)((List)o).get(1)).intValue(), ((Number)((List)o).get(2)).intValue());
            }
            return BlockPos.field_177992_a;
        });
        typeWrappers.register(Vector3d.class, o -> {
            if (o instanceof Vector3d) {
                return (Vector3d)o;
            }
            if (o instanceof EntityJS) {
                return ((EntityJS)o).minecraftEntity.func_213303_ch();
            }
            if (o instanceof List && ((List)o).size() >= 3) {
                return new Vector3d(((Number)((List)o).get(0)).doubleValue(), ((Number)((List)o).get(1)).doubleValue(), ((Number)((List)o).get(2)).doubleValue());
            }
            if (o instanceof BlockPos) {
                BlockPos bp = (BlockPos)o;
                return new Vector3d((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5);
            }
            if (o instanceof BlockContainerJS) {
                BlockPos bp = ((BlockContainerJS)o).getPos();
                return new Vector3d((double)bp.func_177958_n() + 0.5, (double)bp.func_177956_o() + 0.5, (double)bp.func_177952_p() + 0.5);
            }
            return Vector3d.field_186680_a;
        });
        typeWrappers.register(Item.class, ItemStackJS::getRawItem);
        typeWrappers.register(GenerationStage.Decoration.class, o -> o == null || o.toString().isEmpty() ? null : GenerationStage.Decoration.valueOf((String)o.toString().toUpperCase()));
        typeWrappers.register(EntityClassification.class, o -> o == null ? null : EntityClassification.func_233670_a_((String)o.toString()));
        typeWrappers.register(Color.class, o -> {
            if (o instanceof Number) {
                return Color.func_240743_a_((int)(((Number)o).intValue() & 0xFFFFFF));
            }
            if (o instanceof TextFormatting) {
                return Color.func_240744_a_((TextFormatting)((TextFormatting)o));
            }
            return Color.func_240745_a_((String)o.toString());
        });
        typeWrappers.register(AxisAlignedBB.class, AABBWrapper::wrap);
        typeWrappers.register(Direction.class, o -> o instanceof Direction ? (Direction)o : (Direction)DirectionWrapper.ALL.get(o.toString().toLowerCase()));
        typeWrappers.register(IRandomRange.class, UtilsJS::randomIntGeneratorOf);
        typeWrappers.register(LootContext.EntityTarget.class, o -> o == null ? null : LootContext.EntityTarget.func_186482_a((String)o.toString().toLowerCase()));
        typeWrappers.register(CopyName.Source.class, o -> o == null ? null : CopyName.Source.func_216235_a((String)o.toString().toLowerCase()));
        typeWrappers.register(MapJS.class, MapJS::of);
        typeWrappers.register(ListJS.class, ListJS::of);
        typeWrappers.register(ItemStackJS.class, ItemStackJS::of);
        typeWrappers.register(IngredientJS.class, IngredientJS::of);
        typeWrappers.register(IngredientStackJS.class, o -> IngredientJS.of(o).asIngredientStack());
        typeWrappers.register(Text.class, Text::of);
        typeWrappers.register(BlockStatePredicate.class, BlockStatePredicate::of);
        typeWrappers.register(FluidStackJS.class, FluidStackJS::of);
        typeWrappers.register(RecipeFilter.class, RecipeFilter::of);
        typeWrappers.register(MaterialJS.class, MaterialListJS.INSTANCE::of);
        typeWrappers.register(ItemType.class, ItemTypes::get);
        typeWrappers.register(BlockType.class, BlockTypes::get);
        typeWrappers.register(dev.latvian.mods.rhino.mod.util.color.Color.class, ColorWrapper::of);
        KubeJS.PROXY.clientTypeWrappers(typeWrappers);
    }

    @Override
    public void addRecipes(RegisterRecipeHandlersEvent event) {
        event.registerShaped(new ResourceLocation("minecraft:crafting_shaped"));
        event.registerShapeless(new ResourceLocation("minecraft:crafting_shapeless"));
        event.register(new ResourceLocation("minecraft:stonecutting"), StonecuttingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:smelting"), CookingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:blasting"), CookingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:smoking"), CookingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:campfire_cooking"), CookingRecipeJS::new);
        event.register(new ResourceLocation("minecraft:smithing"), SmithingRecipeJS::new);
        if (Platform.isModLoaded((String)"cucumber")) {
            event.registerShaped(new ResourceLocation("cucumber:shaped_no_mirror"));
        }
        if (Platform.isModLoaded((String)"mysticalagriculture")) {
            event.register(new ResourceLocation("mysticalagriculture:tag"), MATagRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"botanypots")) {
            event.register(new ResourceLocation("botanypots:crop"), BotanyPotsCropRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"extendedcrafting")) {
            event.registerShaped(new ResourceLocation("extendedcrafting:shaped_table"));
            event.registerShapeless(new ResourceLocation("extendedcrafting:shapeless_table"));
        }
        if (Platform.isModLoaded((String)"dankstorage")) {
            event.registerShaped(new ResourceLocation("dankstorage:upgrade"));
        }
        if (Platform.isModLoaded((String)"appliedenergistics2")) {
            event.register(new ResourceLocation("appliedenergistics2:grinder"), AE2GrinderRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"artisanworktables")) {
            String[] types;
            for (String t : types = new String[]{"basic", "blacksmith", "carpenter", "chef", "chemist", "designer", "engineer", "farmer", "jeweler", "mage", "mason", "potter", "scribe", "tailor", "tanner"}) {
                event.register(new ResourceLocation("artisanworktables:" + t + "_shaped"), ShapedArtisanRecipeJS::new);
                event.register(new ResourceLocation("artisanworktables:" + t + "_shapeless"), ShapelessArtisanRecipeJS::new);
            }
        }
        if (Platform.isModLoaded((String)"botania")) {
            event.register(new ResourceLocation("botania:runic_altar"), BotaniaRunicAltarRecipeJS::new);
        }
        if (Platform.isModLoaded((String)"integrateddynamics") && !Platform.isModLoaded((String)"kubejs_integrated_dynamics")) {
            event.register(new ResourceLocation("integrateddynamics:squeezer"), IDSqueezerRecipeJS::new);
            event.register(new ResourceLocation("integrateddynamics:mechanical_squeezer"), IDSqueezerRecipeJS::new);
        }
    }

    @Override
    public void generateDataJsons(DataJsonGenerator generator) {
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            if (blockBuilder.lootTable != null) {
                LootBuilder lootBuilder = new LootBuilder(null);
                lootBuilder.type = "minecraft:block";
                blockBuilder.lootTable.accept(lootBuilder);
                generator.json(blockBuilder.newID("loot_tables/blocks/", ""), (JsonElement)lootBuilder.toJson());
            }
            blockBuilder.type.generateData(blockBuilder, generator);
        }
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            itemBuilder.type.generateData(itemBuilder, generator);
        }
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            generator.blockState(new ResourceLocation("kubejs", "detector_" + detectorInstance.id), bs -> {
                bs.variant("powered=false", "kubejs:block/detector");
                bs.variant("powered=true", "kubejs:block/detector_on");
            });
            generator.itemModel(new ResourceLocation("kubejs", "detector_" + detectorInstance.id), m -> m.parent("kubejs:block/detector"));
        }
        for (BlockBuilder blockBuilder : KubeJSObjects.BLOCKS.values()) {
            blockBuilder.type.generateAssets(blockBuilder, generator);
        }
        for (ItemBuilder itemBuilder : KubeJSObjects.ITEMS.values()) {
            itemBuilder.type.generateAssets(itemBuilder, generator);
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            generator.json(fluidBuilder.newID("blockstates/", ""), (JsonElement)fluidBuilder.getBlockstateJson());
            generator.json(fluidBuilder.newID("models/block/", ""), (JsonElement)fluidBuilder.getBlockModelJson());
            JsonObject bucketModel = new JsonObject();
            bucketModel.addProperty("parent", "kubejs:item/generated_bucket");
            generator.json(fluidBuilder.newID("models/item/", "_bucket"), (JsonElement)bucketModel);
        }
    }

    @Override
    public void generateLang(Map<String, String> lang) {
        lang.put("itemGroup.kubejs.kubejs", "KubeJS");
        lang.put("item.kubejs.dummy_fluid_item", "Dummy Fluid Item");
        for (BuilderBase builderBase : KubeJSObjects.ALL) {
            if (builderBase.displayName.isEmpty()) continue;
            lang.put(builderBase.translationKey, builderBase.displayName);
        }
        for (DetectorInstance detectorInstance : KubeJSObjects.DETECTORS.values()) {
            lang.put("block.kubejs.detector_" + detectorInstance.id, "KubeJS Detector [" + detectorInstance.id + "]");
        }
        for (FluidBuilder fluidBuilder : KubeJSObjects.FLUIDS.values()) {
            if (fluidBuilder.displayName.isEmpty()) continue;
            lang.put(fluidBuilder.bucketItem.func_77658_a(), fluidBuilder.displayName + " Bucket");
        }
    }
}

