/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.datacard;

import com.lothrazar.cyclic.base.ItemBase;
import com.lothrazar.cyclic.item.datacard.BlockStateMatcher;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockstateCard
extends ItemBase {
    private static final String EXACT_TAG = "doExactState";
    private static final String STATESTAG = "states";
    private static final int MAXSIZE = 18;

    public BlockstateCard(Item.Properties properties) {
        super(properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack held, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (held.func_77978_p() != null && held.func_77978_p().func_74764_b(STATESTAG)) {
            for (BlockStateMatcher m : BlockstateCard.getSavedStates(held)) {
                BlockState st = m.getState();
                TextFormatting c = m.isExactProperties() ? TextFormatting.LIGHT_PURPLE : TextFormatting.DARK_PURPLE;
                String extra = m.isExactProperties() ? " [state]" : " [block]";
                tooltip.add((ITextComponent)new TranslationTextComponent(st.func_177230_c().func_149739_a()).func_240702_b_(extra).func_240699_a_(c));
                if (!m.isExactProperties() || !Screen.func_231173_s_()) continue;
                tooltip.add((ITextComponent)new TranslationTextComponent(st.toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        } else {
            super.func_77624_a(held, worldIn, tooltip, flagIn);
        }
    }

    public static List<BlockStateMatcher> getSavedStates(ItemStack held) {
        ArrayList<BlockStateMatcher> st = new ArrayList<BlockStateMatcher>();
        if (held.func_77978_p() != null && held.func_77978_p().func_74764_b(STATESTAG)) {
            ListNBT stateTags = held.func_77978_p().func_150295_c(STATESTAG, 10);
            for (int i = 0; i < stateTags.size(); ++i) {
                CompoundNBT currTag = stateTags.func_150305_b(i);
                BlockState stateFound = NBTUtil.func_190008_d((CompoundNBT)currTag);
                if (stateFound == null || stateFound.func_177230_c() == Blocks.field_150350_a) continue;
                BlockStateMatcher matcher = new BlockStateMatcher();
                matcher.setState(stateFound);
                if (currTag.func_74764_b(EXACT_TAG)) {
                    matcher.setExactProperties(currTag.func_74767_n(EXACT_TAG));
                }
                st.add(matcher);
            }
        }
        return st;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        BlockPos pos = context.func_195995_a();
        ItemStack held = player.func_184586_b(hand);
        BlockState state = context.func_195991_k().func_180495_p(pos);
        CompoundNBT stateTag = NBTUtil.func_190009_a((BlockState)state);
        ListNBT stateTags = null;
        stateTags = held.func_196082_o().func_74764_b(STATESTAG) ? held.func_196082_o().func_150295_c(STATESTAG, 10) : new ListNBT();
        if (stateTags.size() >= 18) {
            return ActionResultType.PASS;
        }
        for (int i = 0; i < stateTags.size(); ++i) {
            BlockState stateFound = NBTUtil.func_190008_d((CompoundNBT)stateTags.func_150305_b(i));
            if (!stateFound.equals(state)) continue;
            return ActionResultType.PASS;
        }
        stateTag.func_74757_a(EXACT_TAG, !player.func_213453_ef());
        stateTags.add((Object)stateTag);
        held.func_196082_o().func_218657_a(STATESTAG, (INBT)stateTags);
        player.func_184609_a(hand);
        return ActionResultType.SUCCESS;
    }
}

