/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.endershelf;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.endershelf.EnderShelfItemHandler;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEnderShelf
extends TileEntityBase {
    public final EnderShelfItemHandler inventory = new EnderShelfItemHandler(this);
    private final LazyOptional<EnderShelfItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    public RenderTextType renderStyle = RenderTextType.TEXT;

    public TileEnderShelf() {
        super(TileRegistry.ender_shelf);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        this.inventory.deserializeNBT(tag.func_74775_l("inv"));
        if (tag.func_74764_b("RenderTextType")) {
            int rt = tag.func_74762_e("RenderTextType");
            this.renderStyle = RenderTextType.values()[rt];
        }
        this.inventory.resetNameCache();
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag.func_218657_a("inv", (INBT)this.inventory.serializeNBT());
        tag.func_74768_a("RenderTextType", this.renderStyle.ordinal());
        return super.func_189515_b(tag);
    }

    public void toggleShowText() {
        int ord = this.renderStyle.ordinal() + 1;
        if (ord == RenderTextType.values().length) {
            ord = 0;
        }
        this.renderStyle = RenderTextType.values()[ord];
    }

    public static enum RenderTextType {
        TEXT,
        STACK,
        NONE;

    }
}

