/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderitemshelf;

import com.lothrazar.cyclic.block.enderitemshelf.TileItemShelf;
import com.lothrazar.cyclic.block.endershelf.TileEnderShelf;
import com.lothrazar.cyclic.util.UtilRenderText;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;

public class ItemShelfRenderer
extends TileEntityRenderer<TileItemShelf> {
    public ItemShelfRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(TileItemShelf tile, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        Direction side = tile.getCurrentFacing();
        UtilRenderText.alignRendering(ms, side);
        for (int i = 0; i < tile.inventory.getSlots(); ++i) {
            this.renderSlot(tile, i, tile.inventory.getStackInSlot(i), ms, buffer, combinedLightIn, combinedOverlayIn);
        }
    }

    private void renderSlot(TileItemShelf tile, int slot, ItemStack stack, MatrixStack ms, IRenderTypeBuffer buffer, int combinedLightIn, int combinedOverlayIn) {
        if (stack.func_190926_b()) {
            return;
        }
        float sh = 16.0f;
        boolean color = false;
        double x = 0.09375;
        double y = (float)(3 * slot + 2) / 16.0f;
        double z = 1.01;
        float scaleNum = 0.094f;
        FontRenderer fontRenderer = this.field_228858_b_.func_147548_a();
        if (tile.renderStyle == TileEnderShelf.RenderTextType.STACK) {
            float sp = 0.19f;
            float xf = 0.16f + (float)slot * 0.19f / 1.5f;
            float yf = 1.0f - (0.88f - (float)slot * 0.19f);
            float size = 0.12f;
            ms.func_227860_a_();
            ms.func_227861_a_(0.0, 0.0, 1.0);
            ms.func_227861_a_((double)xf, (double)yf, 0.0);
            ms.func_227862_a_(size, size, size);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(stack, ItemCameraTransforms.TransformType.NONE, combinedLightIn, combinedOverlayIn, ms, buffer);
            ms.func_227865_b_();
        } else if (tile.renderStyle == TileEnderShelf.RenderTextType.TEXT) {
            String displayName = stack.func_200301_q().getString();
            float scaleName = 0.02832999f + 0.1f * this.getScaleFactor(displayName);
            ms.func_227860_a_();
            ms.func_227861_a_(0.07375, y + 0.06, 1.01);
            ms.func_227862_a_(0.0625f * scaleName, -0.0625f * scaleName, 5.0E-5f);
            fontRenderer.func_228079_a_(displayName, 0.0f, 0.0f, 0, false, ms.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLightIn);
            ms.func_227865_b_();
        }
        if (tile.renderStyle != TileEnderShelf.RenderTextType.NONE) {
            ms.func_227860_a_();
            ms.func_227861_a_((double)0.17475f, y, 1.01);
            ms.func_227862_a_(0.005875f, -0.005875f, 5.0E-5f);
            String displayCount = "x" + stack.func_190916_E();
            fontRenderer.func_228079_a_(displayCount, 110.0f, 0.0f, 0, false, ms.func_227866_c_().func_227870_a_(), buffer, false, 0, combinedLightIn);
            ms.func_227865_b_();
        }
    }

    private float getScaleFactor(String displayName) {
        int lv = 17;
        if (displayName.length() > lv) {
            return 1.0f - 0.027777778f * (float)(displayName.length() - lv);
        }
        return 1.0f;
    }
}

