/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.fluid;

import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.ShapeCache;
import com.lothrazar.cyclic.block.cable.fluid.ScreenCableFluid;
import com.lothrazar.cyclic.block.cable.fluid.TileCableFluid;
import com.lothrazar.cyclic.registry.ContainerScreenRegistry;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class BlockCableFluid
extends CableBase {
    public BlockCableFluid(AbstractBlock.Properties properties) {
        super(properties.func_200943_b(0.5f));
    }

    @Override
    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("block.cyclic.fluid_pipe.tooltip0").func_240699_a_(TextFormatting.GRAY));
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.cyclic.shift").func_240699_a_(TextFormatting.DARK_GRAY));
        }
    }

    @Override
    public void registerClient() {
        ScreenManager.func_216911_a(ContainerScreenRegistry.fluid_pipe, ScreenCableFluid::new);
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        FluidStack fluid;
        int st;
        TileEntity ent;
        IFluidHandler handlerHere;
        if (!world.field_72995_K && (handlerHere = (IFluidHandler)(ent = world.func_175625_s(pos)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null).orElse(null)) != null && handlerHere.getFluidInTank(0) != null && (st = (fluid = handlerHere.getFluidInTank(0)).getAmount()) > 0) {
            player.func_146105_b((ITextComponent)new TranslationTextComponent(st + " " + fluid.getDisplayName()), true);
        }
        return super.func_225533_a_(state, world, pos, player, hand, hit);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ShapeCache.getOrCreate(state, CableBase::createShape);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileCableFluid();
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState stateIn, LivingEntity placer, ItemStack stack) {
        for (Direction d : Direction.values()) {
            IFluidHandler cap;
            TileEntity facingTile = worldIn.func_175625_s(pos.func_177972_a(d));
            IFluidHandler iFluidHandler = cap = facingTile == null ? null : (IFluidHandler)facingTile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, d.func_176734_d()).orElse(null);
            if (cap == null) continue;
            stateIn = (BlockState)stateIn.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(d), (Comparable)((Object)EnumConnectType.INVENTORY));
            worldIn.func_175656_a(pos, stateIn);
        }
        super.func_180633_a(worldIn, pos, stateIn, placer, stack);
    }

    @Override
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileCableFluid tileentity = (TileCableFluid)worldIn.func_175625_s(pos);
            if (tileentity != null && tileentity.filter != null) {
                InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)tileentity.filter.getStackInSlot(0));
            }
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        EnumProperty property = (EnumProperty)FACING_TO_PROPERTY_MAP.get(facing);
        EnumConnectType oldProp = (EnumConnectType)((Object)stateIn.func_177229_b((Property)property));
        if (oldProp.isBlocked() || oldProp.isExtraction()) {
            return stateIn;
        }
        if (BlockCableFluid.isFluid(stateIn, facing, facingState, world, currentPos, facingPos)) {
            BlockState with = (BlockState)stateIn.func_206870_a((Property)property, (Comparable)((Object)EnumConnectType.INVENTORY));
            if (world instanceof World && world.func_180495_p(currentPos).func_177230_c() == this) {
                ((World)world).func_175656_a(currentPos, with);
            }
            return with;
        }
        return (BlockState)stateIn.func_206870_a((Property)property, (Comparable)((Object)EnumConnectType.NONE));
    }
}

