/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.battery;

import com.lothrazar.cyclic.base.TileEntityBase;
import com.lothrazar.cyclic.block.battery.BlockBattery;
import com.lothrazar.cyclic.block.battery.ContainerBattery;
import com.lothrazar.cyclic.block.battery.EnumBatteryPercent;
import com.lothrazar.cyclic.capability.CustomEnergyStorage;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.ItemStackHandler;

public class TileBattery
extends TileEntityBase
implements INamedContainerProvider,
ITickableTileEntity {
    private static final int SLOT_CHARGING_RATE = 8000;
    private Map<Direction, Boolean> poweredSides;
    CustomEnergyStorage energy = new CustomEnergyStorage(6400000, 1600000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    public static final int MAX = 6400000;
    ItemStackHandler batterySlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileBattery() {
        super(TileRegistry.batterytile);
        this.flowing = 0;
        this.poweredSides = new HashMap<Direction, Boolean>();
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, false);
        }
    }

    public void func_73660_a() {
        this.syncEnergy();
        this.setPercentFilled();
        boolean isFlowing = this.getFlowing() == 1;
        this.setLitProperty(isFlowing);
        if (isFlowing) {
            this.tickCableFlow();
        }
        this.chargeSlot();
    }

    private void chargeSlot() {
        int extracted;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack targ = this.batterySlots.getStackInSlot(0);
        IEnergyStorage storage = (IEnergyStorage)targ.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
        if (storage != null && (extracted = this.energy.extractEnergy(8000, true)) > 0 && storage.getEnergyStored() + extracted <= storage.getMaxEnergyStored()) {
            this.energy.extractEnergy(extracted, false);
            storage.receiveEnergy(extracted, false);
        }
    }

    public void setPercentFilled() {
        BlockState st = this.func_195044_w();
        if (st.func_235901_b_(BlockBattery.PERCENT)) {
            EnumBatteryPercent previousPercent = (EnumBatteryPercent)((Object)st.func_177229_b(BlockBattery.PERCENT));
            EnumBatteryPercent percent = this.calculateRoundedPercentFilled();
            if (percent != previousPercent) {
                this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)st.func_206870_a(BlockBattery.PERCENT, (Comparable)((Object)percent)));
            }
        }
    }

    public EnumBatteryPercent calculateRoundedPercentFilled() {
        int percent = (int)Math.floor((double)((float)this.getEnergy() * 1.0f / 6400000.0f) * 10.0) * 10;
        if (percent >= 100) {
            return EnumBatteryPercent.ONEHUNDRED;
        }
        if (percent >= 90) {
            return EnumBatteryPercent.NINETY;
        }
        if (percent >= 80) {
            return EnumBatteryPercent.EIGHTY;
        }
        if (percent >= 60) {
            return EnumBatteryPercent.SIXTY;
        }
        if (percent >= 40) {
            return EnumBatteryPercent.FOURTY;
        }
        if (percent >= 20) {
            return EnumBatteryPercent.TWENTY;
        }
        return EnumBatteryPercent.ZERO;
    }

    public boolean getSideHasPower(Direction side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(Direction side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(Direction side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void func_230337_a_(BlockState bs, CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, tag.func_74767_n("flow_" + f.func_176742_j()));
        }
        this.energy.deserializeNBT(tag.func_74775_l("energy"));
        this.batterySlots.deserializeNBT(tag.func_74775_l("invbatt"));
        super.func_230337_a_(bs, tag);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        for (Direction f : Direction.values()) {
            tag.func_74757_a("flow_" + f.func_176742_j(), this.poweredSides.get(f).booleanValue());
        }
        tag.func_74768_a("flowing", this.getFlowing());
        tag.func_218657_a("energy", (INBT)this.energy.serializeNBT());
        tag.func_218657_a("invbatt", (INBT)this.batterySlots.serializeNBT());
        return super.func_189515_b(tag);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerBattery(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity);
    }

    private void tickCableFlow() {
        Collections.shuffle(this.rawList);
        for (Integer i : this.rawList) {
            Direction exportToSide = Direction.values()[i];
            if (!this.poweredSides.get(exportToSide).booleanValue()) continue;
            this.moveEnergy(exportToSide, 1600000);
        }
    }

    public int getFlowing() {
        return this.flowing;
    }

    public void setFlowing(int flowing) {
        this.flowing = flowing;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case D: {
                return this.getSideField(Direction.DOWN);
            }
            case E: {
                return this.getSideField(Direction.EAST);
            }
            case N: {
                return this.getSideField(Direction.NORTH);
            }
            case S: {
                return this.getSideField(Direction.SOUTH);
            }
            case U: {
                return this.getSideField(Direction.UP);
            }
            case W: {
                return this.getSideField(Direction.WEST);
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return -1;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case FLOWING: {
                this.flowing = value;
                break;
            }
            case D: {
                this.setSideField(Direction.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(Direction.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(Direction.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(Direction.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(Direction.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(Direction.WEST, value % 2);
            }
        }
    }

    static enum Fields {
        FLOWING,
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

