/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.simulator.spawning;

import ipsis.woot.Woot;
import ipsis.woot.config.Config;
import ipsis.woot.config.ConfigOverride;
import ipsis.woot.simulator.spawning.CustomSpawnController;
import ipsis.woot.simulator.spawning.FakePlayerPool;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class SpawnController {
    static SpawnController INSTANCE = new SpawnController();
    private static final int UNKNOWN_MOB_HEALTH = 100;
    private static final int UNKNOWN_MOB_EXP = 1;
    private static Map<String, MobCacheEntry> mobCacheEntryHashMap = new HashMap<String, MobCacheEntry>();

    public static SpawnController get() {
        return INSTANCE;
    }

    public void spawnKill(@Nonnull FakeMobKey fakeMobKey, @Nonnull ServerWorld world, @Nonnull BlockPos spawnPos) {
        if (!fakeMobKey.getMob().isValid()) {
            return;
        }
        FakePlayer fakePlayer = FakePlayerPool.getFakePlayer(world, fakeMobKey.getLooting());
        if (fakePlayer == null) {
            return;
        }
        Entity entity = this.createEntity(fakeMobKey.getMob(), (World)world, spawnPos);
        if (entity == null || !(entity instanceof MobEntity)) {
            return;
        }
        MobEntity mobEntity = (MobEntity)entity;
        mobEntity.func_213386_a((IServerWorld)world, world.func_175649_E(new BlockPos((Vector3i)entity.func_233580_cy_())), SpawnReason.SPAWNER, null, null);
        mobEntity.field_70718_bc = 100;
        mobEntity.field_70717_bb = fakePlayer;
        CustomSpawnController.get().apply(mobEntity, fakeMobKey.getMob(), (World)world);
        mobEntity.func_70645_a(DamageSource.func_76365_a((PlayerEntity)fakePlayer));
    }

    @Nullable
    private Entity createEntity(@Nonnull FakeMob fakeMob, @Nonnull World world, @Nonnull BlockPos pos) {
        ResourceLocation rl = fakeMob.getResourceLocation();
        if (!ForgeRegistries.ENTITIES.containsKey(rl)) {
            Woot.setup.getLogger().debug("createEntity: {} not in entity list", (Object)rl);
            return null;
        }
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("id", rl.toString());
        Entity entity = EntityType.func_220335_a((CompoundNBT)nbt, (World)world, xc -> {
            xc.func_70012_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), xc.field_70177_z, xc.field_70125_A);
            return xc;
        });
        return entity;
    }

    public int getMobHealth(@Nonnull FakeMob fakeMob, @Nonnull World world) {
        if (world.field_72995_K) {
            return 100;
        }
        if (!fakeMob.isValid()) {
            return 100;
        }
        if (!this.isCached(fakeMob) && !this.updateCache(fakeMob, world)) {
            return 100;
        }
        if (Config.OVERRIDE.hasOverride(fakeMob, ConfigOverride.OverrideKey.HEALTH)) {
            return Config.OVERRIDE.getInteger(fakeMob, ConfigOverride.OverrideKey.HEALTH);
        }
        return SpawnController.mobCacheEntryHashMap.get((Object)fakeMob.toString()).health;
    }

    public int getMobExperience(@Nonnull FakeMob fakeMob, @Nonnull World world) {
        if (world.field_72995_K) {
            return 1;
        }
        if (!fakeMob.isValid()) {
            return 1;
        }
        if (!this.isCached(fakeMob) && !this.updateCache(fakeMob, world)) {
            return 1;
        }
        if (Config.OVERRIDE.hasOverride(fakeMob, ConfigOverride.OverrideKey.XP)) {
            return Config.OVERRIDE.getInteger(fakeMob, ConfigOverride.OverrideKey.XP);
        }
        return SpawnController.mobCacheEntryHashMap.get((Object)fakeMob.toString()).xp;
    }

    public boolean isAnimal(@Nonnull FakeMob fakeMob, @Nonnull World world) {
        if (!this.isCached(fakeMob) && !this.updateCache(fakeMob, world)) {
            return false;
        }
        return SpawnController.mobCacheEntryHashMap.get((Object)fakeMob.toString()).isAnimal;
    }

    private boolean isCached(@Nonnull FakeMob fakeMob) {
        return mobCacheEntryHashMap.containsKey(fakeMob.toString());
    }

    private boolean updateCache(@Nonnull FakeMob fakeMob, @Nonnull World world) {
        Entity entity = this.createEntity(fakeMob, world, new BlockPos(0, 0, 0));
        if (entity == null || !(entity instanceof LivingEntity)) {
            return false;
        }
        int health = (int)((LivingEntity)entity).func_110138_aP();
        FakePlayer fakePlayer = FakePlayerPool.getFakePlayer((ServerWorld)world, 0);
        int xp = 1;
        try {
            Method getExp = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"func_70693_a", (Class[])new Class[]{PlayerEntity.class});
            getExp.setAccessible(true);
            xp = (Integer)getExp.invoke((Object)entity, fakePlayer);
        }
        catch (Throwable e) {
            Woot.setup.getLogger().debug("Reflection of getExperiencePoints failed {}", e);
        }
        Woot.setup.getLogger().debug("updateCache: caching mob:{} xp:{} health:{}", (Object)fakeMob, (Object)xp, (Object)health);
        this.addToCache(fakeMob, entity instanceof AnimalEntity, xp, health);
        return true;
    }

    public boolean isLivingEntity(FakeMob fakeMob, World world) {
        Entity entity = this.createEntity(fakeMob, world, new BlockPos(0, 0, 0));
        return entity != null && entity instanceof MobEntity;
    }

    private void addToCache(FakeMob fakeMob, boolean isAnimal, int xp, int health) {
        mobCacheEntryHashMap.put(fakeMob.toString(), new MobCacheEntry(isAnimal, xp, health));
    }

    class MobCacheEntry {
        public boolean isAnimal = false;
        public int xp = 1;
        public int health = 1;

        public MobCacheEntry(boolean isAnimal, int xp, int health) {
            this.isAnimal = isAnimal;
            this.xp = xp;
            this.health = health;
        }
    }
}

