/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.blocks;

import ipsis.woot.modules.debug.DebugSetup;
import ipsis.woot.modules.debug.items.DebugItem;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryComponentProvider;
import ipsis.woot.modules.factory.blocks.HeartTileEntity;
import ipsis.woot.modules.layout.LayoutSetup;
import ipsis.woot.util.WootDebug;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class HeartBlock
extends Block
implements FactoryComponentProvider,
WootDebug {
    public HeartBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200947_a(SoundType.field_185852_e).func_200943_b(3.5f));
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)context.func_195992_f().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208157_J});
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new HeartTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult blockRayTraceResult) {
        if (worldIn.field_72995_K || handIn == Hand.OFF_HAND) {
            return ActionResultType.SUCCESS;
        }
        if (player.func_225608_bj_()) {
            return ActionResultType.FAIL;
        }
        if (player.func_184614_ca().func_77973_b() == LayoutSetup.INTERN_ITEM.get() || player.func_184614_ca().func_77973_b() == DebugSetup.DEBUG_ITEM.get()) {
            return ActionResultType.FAIL;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof HeartTileEntity && !((HeartTileEntity)te).isFormed()) {
            return ActionResultType.FAIL;
        }
        if (!(te instanceof INamedContainerProvider)) {
            throw new IllegalStateException("Named container provider is missing");
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te), (BlockPos)te.func_174877_v());
        return ActionResultType.CONSUME;
    }

    @Override
    public FactoryComponent getFactoryComponent() {
        return FactoryComponent.HEART;
    }

    @Override
    public List<String> getDebugText(List<String> debug, ItemUseContext itemUseContext) {
        debug.add("====> HeartBlock");
        DebugItem.getTileEntityDebug(debug, itemUseContext);
        return debug;
    }
}

