/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory;

import ipsis.woot.Woot;
import ipsis.woot.config.Config;
import ipsis.woot.config.ConfigOverride;
import ipsis.woot.modules.factory.Exotic;
import ipsis.woot.modules.factory.FactoryComponent;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.MobParam;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.blocks.Cell1TileEntity;
import ipsis.woot.modules.factory.blocks.Cell2TileEntity;
import ipsis.woot.modules.factory.blocks.Cell3TileEntity;
import ipsis.woot.modules.factory.blocks.Cell4TileEntity;
import ipsis.woot.modules.factory.blocks.CellTileEntityBase;
import ipsis.woot.modules.factory.blocks.UpgradeTileEntity;
import ipsis.woot.modules.factory.layout.Layout;
import ipsis.woot.modules.factory.layout.PatternBlock;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.MathHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FormedSetup {
    private Tier tier = Tier.TIER_1;
    private List<FakeMob> controllerMobs = new ArrayList<FakeMob>();
    private HashMap<Perk.Group, Integer> perks = new HashMap();
    private HashMap<FakeMob, MobParam> mobParams = new HashMap();
    private World world;
    private BlockPos importPos = BlockPos.field_177992_a;
    private BlockPos exportPos = BlockPos.field_177992_a;
    private BlockPos cellPos = BlockPos.field_177992_a;
    private int cellCapacity = 0;
    private int cellType = 0;
    private double shardDropChance = 0.0;
    private int[] shardDropWeights = new int[]{0, 0, 0};
    private int perkTierShardValue = 0;
    private Exotic exotic = Exotic.NONE;
    private Boolean perkCapped = false;

    private FormedSetup() {
    }

    private FormedSetup(World world, Tier tier) {
        this.world = world;
        this.tier = tier;
    }

    public List<FakeMob> getAllMobs() {
        return Collections.unmodifiableList(this.controllerMobs);
    }

    public Map<FakeMob, MobParam> getAllMobParams() {
        return Collections.unmodifiableMap(this.mobParams);
    }

    public Map<Perk.Group, Integer> getAllPerks() {
        return Collections.unmodifiableMap(this.perks);
    }

    public LazyOptional<IFluidHandler> getCellFluidHandler() {
        if (this.world != null) {
            TileEntity te = this.world.func_175625_s(this.cellPos);
            return te instanceof TileEntity ? te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) : LazyOptional.empty();
        }
        return LazyOptional.empty();
    }

    public boolean isPerkCapped() {
        return this.perkCapped;
    }

    public Exotic getExotic() {
        return this.exotic;
    }

    public boolean hasFluidIngredientExotic() {
        return this.exotic == Exotic.EXOTIC_A;
    }

    public boolean hasItemIngredientExotic() {
        return this.exotic == Exotic.EXOTIC_B;
    }

    public boolean hasConatusExotic() {
        return this.exotic == Exotic.EXOTIC_C;
    }

    public boolean hasSpawnTimExotic() {
        return this.exotic == Exotic.EXOTIC_D;
    }

    public boolean hasMassExotic() {
        return this.exotic == Exotic.EXOTIC_E;
    }

    public double getShardDropChance() {
        return this.shardDropChance;
    }

    public int getBasicShardWeight() {
        return this.shardDropWeights[0];
    }

    public int getAdvancedShardWeight() {
        return this.shardDropWeights[1];
    }

    public int getEliteShardWeight() {
        return this.shardDropWeights[2];
    }

    public int getPerkTierShardValue() {
        return this.perkTierShardValue;
    }

    public BlockPos getImportPos() {
        return this.importPos;
    }

    public BlockPos getExportPos() {
        return this.exportPos;
    }

    public World getWorld() {
        return this.world;
    }

    public Tier getTier() {
        return this.tier;
    }

    public int getCellCapacity() {
        return this.cellCapacity;
    }

    public int getCellType() {
        return this.cellType;
    }

    public int getCellFluidAmount() {
        LazyOptional<IFluidHandler> hdlr = this.getCellFluidHandler();
        if (hdlr.isPresent()) {
            IFluidHandler iFluidHandler = (IFluidHandler)hdlr.orElseThrow(NullPointerException::new);
            return iFluidHandler.getFluidInTank(0).getAmount();
        }
        return 0;
    }

    public int getLootingLevel() {
        return MathHelper.clampLooting(this.perks.getOrDefault((Object)Perk.Group.LOOTING, 0));
    }

    public List<LazyOptional<IItemHandler>> getImportHandlers() {
        ArrayList<LazyOptional<IItemHandler>> handlers = new ArrayList<LazyOptional<IItemHandler>>();
        for (Direction facing : Direction.values()) {
            TileEntity te;
            if (!this.world.func_175667_e(this.importPos.func_177972_a(facing)) || !((te = this.world.func_175625_s(this.importPos.func_177972_a(facing))) instanceof TileEntity)) continue;
            handlers.add((LazyOptional<IItemHandler>)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()));
        }
        return handlers;
    }

    public List<LazyOptional<IFluidHandler>> getImportFluidHandlers() {
        ArrayList<LazyOptional<IFluidHandler>> handlers = new ArrayList<LazyOptional<IFluidHandler>>();
        for (Direction facing : Direction.values()) {
            TileEntity te;
            if (!this.world.func_175667_e(this.importPos.func_177972_a(facing)) || !((te = this.world.func_175625_s(this.importPos.func_177972_a(facing))) instanceof TileEntity)) continue;
            handlers.add((LazyOptional<IFluidHandler>)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()));
        }
        return handlers;
    }

    public List<LazyOptional<IFluidHandler>> getExportFluidHandlers() {
        ArrayList<LazyOptional<IFluidHandler>> handlers = new ArrayList<LazyOptional<IFluidHandler>>();
        for (Direction facing : Direction.values()) {
            TileEntity te;
            if (!this.world.func_175667_e(this.exportPos.func_177972_a(facing)) || !((te = this.world.func_175625_s(this.exportPos.func_177972_a(facing))) instanceof TileEntity)) continue;
            handlers.add((LazyOptional<IFluidHandler>)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()));
        }
        return handlers;
    }

    public List<LazyOptional<IItemHandler>> getExportHandlers() {
        ArrayList<LazyOptional<IItemHandler>> handlers = new ArrayList<LazyOptional<IItemHandler>>();
        for (Direction facing : Direction.values()) {
            TileEntity te;
            if (!this.world.func_175667_e(this.exportPos.func_177972_a(facing)) || !((te = this.world.func_175625_s(this.exportPos.func_177972_a(facing))) instanceof TileEntity)) continue;
            handlers.add((LazyOptional<IItemHandler>)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()));
        }
        return handlers;
    }

    public int getMaxSpawnTime() {
        int max = 0;
        for (MobParam mobParam : this.mobParams.values()) {
            if (mobParam.baseSpawnTicks <= max) continue;
            max = mobParam.baseSpawnTicks;
        }
        return max;
    }

    public int getMinRateValue() {
        boolean hasPerk = false;
        int min = Integer.MAX_VALUE;
        for (MobParam mobParam : this.mobParams.values()) {
            if (!mobParam.hasPerkRateValue() || mobParam.getPerkRateValue() >= min) continue;
            min = mobParam.getPerkRateValue();
            hasPerk = true;
        }
        return hasPerk ? min : 0;
    }

    private void setupMobParams() {
        for (FakeMob fakeMob : this.controllerMobs) {
            int perkLevel;
            MobParam param = new MobParam();
            param.baseSpawnTicks = Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.SPAWN_TICKS);
            param.baseMassCount = Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.MASS_COUNT);
            if (Config.OVERRIDE.hasOverride(fakeMob, ConfigOverride.OverrideKey.FIXED_COST)) {
                param.baseFluidCost = Config.OVERRIDE.getInteger(fakeMob, ConfigOverride.OverrideKey.FIXED_COST);
            } else {
                int healthPoints = SpawnController.get().getMobHealth(fakeMob, this.world);
                int unitsPerHealthPoint = Config.OVERRIDE.getIntegerOrDefault(fakeMob, ConfigOverride.OverrideKey.UNITS_PER_HEALTH);
                param.baseFluidCost = unitsPerHealthPoint * healthPoints;
            }
            if (this.perks.containsKey((Object)Perk.Group.EFFICIENCY) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.EFFICIENCY, 0).intValue()) > 0) {
                param.setPerkEfficiencyValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.EFFICIENCY, perkLevel)));
            }
            if (this.perks.containsKey((Object)Perk.Group.MASS) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.MASS, 0).intValue()) > 0) {
                param.setPerkMassValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.MASS, perkLevel)));
            }
            if (this.perks.containsKey((Object)Perk.Group.RATE) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.RATE, 0).intValue()) > 0) {
                param.setPerkRateValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.RATE, perkLevel)));
            }
            if (this.perks.containsKey((Object)Perk.Group.XP) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.XP, 0).intValue()) > 0) {
                param.setPerkXpValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.XP, perkLevel)));
            }
            if (this.perks.containsKey((Object)Perk.Group.HEADLESS) && (perkLevel = this.perks.getOrDefault((Object)Perk.Group.HEADLESS, 0).intValue()) > 0) {
                param.setPerkHeadlessValue(Config.OVERRIDE.getIntegerOrDefault(fakeMob, Config.OVERRIDE.getKeyByPerk(Perk.Group.HEADLESS, perkLevel)));
            }
            this.mobParams.put(fakeMob, param);
        }
    }

    public String toString() {
        return "FormedSetup{tier=" + (Object)((Object)this.tier) + ", controllerMobs=" + this.controllerMobs + ", perks=" + this.perks + ", world=" + this.world + ", importPos=" + this.importPos + ", exportPos=" + this.exportPos + ", cellPos=" + this.cellPos + ", cellCapacity=" + this.cellCapacity + ", exotic=" + (Object)((Object)this.exotic) + '}';
    }

    public static FormedSetup createFromValidLayout(World world, Layout layout) {
        FormedSetup formedSetup = new FormedSetup(world, layout.getAbsolutePattern().getTier());
        for (FakeMob fakeMob : layout.getAbsolutePattern().getMobs()) {
            formedSetup.controllerMobs.add(new FakeMob(fakeMob));
        }
        for (PatternBlock pb : layout.getAbsolutePattern().getBlocks()) {
            TileEntity te;
            if (pb.getFactoryComponent() == FactoryComponent.FACTORY_UPGRADE) {
                Perk perk;
                te = world.func_175625_s(pb.getBlockPos());
                if (!(te instanceof UpgradeTileEntity) || (perk = ((UpgradeTileEntity)te).getUpgrade(world.func_180495_p(pb.getBlockPos()))) == Perk.EMPTY) continue;
                Perk.Group group = Perk.getGroup(perk);
                int perkLevel = Perk.getLevel(perk);
                if ((formedSetup.tier == Tier.TIER_1 || formedSetup.tier == Tier.TIER_2) && perkLevel > 1) {
                    perkLevel = 1;
                    formedSetup.perkCapped = true;
                } else if (formedSetup.tier == Tier.TIER_3 && perkLevel > 2) {
                    perkLevel = 2;
                    formedSetup.perkCapped = true;
                }
                Woot.setup.getLogger().debug("createFromValidLayout: adding perk {}/{}", (Object)group, (Object)perkLevel);
                formedSetup.perks.put(group, perkLevel);
                if (group != Perk.Group.TIER_SHARD) continue;
                if (perkLevel == 1) {
                    formedSetup.perkTierShardValue = (Integer)FactoryConfiguration.TIER_SHARD_1.get();
                } else if (perkLevel == 2) {
                    formedSetup.perkTierShardValue = (Integer)FactoryConfiguration.TIER_SHARD_2.get();
                } else if (perkLevel == 3) {
                    formedSetup.perkTierShardValue = (Integer)FactoryConfiguration.TIER_SHARD_3.get();
                }
                if (formedSetup.getTier() == Tier.TIER_1) {
                    formedSetup.shardDropChance = (Double)FactoryConfiguration.T1_FARM_DROP_CHANCE.get();
                    formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T1_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                    formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T1_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                    formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T1_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                    continue;
                }
                if (formedSetup.getTier() == Tier.TIER_2) {
                    formedSetup.shardDropChance = (Double)FactoryConfiguration.T2_FARM_DROP_CHANCE.get();
                    formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T2_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                    formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T2_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                    formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T2_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                    continue;
                }
                if (formedSetup.getTier() == Tier.TIER_3) {
                    formedSetup.shardDropChance = (Double)FactoryConfiguration.T3_FARM_DROP_CHANCE.get();
                    formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T3_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                    formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T3_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                    formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T3_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                    continue;
                }
                if (formedSetup.getTier() == Tier.TIER_4) {
                    formedSetup.shardDropChance = (Double)FactoryConfiguration.T4_FARM_DROP_CHANCE.get();
                    formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T4_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                    formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T4_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                    formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T4_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                    continue;
                }
                if (formedSetup.getTier() != Tier.TIER_5) continue;
                formedSetup.shardDropChance = (Double)FactoryConfiguration.T5_FARM_DROP_CHANCE.get();
                formedSetup.shardDropWeights[0] = (Integer)((List)FactoryConfiguration.T5_FARM_DROP_SHARD_WEIGHTS.get()).get(0);
                formedSetup.shardDropWeights[1] = (Integer)((List)FactoryConfiguration.T5_FARM_DROP_SHARD_WEIGHTS.get()).get(1);
                formedSetup.shardDropWeights[2] = (Integer)((List)FactoryConfiguration.T5_FARM_DROP_SHARD_WEIGHTS.get()).get(2);
                continue;
            }
            if (pb.getFactoryComponent() == FactoryComponent.CELL) {
                formedSetup.cellPos = new BlockPos((Vector3i)pb.getBlockPos());
                te = world.func_175625_s(pb.getBlockPos());
                if (!(te instanceof CellTileEntityBase)) continue;
                formedSetup.cellCapacity = ((CellTileEntityBase)te).getCapacity();
                if (te instanceof Cell1TileEntity) {
                    formedSetup.cellType = 0;
                    continue;
                }
                if (te instanceof Cell2TileEntity) {
                    formedSetup.cellType = 1;
                    continue;
                }
                if (te instanceof Cell3TileEntity) {
                    formedSetup.cellType = 2;
                    continue;
                }
                if (!(te instanceof Cell4TileEntity)) continue;
                formedSetup.cellType = 3;
                continue;
            }
            if (pb.getFactoryComponent() == FactoryComponent.IMPORT) {
                formedSetup.importPos = new BlockPos((Vector3i)pb.getBlockPos());
                continue;
            }
            if (pb.getFactoryComponent() != FactoryComponent.EXPORT) continue;
            formedSetup.exportPos = new BlockPos((Vector3i)pb.getBlockPos());
        }
        formedSetup.exotic = layout.getAbsolutePattern().getExotic();
        formedSetup.setupMobParams();
        return formedSetup;
    }
}

