/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.config;

import ipsis.woot.config.Config;
import ipsis.woot.modules.factory.FactoryConfiguration;
import ipsis.woot.modules.factory.Tier;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.simulator.spawning.SpawnController;
import ipsis.woot.util.FakeMob;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigOverride {
    private final Logger LOGGER = LogManager.getLogger();
    private HashMap<FakeMob, HashMap<OverrideKey, Object>> overrides = new HashMap();
    private HashMap<Perk.Group, OverrideKey[]> perkMap = new HashMap();
    public static final int INVALID_CONFIG_OVERRIDE_DEFAULT = -1;

    public ConfigOverride() {
        this.perkMap.put(Perk.Group.EFFICIENCY, new OverrideKey[]{OverrideKey.PERK_EFFICIENCY_1_REDUCTION, OverrideKey.PERK_EFFICIENCY_2_REDUCTION, OverrideKey.PERK_EFFICIENCY_3_REDUCTION});
        this.perkMap.put(Perk.Group.MASS, new OverrideKey[]{OverrideKey.PERK_MASS_1_COUNT, OverrideKey.PERK_MASS_2_COUNT, OverrideKey.PERK_MASS_3_COUNT});
        this.perkMap.put(Perk.Group.RATE, new OverrideKey[]{OverrideKey.PERK_RATE_1_REDUCTION, OverrideKey.PERK_RATE_2_REDUCTION, OverrideKey.PERK_RATE_3_REDUCTION});
        this.perkMap.put(Perk.Group.XP, new OverrideKey[]{OverrideKey.PERK_XP_1_PERCENTAGE, OverrideKey.PERK_XP_2_PERCENTAGE, OverrideKey.PERK_XP_3_PERCENTAGE});
        this.perkMap.put(Perk.Group.HEADLESS, new OverrideKey[]{OverrideKey.PERK_HEADLESS_1_PERCENTAGE, OverrideKey.PERK_HEADLESS_2_PERCENTAGE, OverrideKey.PERK_HEADLESS_3_PERCENTAGE});
    }

    public void add(FakeMob fakeMob, OverrideKey key, int v) {
        if (key.getClazz() != Integer.class) {
            this.LOGGER.error("Attempt to set integer override for {}:{}", (Object)fakeMob, (Object)key);
            return;
        }
        HashMap<OverrideKey, Integer> map = this.overrides.getOrDefault(fakeMob, null);
        if (map == null) {
            map = new HashMap<OverrideKey, Integer>();
            this.overrides.put(fakeMob, map);
        }
        map.put(key, v);
        this.LOGGER.info("Added integer override of {}:{} -> {}", (Object)fakeMob, (Object)key, (Object)v);
    }

    public boolean hasOverride(FakeMob fakeMob, OverrideKey key) {
        HashMap map = this.overrides.getOrDefault(fakeMob, null);
        if (map == null) {
            return false;
        }
        return map.containsKey((Object)key);
    }

    public int getIntegerOrDefault(FakeMob fakeMob, OverrideKey key) {
        if (Config.OVERRIDE.hasOverride(fakeMob, key)) {
            return Config.OVERRIDE.getInteger(fakeMob, key);
        }
        return Config.OVERRIDE.getDefaultInteger(key);
    }

    public int getInteger(FakeMob fakeMob, OverrideKey key) {
        if (key.clazz != Integer.class) {
            this.LOGGER.error("Config override " + (Object)((Object)key) + " is not an integer");
            return -1;
        }
        HashMap map = this.overrides.getOrDefault(fakeMob, null);
        if (map == null) {
            this.LOGGER.error("Config override " + fakeMob + " does not exist");
            return -1;
        }
        if (!map.containsKey((Object)key)) {
            this.LOGGER.error("Config override " + fakeMob + "/" + (Object)((Object)key) + " does not exist");
            return -1;
        }
        if (!(map.get((Object)key) instanceof Integer)) {
            this.LOGGER.error("Config override " + fakeMob + "/" + (Object)((Object)key) + " is not an integer");
            return -1;
        }
        return (Integer)map.get((Object)key);
    }

    public int getDefaultInteger(OverrideKey key) {
        if (key == OverrideKey.MASS_COUNT) {
            return (Integer)FactoryConfiguration.MASS_COUNT.get();
        }
        if (key == OverrideKey.SPAWN_TICKS) {
            return (Integer)FactoryConfiguration.SPAWN_TICKS.get();
        }
        if (key == OverrideKey.UNITS_PER_HEALTH) {
            return (Integer)FactoryConfiguration.UNITS_PER_HEALTH.get();
        }
        if (key == OverrideKey.SHARD_KILLS) {
            return (Integer)FactoryConfiguration.MOB_SHARD_KILLS.get();
        }
        if (key == OverrideKey.PERK_EFFICIENCY_1_REDUCTION) {
            return (Integer)FactoryConfiguration.EFFICIENCY_1.get();
        }
        if (key == OverrideKey.PERK_EFFICIENCY_2_REDUCTION) {
            return (Integer)FactoryConfiguration.EFFICIENCY_2.get();
        }
        if (key == OverrideKey.PERK_EFFICIENCY_3_REDUCTION) {
            return (Integer)FactoryConfiguration.EFFICIENCY_3.get();
        }
        if (key == OverrideKey.PERK_MASS_1_COUNT) {
            return (Integer)FactoryConfiguration.MASS_COUNT_1.get();
        }
        if (key == OverrideKey.PERK_MASS_2_COUNT) {
            return (Integer)FactoryConfiguration.MASS_COUNT_2.get();
        }
        if (key == OverrideKey.PERK_MASS_3_COUNT) {
            return (Integer)FactoryConfiguration.MASS_COUNT_3.get();
        }
        if (key == OverrideKey.PERK_RATE_1_REDUCTION) {
            return (Integer)FactoryConfiguration.RATE_1.get();
        }
        if (key == OverrideKey.PERK_RATE_2_REDUCTION) {
            return (Integer)FactoryConfiguration.RATE_2.get();
        }
        if (key == OverrideKey.PERK_RATE_3_REDUCTION) {
            return (Integer)FactoryConfiguration.RATE_3.get();
        }
        if (key == OverrideKey.PERK_XP_1_PERCENTAGE) {
            return (Integer)FactoryConfiguration.XP_1.get();
        }
        if (key == OverrideKey.PERK_XP_2_PERCENTAGE) {
            return (Integer)FactoryConfiguration.XP_2.get();
        }
        if (key == OverrideKey.PERK_XP_3_PERCENTAGE) {
            return (Integer)FactoryConfiguration.XP_3.get();
        }
        if (key == OverrideKey.PERK_HEADLESS_1_PERCENTAGE) {
            return (Integer)FactoryConfiguration.HEADLESS_1.get();
        }
        if (key == OverrideKey.PERK_HEADLESS_2_PERCENTAGE) {
            return (Integer)FactoryConfiguration.HEADLESS_2.get();
        }
        if (key == OverrideKey.PERK_HEADLESS_3_PERCENTAGE) {
            return (Integer)FactoryConfiguration.HEADLESS_3.get();
        }
        return -1;
    }

    public OverrideKey getKeyByPerk(Perk.Group group, int level) {
        level = MathHelper.func_76125_a((int)level, (int)1, (int)3) - 1;
        return this.perkMap.get((Object)group)[level];
    }

    public Tier getMobTier(FakeMob fakeMob, World world) {
        Tier tier = Tier.TIER_5;
        if (fakeMob.isValid() && world != null) {
            if (Config.OVERRIDE.hasOverride(fakeMob, OverrideKey.TIER)) {
                int v = Config.OVERRIDE.getInteger(fakeMob, OverrideKey.TIER);
                v = MathHelper.func_76125_a((int)v, (int)1, (int)Tier.getMaxTier());
                tier = Tier.byIndex(v);
            } else {
                int health = SpawnController.get().getMobHealth(fakeMob, world);
                if (health <= (Integer)FactoryConfiguration.TIER_1_MAX_UNITS.get()) {
                    tier = Tier.TIER_1;
                } else if (health <= (Integer)FactoryConfiguration.TIER_2_MAX_UNITS.get()) {
                    tier = Tier.TIER_2;
                } else if (health <= (Integer)FactoryConfiguration.TIER_3_MAX_UNITS.get()) {
                    tier = Tier.TIER_3;
                } else if (health <= (Integer)FactoryConfiguration.TIER_4_MAX_UNITS.get()) {
                    tier = Tier.TIER_4;
                }
            }
        }
        return tier;
    }

    public String getConfigAsString(FakeMob fakeMob, String key) {
        OverrideKey overrideKey = OverrideKey.getFromString(key);
        return "getConfigAsString not supported";
    }

    public static enum OverrideKey {
        MASS_COUNT("massCount"),
        SPAWN_TICKS("spawnTicks"),
        HEALTH("health"),
        XP("xp"),
        UNITS_PER_HEALTH("mbPerHealth"),
        TIER("fixedTier"),
        SHARD_KILLS("shardKills"),
        FIXED_COST("fixedCost"),
        PERK_EFFICIENCY_1_REDUCTION("perkEffl1Reduction"),
        PERK_EFFICIENCY_2_REDUCTION("perkEffl2Reduction"),
        PERK_EFFICIENCY_3_REDUCTION("perkEffl3Reduction"),
        PERK_MASS_1_COUNT("perkMassl1MobCount"),
        PERK_MASS_2_COUNT("perkMassl2MobCount"),
        PERK_MASS_3_COUNT("perkMassl3MobCount"),
        PERK_RATE_1_REDUCTION("perkRatel1Reduction"),
        PERK_RATE_2_REDUCTION("perkRatel2Reduction"),
        PERK_RATE_3_REDUCTION("perkRatel3Reduction"),
        PERK_XP_1_PERCENTAGE("perkXpl1Generate"),
        PERK_XP_2_PERCENTAGE("perkXpl1Generate"),
        PERK_XP_3_PERCENTAGE("perkXpl1Generate"),
        PERK_HEADLESS_1_PERCENTAGE("perkHeadlessl1HeadlessChance"),
        PERK_HEADLESS_2_PERCENTAGE("perkHeadlessl2HeadlessChance"),
        PERK_HEADLESS_3_PERCENTAGE("perkHeadlessl3HeadlessChance");

        private Class clazz;
        private String tag;

        private OverrideKey(String tag) {
            this(Integer.class);
            this.tag = tag;
        }

        private OverrideKey(Class clazz) {
            this.clazz = clazz;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public String getTag() {
            return this.tag;
        }

        public static boolean isValidTag(String s) {
            for (OverrideKey k : OverrideKey.values()) {
                if (!k.tag.equalsIgnoreCase(s)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public static OverrideKey getFromString(String s) {
            for (OverrideKey k : OverrideKey.values()) {
                if (!k.tag.equalsIgnoreCase(s)) continue;
                return k;
            }
            return null;
        }
    }
}

