/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.TileEntityBaseContainer;
import com.supermartijn642.core.gui.TileEntityBaseContainerScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.network.BasePacket;
import com.supermartijn642.itemcollectors.CollectorTile;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketToggleDurability;
import com.supermartijn642.itemcollectors.packet.PacketToggleShowArea;
import com.supermartijn642.itemcollectors.packet.PacketToggleWhitelist;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import com.supermartijn642.itemcollectors.screen.ArrowButton;
import com.supermartijn642.itemcollectors.screen.DurabilityButton;
import com.supermartijn642.itemcollectors.screen.ShowAreaButton;
import com.supermartijn642.itemcollectors.screen.WhitelistButton;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class AdvancedCollectorScreen
extends TileEntityBaseContainerScreen<CollectorTile, AdvancedCollectorContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("itemcollectors", "textures/filter_screen.png");
    private WhitelistButton whitelistButton;
    private DurabilityButton durabilityButton;
    private ShowAreaButton showAreaButton;

    public AdvancedCollectorScreen(AdvancedCollectorContainer container) {
        super((TileEntityBaseContainer)container, (ITextComponent)TextComponents.empty().get());
    }

    protected int sizeX(CollectorTile tile) {
        return 224;
    }

    protected int sizeY(CollectorTile tile) {
        return 206;
    }

    protected void addWidgets(CollectorTile tile) {
        this.addWidget((Widget)new ArrowButton(30, 37, false, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketIncreaseXRange(((AdvancedCollectorContainer)this.field_147002_h).getTilePos()))));
        this.addWidget((Widget)new ArrowButton(30, 63, true, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketDecreaseXRange(((AdvancedCollectorContainer)this.field_147002_h).getTilePos()))));
        this.addWidget((Widget)new ArrowButton(73, 37, false, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketIncreaseYRange(((AdvancedCollectorContainer)this.field_147002_h).getTilePos()))));
        this.addWidget((Widget)new ArrowButton(73, 63, true, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketDecreaseYRange(((AdvancedCollectorContainer)this.field_147002_h).getTilePos()))));
        this.addWidget((Widget)new ArrowButton(116, 37, false, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketIncreaseZRange(((AdvancedCollectorContainer)this.field_147002_h).getTilePos()))));
        this.addWidget((Widget)new ArrowButton(116, 63, true, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketDecreaseZRange(((AdvancedCollectorContainer)this.field_147002_h).getTilePos()))));
        this.whitelistButton = (WhitelistButton)this.addWidget((Widget)new WhitelistButton(175, 88, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketToggleWhitelist(((AdvancedCollectorContainer)this.field_147002_h).getTilePos()))));
        this.whitelistButton.update(tile.filterWhitelist);
        this.durabilityButton = (DurabilityButton)this.addWidget((Widget)new DurabilityButton(197, 88, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketToggleDurability(((AdvancedCollectorContainer)this.field_147002_h).getTilePos()))));
        this.durabilityButton.update(tile.filterDurability);
        this.showAreaButton = (ShowAreaButton)this.addWidget((Widget)new ShowAreaButton(160, 45, () -> ItemCollectors.CHANNEL.sendToServer((BasePacket)new PacketToggleShowArea(((AdvancedCollectorContainer)this.field_147002_h).getTilePos()))));
        this.showAreaButton.update(tile.showArea);
    }

    protected void tick(CollectorTile tile) {
        this.whitelistButton.update(tile.filterWhitelist);
        this.durabilityButton.update(tile.filterDurability);
        this.showAreaButton.update(tile.showArea);
    }

    protected void renderBackground(MatrixStack matrixStack, int mouseX, int mouseY, CollectorTile tile) {
        ScreenUtils.bindTexture((ResourceLocation)BACKGROUND);
        ScreenUtils.drawTexture((MatrixStack)matrixStack, (float)0.0f, (float)0.0f, (float)this.sizeX(), (float)this.sizeY());
    }

    protected void renderForeground(MatrixStack matrixStack, int mouseX, int mouseY, CollectorTile tile) {
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)tile.func_195044_w().func_177230_c().func_235333_g_(), (float)((float)this.sizeX() / 2.0f), (float)6.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)this.field_213127_e.func_145748_c_(), (float)32.0f, (float)112.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)TextComponents.translation((String)"gui.itemcollectors.basic_collector.range", (Object[])new Object[]{tile.rangeX * 2 + 1, tile.rangeY * 2 + 1, tile.rangeZ * 2 + 1}).get(), (float)8.0f, (float)26.0f);
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)TextComponents.string((String)"x:").get(), (float)25.0f, (float)51.0f);
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)TextComponents.string((String)("" + tile.rangeX)).get(), (float)39.0f, (float)52.0f);
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)TextComponents.string((String)"y:").get(), (float)68.0f, (float)51.0f);
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)TextComponents.string((String)("" + tile.rangeY)).get(), (float)82.0f, (float)52.0f);
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)TextComponents.string((String)"z:").get(), (float)111.0f, (float)51.0f);
        ScreenUtils.drawCenteredString((MatrixStack)matrixStack, (ITextComponent)TextComponents.string((String)("" + tile.rangeZ)).get(), (float)125.0f, (float)52.0f);
        ScreenUtils.drawString((MatrixStack)matrixStack, (ITextComponent)TextComponents.translation((String)"gui.itemcollectors.advanced_collector.filter").get(), (float)8.0f, (float)78.0f);
    }
}

