/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.network.PacketChannel;
import com.supermartijn642.itemcollectors.CollectorBlock;
import com.supermartijn642.itemcollectors.CollectorTile;
import com.supermartijn642.itemcollectors.ItemCollectorsConfig;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketDecreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseXRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseYRange;
import com.supermartijn642.itemcollectors.packet.PacketIncreaseZRange;
import com.supermartijn642.itemcollectors.packet.PacketToggleDurability;
import com.supermartijn642.itemcollectors.packet.PacketToggleShowArea;
import com.supermartijn642.itemcollectors.packet.PacketToggleWhitelist;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod(value="itemcollectors")
public class ItemCollectors {
    public static final PacketChannel CHANNEL = PacketChannel.create((String)"itemcollectors");
    @ObjectHolder(value="itemcollectors:basic_collector")
    public static Block basic_collector;
    @ObjectHolder(value="itemcollectors:advanced_collector")
    public static Block advanced_collector;
    @ObjectHolder(value="itemcollectors:basic_collector_tile")
    public static TileEntityType<CollectorTile> basic_collector_tile;
    @ObjectHolder(value="itemcollectors:advanced_collector_tile")
    public static TileEntityType<CollectorTile> advanced_collector_tile;
    @ObjectHolder(value="itemcollectors:filter_collector_container")
    public static ContainerType<AdvancedCollectorContainer> advanced_collector_container;

    public ItemCollectors() {
        CHANNEL.registerMessage(PacketIncreaseXRange.class, PacketIncreaseXRange::new, true);
        CHANNEL.registerMessage(PacketDecreaseXRange.class, PacketDecreaseXRange::new, true);
        CHANNEL.registerMessage(PacketIncreaseYRange.class, PacketIncreaseYRange::new, true);
        CHANNEL.registerMessage(PacketDecreaseYRange.class, PacketDecreaseYRange::new, true);
        CHANNEL.registerMessage(PacketIncreaseZRange.class, PacketIncreaseZRange::new, true);
        CHANNEL.registerMessage(PacketDecreaseZRange.class, PacketDecreaseZRange::new, true);
        CHANNEL.registerMessage(PacketToggleWhitelist.class, PacketToggleWhitelist::new, true);
        CHANNEL.registerMessage(PacketToggleDurability.class, PacketToggleDurability::new, true);
        CHANNEL.registerMessage(PacketToggleShowArea.class, PacketToggleShowArea::new, true);
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlockRegistry(RegistryEvent.Register<Block> e) {
            e.getRegistry().register((IForgeRegistryEntry)new CollectorBlock("basic_collector", CollectorTile::basicTile, ItemCollectorsConfig.basicCollectorMaxRange, ItemCollectorsConfig.basicCollectorFilter));
            e.getRegistry().register((IForgeRegistryEntry)new CollectorBlock("advanced_collector", CollectorTile::advancedTile, ItemCollectorsConfig.advancedCollectorMaxRange, ItemCollectorsConfig.advancedCollectorFilter));
        }

        @SubscribeEvent
        public static void onTileRegistry(RegistryEvent.Register<TileEntityType<?>> e) {
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(CollectorTile::basicTile, (Block[])new Block[]{basic_collector}).func_206865_a(null).setRegistryName("basic_collector_tile"));
            e.getRegistry().register(TileEntityType.Builder.func_223042_a(CollectorTile::advancedTile, (Block[])new Block[]{advanced_collector}).func_206865_a(null).setRegistryName("advanced_collector_tile"));
        }

        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> e) {
            e.getRegistry().register(new BlockItem(basic_collector, new Item.Properties().func_200916_a(ItemGroup.field_78027_g)).setRegistryName("basic_collector"));
            e.getRegistry().register(new BlockItem(advanced_collector, new Item.Properties().func_200916_a(ItemGroup.field_78027_g)).setRegistryName("advanced_collector"));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> e) {
            e.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> new AdvancedCollectorContainer(windowId, inv.field_70458_d, data.func_179259_c())).setRegistryName("filter_collector_container"));
        }
    }
}

