/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.itemcollectors.CollectorTile;
import com.supermartijn642.itemcollectors.CollectorTileRenderer;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorScreen;
import com.supermartijn642.itemcollectors.screen.BasicCollectorScreen;
import java.util.Random;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientProxy {
    @SubscribeEvent
    public static void onSetup(FMLClientSetupEvent e) {
        ScreenManager.func_216911_a(ItemCollectors.advanced_collector_container, (container, inventory, title) -> new AdvancedCollectorScreen((AdvancedCollectorContainer)container));
        ClientRegistry.bindTileEntityRenderer(ItemCollectors.basic_collector_tile, CollectorTileRenderer::new);
        ClientRegistry.bindTileEntityRenderer(ItemCollectors.advanced_collector_tile, CollectorTileRenderer::new);
    }

    public static void openBasicCollectorScreen(BlockPos pos) {
        ClientUtils.displayScreen((Screen)new BasicCollectorScreen(pos));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void onBlockHighlight(DrawHighlightEvent.HighlightBlock e) {
            World world = ClientUtils.getWorld();
            TileEntity tile = world.func_175625_s(e.getTarget().func_216350_a());
            if (tile instanceof CollectorTile) {
                e.getMatrix().func_227860_a_();
                Vector3d camera = RenderUtils.getCameraPosition();
                e.getMatrix().func_227861_a_(-camera.field_72450_a, -camera.field_72448_b, -camera.field_72449_c);
                AxisAlignedBB area = ((CollectorTile)tile).getAffectedArea().func_186662_g((double)0.05f);
                Random random = new Random(tile.func_174877_v().hashCode());
                float red = random.nextFloat();
                float green = random.nextFloat();
                float blue = random.nextFloat();
                float alpha = 0.3f;
                RenderUtils.renderBox((MatrixStack)e.getMatrix(), (AxisAlignedBB)area, (float)red, (float)green, (float)blue);
                RenderUtils.renderBoxSides((MatrixStack)e.getMatrix(), (AxisAlignedBB)area, (float)red, (float)green, (float)blue, (float)alpha);
                e.getMatrix().func_227865_b_();
            }
        }
    }
}

