/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.tile;

import com.refinedmods.refinedstorage.RSTiles;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.disk.IStorageDisk;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.apiimpl.network.node.diskdrive.DiskDriveNetworkNode;
import com.refinedmods.refinedstorage.tile.NetworkNodeTile;
import com.refinedmods.refinedstorage.tile.config.IAccessType;
import com.refinedmods.refinedstorage.tile.config.IComparable;
import com.refinedmods.refinedstorage.tile.config.IPrioritizable;
import com.refinedmods.refinedstorage.tile.config.IType;
import com.refinedmods.refinedstorage.tile.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.tile.data.RSSerializers;
import com.refinedmods.refinedstorage.tile.data.TileDataParameter;
import com.refinedmods.refinedstorage.util.WorldUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class DiskDriveTile
extends NetworkNodeTile<DiskDriveNetworkNode> {
    public static final TileDataParameter<Integer, DiskDriveTile> PRIORITY = IPrioritizable.createParameter();
    public static final TileDataParameter<Integer, DiskDriveTile> COMPARE = IComparable.createParameter();
    public static final TileDataParameter<Integer, DiskDriveTile> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter();
    public static final TileDataParameter<Integer, DiskDriveTile> TYPE = IType.createParameter();
    public static final TileDataParameter<AccessType, DiskDriveTile> ACCESS_TYPE = IAccessType.createParameter();
    public static final TileDataParameter<Long, DiskDriveTile> STORED = new TileDataParameter<Long, DiskDriveTile>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long stored = 0L;
        for (IStorageDisk storage : ((DiskDriveNetworkNode)t.getNode()).getItemDisks()) {
            if (storage == null) continue;
            stored += (long)storage.getStored();
        }
        for (IStorageDisk storage : ((DiskDriveNetworkNode)t.getNode()).getFluidDisks()) {
            if (storage == null) continue;
            stored += (long)storage.getStored();
        }
        return stored;
    });
    public static final TileDataParameter<Long, DiskDriveTile> CAPACITY = new TileDataParameter<Long, DiskDriveTile>(RSSerializers.LONG_SERIALIZER, 0L, t -> {
        long capacity = 0L;
        for (IStorageDisk storage : ((DiskDriveNetworkNode)t.getNode()).getItemDisks()) {
            if (storage == null) continue;
            if (storage.getCapacity() == -1) {
                return -1L;
            }
            capacity += (long)storage.getCapacity();
        }
        for (IStorageDisk storage : ((DiskDriveNetworkNode)t.getNode()).getFluidDisks()) {
            if (storage == null) continue;
            if (storage.getCapacity() == -1) {
                return -1L;
            }
            capacity += (long)storage.getCapacity();
        }
        return capacity;
    });
    public static final ModelProperty<DiskState[]> DISK_STATE_PROPERTY = new ModelProperty();
    private static final String NBT_DISK_STATE = "DiskStates";
    private final LazyOptional<IItemHandler> diskCapability = LazyOptional.of(() -> ((DiskDriveNetworkNode)this.getNode()).getDisks());
    private final DiskState[] diskState = new DiskState[8];

    public DiskDriveTile() {
        super(RSTiles.DISK_DRIVE);
        this.dataManager.addWatchedParameter(PRIORITY);
        this.dataManager.addWatchedParameter(COMPARE);
        this.dataManager.addWatchedParameter(WHITELIST_BLACKLIST);
        this.dataManager.addWatchedParameter(TYPE);
        this.dataManager.addWatchedParameter(ACCESS_TYPE);
        this.dataManager.addWatchedParameter(STORED);
        this.dataManager.addWatchedParameter(CAPACITY);
        Arrays.fill((Object[])this.diskState, (Object)DiskState.NONE);
    }

    @Override
    public CompoundNBT writeUpdate(CompoundNBT tag) {
        super.writeUpdate(tag);
        ListNBT list = new ListNBT();
        for (DiskState state : ((DiskDriveNetworkNode)this.getNode()).getDiskState()) {
            list.add((Object)IntNBT.func_229692_a_((int)state.ordinal()));
        }
        tag.func_218657_a(NBT_DISK_STATE, (INBT)list);
        return tag;
    }

    @Override
    public void readUpdate(CompoundNBT tag) {
        super.readUpdate(tag);
        ListNBT list = tag.func_150295_c(NBT_DISK_STATE, 3);
        for (int i = 0; i < list.size(); ++i) {
            this.diskState[i] = DiskState.values()[list.func_186858_c(i)];
        }
        this.requestModelDataUpdate();
        WorldUtils.updateBlock(this.field_145850_b, this.field_174879_c);
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(DISK_STATE_PROPERTY, (Object)this.diskState).build();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.diskCapability.cast();
        }
        return super.getCapability(cap, direction);
    }

    @Override
    @Nonnull
    public DiskDriveNetworkNode createNode(World world, BlockPos pos) {
        return new DiskDriveNetworkNode(world, pos);
    }
}

