/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.refinedmods.refinedstorage.integration.jei.Ingredient;
import com.refinedmods.refinedstorage.integration.jei.IngredientTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class RecipeTransferCraftingGridError
implements IRecipeTransferError {
    private static final Color MISSING_HIGHLIGHT_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.4f);
    protected static final Color AUTOCRAFTING_HIGHLIGHT_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.4f);
    protected final IngredientTracker tracker;

    public RecipeTransferCraftingGridError(IngredientTracker tracker) {
        this.tracker = tracker;
    }

    public IRecipeTransferError.Type getType() {
        return IRecipeTransferError.Type.COSMETIC;
    }

    public void showError(MatrixStack stack, int mouseX, int mouseY, IRecipeLayout recipeLayout, int recipeX, int recipeY) {
        List<ITextComponent> message = this.drawIngredientHighlights(stack, recipeX, recipeY);
        Screen currentScreen = Minecraft.func_71410_x().field_71462_r;
        GuiUtils.drawHoveringText((ItemStack)ItemStack.field_190927_a, (MatrixStack)stack, message, (int)mouseX, (int)mouseY, (int)currentScreen.field_230708_k_, (int)currentScreen.field_230709_l_, (int)200, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
    }

    protected List<ITextComponent> drawIngredientHighlights(MatrixStack stack, int recipeX, int recipeY) {
        ArrayList<ITextComponent> message = new ArrayList<ITextComponent>();
        message.add((ITextComponent)new TranslationTextComponent("jei.tooltip.transfer"));
        boolean craftMessage = false;
        boolean missingMessage = false;
        for (Ingredient ingredient : this.tracker.getIngredients()) {
            if (ingredient.isAvailable()) continue;
            if (ingredient.isCraftable()) {
                ingredient.getGuiIngredient().drawHighlight(stack, AUTOCRAFTING_HIGHLIGHT_COLOR.getRGB(), recipeX, recipeY);
                craftMessage = true;
                continue;
            }
            ingredient.getGuiIngredient().drawHighlight(stack, MISSING_HIGHLIGHT_COLOR.getRGB(), recipeX, recipeY);
            missingMessage = true;
        }
        if (missingMessage) {
            message.add((ITextComponent)new TranslationTextComponent("jei.tooltip.error.recipe.transfer.missing").func_240699_a_(TextFormatting.RED));
        }
        if (craftMessage) {
            message.add((ITextComponent)new TranslationTextComponent("gui.refinedstorage.jei.transfer.request_autocrafting").func_240699_a_(TextFormatting.BLUE));
        }
        return message;
    }
}

