/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items.util.fluid;

import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.FluidTags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import xreliquary.init.ModItems;
import xreliquary.items.InfernalChaliceItem;
import xreliquary.reference.Settings;

public class FluidHandlerInfernalChalice
extends FluidHandlerItemStack {
    private static final String FLUID_STACKS_TAG = "fluidStacks";

    public FluidHandlerInfernalChalice(ItemStack chalice) {
        super(chalice, ((Integer)Settings.COMMON.items.infernalChalice.fluidLimit.get()).intValue());
    }

    public boolean canDrainFluidType(FluidStack fluid) {
        return !((InfernalChaliceItem)ModItems.INFERNAL_CHALICE.get()).isEnabled(this.container) && FluidTags.field_206960_b.func_230235_a_((Object)fluid.getFluid()) && this.getFluid().getAmount() >= fluid.getAmount();
    }

    protected void setContainerToEmpty() {
        this.setFluid(new FluidStack((Fluid)Fluids.field_204547_b, 0));
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return ((InfernalChaliceItem)ModItems.INFERNAL_CHALICE.get()).isEnabled(this.container) && fluid.getFluid() == Fluids.field_204547_b;
    }

    protected void setFluid(FluidStack fluid) {
        if (!this.container.func_77942_o()) {
            this.container.func_77982_d(new CompoundNBT());
        }
        this.container.func_77978_p().func_74768_a(FLUID_STACKS_TAG, fluid.getAmount());
    }

    public FluidStack getFluid() {
        CompoundNBT tagCompound = this.container.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b(FLUID_STACKS_TAG)) {
            return new FluidStack((Fluid)Fluids.field_204547_b, 0);
        }
        return new FluidStack((Fluid)Fluids.field_204547_b, tagCompound.func_74762_e(FLUID_STACKS_TAG));
    }
}

