/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.compat.jei.infernaltear;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import xreliquary.compat.jei.ReliquaryRecipeCategory;
import xreliquary.compat.jei.infernaltear.InfernalTearRecipe;
import xreliquary.init.ModItems;
import xreliquary.items.InfernalTearItem;
import xreliquary.reference.Reference;
import xreliquary.util.LanguageHelper;
import xreliquary.util.XpHelper;

public class InfernalTearRecipeCategory
extends ReliquaryRecipeCategory<InfernalTearRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("xreliquary", "infernal_tear");
    private static final int INPUT_SLOT_1 = 0;
    private static final ResourceLocation BACKGROUNDS_TEXTURE = new ResourceLocation(Reference.DOMAIN + "textures/gui/jei/backgrounds.png");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable icon;

    public InfernalTearRecipeCategory(IGuiHelper guiHelper) {
        super(UID);
        this.background = guiHelper.createDrawable(BACKGROUNDS_TEXTURE, 0, 76, 110, 25);
        this.localizedName = LanguageHelper.getLocalization("jei.xreliquary.recipe.infernal_tear", new Object[0]);
        ItemStack iconTear = new ItemStack((IItemProvider)ModItems.INFERNAL_TEAR.get());
        InfernalTearItem.setTearTarget(iconTear, new ItemStack((IItemProvider)Items.field_151042_j));
        this.icon = guiHelper.createDrawableIngredient((Object)iconTear);
    }

    public Class<? extends InfernalTearRecipe> getRecipeClass() {
        return InfernalTearRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(InfernalTearRecipe recipe, IIngredients ingredients) {
        recipe.setIngredients(ingredients);
    }

    public void setRecipe(IRecipeLayout recipeLayout, InfernalTearRecipe recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 16, 0);
        List ingredientsInputs = ingredients.getInputs(VanillaTypes.ITEM);
        recipeLayout.getItemStacks().set(0, (List)ingredientsInputs.get(0));
    }

    public void draw(InfernalTearRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        int experiencePoints = recipe.getExperiencePoints();
        String points = experiencePoints + " " + LanguageHelper.getLocalization("jei.xreliquary.recipe.infernal_tear.xp", new Object[0]);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(points);
        fontRenderer.func_238421_b_(matrixStack, points, (float)((double)this.background.getWidth() / 2.0 + ((double)this.background.getWidth() / 2.0 + 16.0 - (double)stringWidth) / 2.0), 5.0f, -8355712);
        this.drawLevels(matrixStack, experiencePoints, fontRenderer);
    }

    private void drawLevels(MatrixStack matrixStack, int experiencePoints, FontRenderer fontRenderer) {
        int numberOfLevels = XpHelper.getLevelForExperience(experiencePoints);
        this.drawXpBar(matrixStack, experiencePoints, numberOfLevels);
        this.drawXpLevel(matrixStack, fontRenderer, numberOfLevels);
    }

    private void drawXpLevel(MatrixStack matrixStack, FontRenderer fontRenderer, int numberOfLevels) {
        String xpLevel = Integer.toString(numberOfLevels);
        int x = (this.background.getWidth() - fontRenderer.func_78256_a(xpLevel)) / 2;
        int y = this.background.getHeight() - 10;
        fontRenderer.func_238421_b_(matrixStack, xpLevel, (float)(x + 1), (float)y, 0);
        fontRenderer.func_238421_b_(matrixStack, xpLevel, (float)(x - 1), (float)y, 0);
        fontRenderer.func_238421_b_(matrixStack, xpLevel, (float)x, (float)(y + 1), 0);
        fontRenderer.func_238421_b_(matrixStack, xpLevel, (float)x, (float)(y - 1), 0);
        fontRenderer.func_238421_b_(matrixStack, xpLevel, (float)x, (float)y, 8453920);
    }

    private void drawXpBar(MatrixStack matrixStack, int experiencePoints, int level) {
        int partialXp = experiencePoints - XpHelper.getExperienceForLevel(level);
        int maxBarExperience = XpHelper.getExperienceLimitOnLevel(level);
        if (partialXp == 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureManager textureManager = minecraft.func_110434_K();
        textureManager.func_110577_a(BACKGROUNDS_TEXTURE);
        float textureWidth = 256.0f;
        float textureHeight = 256.0f;
        float minU = 0.0f;
        float minV = 101.0f;
        float maxU = 110.0f * ((float)partialXp / (float)maxBarExperience);
        float maxV = 106.0f;
        float width = maxU - minU;
        float height = maxV - minV;
        float x = 0.0f;
        float y = (float)this.background.getHeight() - 5.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        bufferBuilder.func_227888_a_(matrix, x, y + height, 0.0f).func_225583_a_(minU / textureWidth, maxV / textureHeight).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, x + width, y + height, 0.0f).func_225583_a_(maxU / textureWidth, maxV / textureHeight).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, x + width, y, 0.0f).func_225583_a_(maxU / textureWidth, minV / textureHeight).func_181675_d();
        bufferBuilder.func_227888_a_(matrix, x, y, 0.0f).func_225583_a_(minU / textureWidth, minV / textureHeight).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }
}

