/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.client.init;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import xreliquary.init.ModItems;
import xreliquary.items.BulletItem;
import xreliquary.items.MobCharmFragmentItem;
import xreliquary.items.MobCharmItem;
import xreliquary.items.VoidTearItem;
import xreliquary.items.util.IPotionItem;
import xreliquary.util.NBTHelper;

@OnlyIn(value=Dist.CLIENT)
public class ModItemColors {
    private ModItemColors() {
    }

    public static void init() {
        ItemColors itemColors = Minecraft.func_71410_x().getItemColors();
        ModItemColors.registerMobCharmItemColors();
        ModItemColors.registerBulletItemColors();
        ModItemColors.registerPotionItemColors();
        ModItemColors.registerVoidTearItemColors(itemColors);
    }

    private static void registerVoidTearItemColors(ItemColors itemColors) {
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            ItemStack containedStack;
            if (Screen.func_231173_s_() && !(containedStack = VoidTearItem.getTearContents(stack, true)).func_190926_b()) {
                return itemColors.func_186728_a(containedStack, tintIndex);
            }
            return -1;
        }, (Item)ModItems.VOID_TEAR.get());
    }

    private static void registerPotionItemColors() {
        ModItemColors.registerItemColor((stack, tintIndex) -> ModItemColors.getColor(stack), (Item)ModItems.POTION_ESSENCE.get());
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            if (tintIndex == 1) {
                if (NBTHelper.getInt("renderColor", stack) > 0) {
                    return NBTHelper.getInt("renderColor", stack);
                }
                List<EffectInstance> effects = ((IPotionItem)stack.func_77973_b()).getEffects(stack);
                if (effects.isEmpty()) {
                    return Integer.parseInt("FFFFFF", 16);
                }
                return PotionUtils.func_185181_a(effects);
            }
            return Integer.parseInt("FFFFFF", 16);
        }, (Item)ModItems.POTION.get(), (Item)ModItems.SPLASH_POTION.get(), (Item)ModItems.LINGERING_POTION.get());
        ModItemColors.registerItemColor((stack, tintIndex) -> tintIndex == 0 ? PotionUtils.func_185181_a(((IPotionItem)stack.func_77973_b()).getEffects(stack)) : -1, (Item)ModItems.TIPPED_ARROW.get());
    }

    private static void registerBulletItemColors() {
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            if (tintIndex == 0) {
                return Integer.parseInt("666666", 16);
            }
            if (tintIndex == 1) {
                return ((BulletItem)stack.func_77973_b()).getColor();
            }
            if (tintIndex == 2) {
                return PotionUtils.func_185181_a(((IPotionItem)stack.func_77973_b()).getEffects(stack));
            }
            return Integer.parseInt("666666", 16);
        }, (Item)ModItems.EMPTY_MAGAZINE.get(), (Item)ModItems.NEUTRAL_MAGAZINE.get(), (Item)ModItems.EXORCISM_MAGAZINE.get(), (Item)ModItems.BLAZE_MAGAZINE.get(), (Item)ModItems.ENDER_MAGAZINE.get(), (Item)ModItems.CONCUSSIVE_MAGAZINE.get(), (Item)ModItems.BUSTER_MAGAZINE.get(), (Item)ModItems.SEEKER_MAGAZINE.get(), (Item)ModItems.SAND_MAGAZINE.get(), (Item)ModItems.STORM_MAGAZINE.get(), (Item)ModItems.EMPTY_BULLET.get(), (Item)ModItems.NEUTRAL_BULLET.get(), (Item)ModItems.EXORCISM_BULLET.get(), (Item)ModItems.BLAZE_BULLET.get(), (Item)ModItems.ENDER_BULLET.get(), (Item)ModItems.CONCUSSIVE_BULLET.get(), (Item)ModItems.BUSTER_BULLET.get(), (Item)ModItems.SEEKER_BULLET.get(), (Item)ModItems.SAND_BULLET.get(), (Item)ModItems.STORM_BULLET.get());
    }

    private static void registerMobCharmItemColors() {
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            if (tintIndex < 1 || tintIndex > 2) {
                return -1;
            }
            ResourceLocation entityName = MobCharmItem.getEntityEggRegistryName(stack);
            return ModItemColors.getEgg(entityName).map(egg -> tintIndex == 1 ? egg.func_195983_a(0) : egg.func_195983_a(1)).orElse(-1);
        }, (Item)ModItems.MOB_CHARM.get());
        ModItemColors.registerItemColor((stack, tintIndex) -> {
            if (tintIndex < 0 || tintIndex > 1) {
                return -1;
            }
            ResourceLocation entityName = MobCharmFragmentItem.getEntityEggRegistryName(stack);
            return ModItemColors.getEgg(entityName).map(egg -> tintIndex == 0 ? egg.func_195983_a(0) : egg.func_195983_a(1)).orElse(-1);
        }, (Item)ModItems.MOB_CHARM_FRAGMENT.get());
    }

    private static void registerItemColor(IItemColor itemColor, Item ... items) {
        if (ModItems.isEnabled(items)) {
            Minecraft.func_71410_x().getItemColors().func_199877_a(itemColor, (IItemProvider[])items);
        }
    }

    private static Optional<SpawnEggItem> getEgg(ResourceLocation entityName) {
        return Optional.ofNullable(SpawnEggItem.func_200889_b((EntityType)((EntityType)ForgeRegistries.ENTITIES.getValue(entityName))));
    }

    private static int getColor(ItemStack stack) {
        return PotionUtils.func_185181_a(((IPotionItem)stack.func_77973_b()).getEffects(stack));
    }
}

