/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.effects;

import appeng.client.render.effects.LightningArcParticleData;
import appeng.client.render.effects.LightningFX;
import java.util.Random;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.world.ClientWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LightningArcFX
extends LightningFX {
    private static final Random RANDOM_GENERATOR = new Random();
    private final double rx;
    private final double ry;
    private final double rz;

    public LightningArcFX(ClientWorld w, double x, double y, double z, double ex, double ey, double ez, double r, double g, double b) {
        super(w, x, y, z, r, g, b, 6);
        this.rx = ex - x;
        this.ry = ey - y;
        this.rz = ez - z;
        this.regen();
    }

    @Override
    protected void regen() {
        double i = 1.0 / (double)(this.getSteps() - 1);
        double lastDirectionX = this.rx * i;
        double lastDirectionY = this.ry * i;
        double lastDirectionZ = this.rz * i;
        double len = Math.sqrt(lastDirectionX * lastDirectionX + lastDirectionY * lastDirectionY + lastDirectionZ * lastDirectionZ);
        for (int s = 0; s < this.getSteps(); ++s) {
            double[][] localSteps = this.getPrecomputedSteps();
            localSteps[s][0] = (lastDirectionX + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
            localSteps[s][1] = (lastDirectionY + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
            localSteps[s][2] = (lastDirectionZ + (RANDOM_GENERATOR.nextDouble() - 0.5) * len * 1.2) / 2.0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<LightningArcParticleData> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(LightningArcParticleData data, ClientWorld worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            LightningArcFX lightningFX = new LightningArcFX(worldIn, x, y, z, data.target.field_72450_a, data.target.field_72448_b, data.target.field_72449_c, 0.0, 0.0, 0.0);
            lightningFX.func_217568_a(this.spriteSet);
            return lightningFX;
        }
    }
}

