/*
 * Decompiled with CFR 0.152.
 */
package appeng.block;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.definitions.ITileDefinition;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.block.AEBaseBlockItem;
import appeng.core.Api;
import appeng.core.localization.GuiText;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AEBaseBlockItemChargeable
extends AEBaseBlockItem
implements IAEItemPowerStorage {
    public AEBaseBlockItemChargeable(Block id, Item.Properties props) {
        super(id, props);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addCheckedInformation(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag advancedTooltips) {
        double internalCurrentPower = 0.0;
        double internalMaxPower = this.getMaxEnergyCapacity();
        if (internalMaxPower > 0.0) {
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null) {
                internalCurrentPower = tag.func_74769_h("internalCurrentPower");
            }
            double percent = internalCurrentPower / internalMaxPower;
            lines.add((ITextComponent)GuiText.StoredEnergy.text().func_230532_e_().func_240702_b_(':' + MessageFormat.format(" {0,number,#} ", internalCurrentPower)).func_230529_a_((ITextComponent)new TranslationTextComponent(PowerUnits.AE.unlocalizedName)).func_240702_b_(" - " + MessageFormat.format("{0,number,#.##%}", percent)));
        }
    }

    @Override
    public double injectAEPower(ItemStack is, double amount, Actionable mode) {
        double internalCurrentPower = this.getInternal(is);
        double internalMaxPower = this.getAEMaxPower(is);
        double required = internalMaxPower - internalCurrentPower;
        double overflow = Math.max(0.0, amount - required);
        if (mode == Actionable.MODULATE) {
            double toAdd = Math.min(required, amount);
            double newPowerStored = internalCurrentPower + toAdd;
            this.setInternal(is, newPowerStored);
        }
        return overflow;
    }

    @Override
    public double extractAEPower(ItemStack is, double amount, Actionable mode) {
        double internalCurrentPower = this.getInternal(is);
        double fulfillable = Math.min(amount, internalCurrentPower);
        if (mode == Actionable.MODULATE) {
            double newPowerStored = internalCurrentPower - fulfillable;
            this.setInternal(is, newPowerStored);
        }
        return fulfillable;
    }

    @Override
    public double getAEMaxPower(ItemStack is) {
        return this.getMaxEnergyCapacity();
    }

    @Override
    public double getAECurrentPower(ItemStack is) {
        return this.getInternal(is);
    }

    @Override
    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    private double getMaxEnergyCapacity() {
        Block blockID = Block.func_149634_a((Item)this);
        ITileDefinition energyCell = Api.instance().definitions().blocks().energyCell();
        return energyCell.maybeBlock().map(block -> {
            if (blockID == block) {
                return 200000;
            }
            return 1600000;
        }).orElse(0).intValue();
    }

    private double getInternal(ItemStack is) {
        CompoundNBT nbt = is.func_196082_o();
        return nbt.func_74769_h("internalCurrentPower");
    }

    private void setInternal(ItemStack is, double amt) {
        CompoundNBT nbt = is.func_196082_o();
        nbt.func_74780_a("internalCurrentPower", amt);
    }
}

