/*
 * Decompiled with CFR 0.152.
 */
package com.sunekaer.mods.sdrp.discord;

import com.sunekaer.mods.sdrp.SDRP;
import com.sunekaer.mods.sdrp.config.Config;
import com.sunekaer.mods.sdrp.discord.discordipc.IPCClient;
import com.sunekaer.mods.sdrp.discord.discordipc.entities.DiscordBuild;
import com.sunekaer.mods.sdrp.discord.discordipc.entities.RichPresence;
import com.sunekaer.mods.sdrp.discord.discordipc.exceptions.NoDiscordClientException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;

public class DiscordRichPresence {
    private static final OffsetDateTime TIME = OffsetDateTime.now();
    private static final Timer TIMER = new Timer("DiscordRP Timer");
    private static State currentState;
    private static final IPCClient CLIENT;
    private static boolean isEnabled;
    private static int errorCount;
    private static TimerTask timerTask;
    public static HashMap<String, State> map;

    public static void start() {
        try {
            CLIENT.connect(new DiscordBuild[0]);
            timerTask = new TimerTask(){

                @Override
                public void run() {
                    DiscordRichPresence.setState(currentState);
                }
            };
            TIMER.schedule(timerTask, 1000L, 120000L);
            isEnabled = true;
            SDRP.LOGGER.info("Discord client found and connected.");
        }
        catch (NoDiscordClientException ex) {
            SDRP.LOGGER.info("Discord client was not found.");
        }
    }

    public static void stop() {
        if (timerTask != null) {
            timerTask.cancel();
            timerTask = null;
        }
        try {
            CLIENT.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        errorCount = 0;
        isEnabled = false;
        SDRP.LOGGER.info("Discord client closed.");
    }

    public static void setDimension(World world) {
        State dim = map.get(world.func_234923_W_().func_240901_a_().toString());
        if (dim != null) {
            DiscordRichPresence.setState(dim);
        } else if (dim == null) {
            String name = I18n.func_135052_a((String)("sdrp." + world.func_234923_W_().func_240901_a_().func_110623_a()), (Object[])new Object[0]);
            String in = I18n.func_135052_a((String)("sdrp." + world.func_234923_W_().func_240901_a_().func_110623_a() + ".in"), (Object[])new Object[0]);
            String key = world.func_234923_W_().func_240901_a_().func_110623_a();
            State dim2 = new State(in, name, key);
            DiscordRichPresence.setState(dim2);
        }
    }

    public static void setState(State state) {
        block6: {
            currentState = state;
            RichPresence.Builder builder = new RichPresence.Builder();
            builder.setState(state.message);
            builder.setStartTimestamp(TIME);
            String name = I18n.func_135052_a((String)"sdrp.logo", (Object[])new Object[0]);
            builder.setLargeImage("logo", name);
            builder.setSmallImage(state.imageKey, state.imageName);
            try {
                CLIENT.sendRichPresence(builder.build());
            }
            catch (Exception ex) {
                SDRP.LOGGER.error((Object)ex);
                try {
                    CLIENT.connect(new DiscordBuild[0]);
                    errorCount = 0;
                    CLIENT.sendRichPresence(builder.build());
                }
                catch (Exception ex2) {
                    try {
                        CLIENT.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (++errorCount <= 10) break block6;
                    SDRP.LOGGER.info("DiscordRP connection failed.");
                    DiscordRichPresence.stop();
                }
            }
        }
    }

    public static boolean isEnabled() {
        return isEnabled;
    }

    public static State getCurrent() {
        return currentState;
    }

    static {
        CLIENT = new IPCClient((Long)Config.CONFIG.clientID.get());
        isEnabled = false;
        errorCount = 0;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DiscordRichPresence.stop(), "DiscordRP Stop"));
        map = new HashMap();
        map.put("loading", new State("Starting Minecraft", "Starting Minecraft", "loading"));
        map.put("menu", new State("Main Menu", "Main Menu", "menu"));
    }

    public static class State {
        public String message;
        public String imageName;
        public String imageKey;

        public State(String m, String n, String k) {
            this.message = m;
            this.imageName = n;
            this.imageKey = k;
        }
    }
}

