/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.stream.Stream;
import mcjty.lib.varia.DimensionId;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class WorldTools {
    public static boolean isLoaded(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        return world.func_175667_e(pos);
    }

    public static ServerWorld getOverworld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.func_71218_a(World.field_234918_g_);
    }

    public static ServerWorld getOverworld(World world) {
        MinecraftServer server = world.func_73046_m();
        return server.func_71218_a(World.field_234918_g_);
    }

    public static ServerWorld loadWorld(DimensionId type) {
        ServerWorld world = WorldTools.getWorld(type);
        if (world == null) {
            return type.loadWorld();
        }
        return world;
    }

    public static ServerWorld getWorld(DimensionId type) {
        return type.getWorld();
    }

    public static ServerWorld getWorld(World world, DimensionId type) {
        return type.loadWorld(world);
    }

    public static Stream<ServerPlayerEntity> getAllPlayersWatchingBlock(World world, BlockPos pos) {
        if (world instanceof ServerWorld) {
            ChunkManager playerManager = ((ServerWorld)world).func_72863_F().field_217237_a;
            return playerManager.func_219097_a(new ChunkPos(pos), false);
        }
        return Stream.empty();
    }
}

