/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

public class OrientationTools {
    public static Direction[] DIRECTION_VALUES = Direction.values();
    public static Direction[] HORIZONTAL_DIRECTION_VALUES = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};

    public static Direction rotateAround(Direction input, Direction.Axis axis) {
        switch (axis) {
            case X: {
                if (input != Direction.WEST && input != Direction.EAST) {
                    return OrientationTools.rotateX(input);
                }
                return input;
            }
            case Y: {
                if (input != Direction.UP && input != Direction.DOWN) {
                    return input.func_176746_e();
                }
                return input;
            }
            case Z: {
                if (input != Direction.NORTH && input != Direction.SOUTH) {
                    return OrientationTools.rotateZ(input);
                }
                return input;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axis);
    }

    private static Direction rotateX(Direction input) {
        switch (input) {
            case NORTH: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + input);
            }
            case SOUTH: {
                return Direction.UP;
            }
            case UP: {
                return Direction.NORTH;
            }
            case DOWN: 
        }
        return Direction.SOUTH;
    }

    private static Direction rotateZ(Direction input) {
        switch (input) {
            case EAST: {
                return Direction.DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + input);
            }
            case WEST: {
                return Direction.UP;
            }
            case UP: {
                return Direction.EAST;
            }
            case DOWN: 
        }
        return Direction.WEST;
    }

    public static Direction getOrientationHoriz(BlockState state) {
        return (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
    }

    public static Direction getOrientation(BlockState state) {
        return ((BaseBlock)state.func_177230_c()).getFrontDirection(state);
    }

    public static Direction determineOrientation(BlockPos pos, LivingEntity entity) {
        return OrientationTools.determineOrientation(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entity);
    }

    public static Direction determineOrientation(int x, int y, int z, LivingEntity entity) {
        int i;
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.func_226277_ct_() - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.func_226281_cx_() - (float)z)) < 2.0f) {
            double d0 = entity.func_226278_cu_() + 1.82 - entity.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return Direction.UP;
            }
            if ((double)y - d0 > 0.0) {
                return Direction.DOWN;
            }
        }
        return (l = ((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5 < (double)(i = (int)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) ? i - 1 : i) & 3) == 0 ? Direction.NORTH : (l == 1 ? Direction.EAST : (l == 2 ? Direction.SOUTH : (l == 3 ? Direction.WEST : Direction.DOWN)));
    }

    public static Direction determineOrientationHoriz(LivingEntity MobEntity) {
        int i = (int)((double)(MobEntity.field_70177_z * 4.0f / 360.0f) + 0.5);
        int l = ((double)(MobEntity.field_70177_z * 4.0f / 360.0f) + 0.5 < (double)i ? i - 1 : i) & 3;
        return l == 0 ? Direction.NORTH : (l == 1 ? Direction.EAST : (l == 2 ? Direction.SOUTH : (l == 3 ? Direction.WEST : Direction.DOWN)));
    }

    public static Direction getTopDirection(Direction rotation) {
        switch (rotation) {
            case DOWN: {
                return Direction.SOUTH;
            }
            case UP: {
                return Direction.NORTH;
            }
        }
        return Direction.UP;
    }

    public static Direction getBottomDirection(Direction rotation) {
        switch (rotation) {
            case DOWN: {
                return Direction.NORTH;
            }
            case UP: {
                return Direction.SOUTH;
            }
        }
        return Direction.DOWN;
    }

    public static Direction getFacingFromEntity(BlockPos clickedBlock, @Nullable Entity entityIn) {
        if (entityIn == null) {
            return Direction.UP;
        }
        if (MathHelper.func_76135_e((float)((float)entityIn.func_226277_ct_() - (float)clickedBlock.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entityIn.func_226281_cx_() - (float)clickedBlock.func_177952_p())) < 2.0f) {
            double d0 = entityIn.func_226278_cu_() + (double)entityIn.func_70047_e();
            if (d0 - (double)clickedBlock.func_177956_o() > 2.0) {
                return Direction.UP;
            }
            if ((double)clickedBlock.func_177956_o() - d0 > 0.0) {
                return Direction.DOWN;
            }
        }
        return entityIn.func_174811_aO().func_176734_d();
    }
}

