/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class DimensionId {
    private final RegistryKey<World> id;
    private static final Lazy<DimensionId> OVERWORLD = Lazy.of(() -> new DimensionId((RegistryKey<World>)World.field_234918_g_));
    private static final Lazy<DimensionId> NETHER = Lazy.of(() -> new DimensionId((RegistryKey<World>)World.field_234919_h_));
    private static final Lazy<DimensionId> END = Lazy.of(() -> new DimensionId((RegistryKey<World>)World.field_234920_i_));

    private DimensionId(RegistryKey<World> id) {
        this.id = id;
    }

    public static DimensionId overworld() {
        return (DimensionId)OVERWORLD.get();
    }

    public static DimensionId nether() {
        return (DimensionId)NETHER.get();
    }

    public static DimensionId end() {
        return (DimensionId)END.get();
    }

    public static DimensionId fromId(RegistryKey<World> id) {
        return new DimensionId(id);
    }

    public static DimensionId fromPacket(PacketBuffer buf) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        return new DimensionId((RegistryKey<World>)key);
    }

    public static DimensionId fromWorld(World world) {
        return new DimensionId((RegistryKey<World>)world.func_234923_W_());
    }

    public static DimensionId fromResourceLocation(ResourceLocation location) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)location);
        return new DimensionId((RegistryKey<World>)key);
    }

    public RegistryKey<World> getId() {
        return this.id;
    }

    public ResourceLocation getRegistryName() {
        return this.id.func_240901_a_();
    }

    public String getName() {
        return this.id.func_240901_a_().func_110623_a();
    }

    public boolean isOverworld() {
        return this.id.equals((Object)World.field_234918_g_);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_192572_a(this.id.func_240901_a_());
    }

    public ServerWorld loadWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.func_71218_a(this.id);
    }

    public ServerWorld getWorld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.func_71218_a(this.id);
    }

    public ServerWorld loadWorld(World otherWorld) {
        return otherWorld.func_73046_m().func_71218_a(this.id);
    }

    public static boolean sameDimension(World world1, World world2) {
        return world1.func_234923_W_().equals(world2.func_234923_W_());
    }

    public boolean sameDimension(World world) {
        return this.id.equals((Object)world.func_234923_W_());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionId that = (DimensionId)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

